<table>
    <thead>
        <tr>
            <th style="font-size: 16px;"><strong>Automatic Restocking System (ARS)</strong></th>
        </tr>
    </thead>

    <tbody>
        <tr>
            <td>Period : {{ $period }}</td>
        </tr>
    </tbody>
</table>

<table>
    <thead>
        <tr>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Warehouse') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Code') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Barcode') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Name') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Brand') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Category') }}</strong></th>
            <th scope="col" style="vertical-align: middle;"><strong>{{ __('Size') }}</strong></th>
            <th scope="col" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('OnHand') }}</strong>
            </th>
            <th scope="col" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Sales') }}</strong>
            </th>
            <th scope="col" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Recommend') }}</strong>
            </th>
            <th scope="col" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Info') }}</strong>
            </th>
        </tr>
    </thead>

    <tbody>
        @foreach ($data as $item)
            <tr>
                <td scope="col">{{ $item->whs_name }}</td>
                <td scope="col">{{ $item->code }}</td>
                <td scope="col">{{ $item->barcode }}</td>
                <td scope="col">{{ $item->name }}</td>
                <td scope="col">{{ $item->brand }}</td>
                <td scope="col">{{ $item->category }}</td>
                <td scope="col">{{ $item->size }}</td>
                <td scope="col">{{ number_format($item->onhand) }}</td>
                <td scope="col">{{ number_format($item->sales) }}</td>
                <td scope="col">{{ number_format(abs($item->recommend)) }}</td>
                <td scope="col">
                    @if ($item->recommend > 0)
                        Transfer
                    @elseif ($item->recommend < 0)
                        Return
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
