<table>
    <thead>
        <tr>
            <th style="font-size: 16px;"><strong>Loss Sales Report</strong></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>Period : {{ $period }}</td>
        </tr>
    </tbody>
</table>

<table>
    <thead>
        <tr>
            <th scope="col" rowspan="2" style="vertical-align: middle;"><strong>{{ __('Warehouse') }}</strong></th>
            <th scope="col" rowspan="2" style="vertical-align: middle;"><strong>{{ __('ItemCode') }}</strong></th>
            {{-- <th scope="col" rowspan="2" style="vertical-align: middle;"><strong>{{ __('CodeBars') }}</strong></th> --}}
            <th scope="col" rowspan="2" style="vertical-align: middle;"><strong>{{ __('ItemName') }}</strong></th>
            <th scope="col" rowspan="2" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Total Sales') }}</strong>
            </th>
            <th scope="col" rowspan="2" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Stock 0 Days') }}</strong>
            </th>
            <th scope="col" rowspan="2" style="text-align: center; vertical-align: middle;">
                <strong>{{ __('Lost Sales') }}</strong>
            </th>
            @foreach ($dates as $date)
                <th scope="col" colspan="2" style="text-align: center;"><strong>
                        {{ \Carbon\Carbon::parse($date)->format('j F Y') }}</strong></th>
            @endforeach

        </tr>
        <tr>
            @foreach ($dates as $date)
                <th scope="col" style="text-align: center;"><strong>
                        {{ __('Sales') }}</strong></th>
                <th scope="col" style="text-align: center;"><strong>
                        {{ __('Stock') }}</strong></th>
            @endforeach
        </tr>
    </thead>

    <tbody>
        @php
            $total_losssales = 0;
        @endphp
        @foreach ($data as $item)
            <tr>
                <td scope="col">{{ $item->whs }}</td>
                <td scope="col">{{ $item->code }}</td>
                {{-- <td scope="col">{{ $item->barcode }}</td> --}}
                <td scope="col">{{ $item->name }}</td>
                <td scope="col" class="text-center">{{ number_format($item->salestotal) }}</td>
                <td scope="col" class="text-center">{{ number_format($item->stocknullcount) }}</td>
                <td scope="col" class="text-center">{{ number_format($item->losssales) }}</td>
                @foreach ($dates as $date)
                    @php
                        $formattedDate = \Carbon\Carbon::parse($date)->format('ymd');
                        $salesColumn = 'sales' . $formattedDate;
                        $stockColumn = 'stock' . $formattedDate;
                    @endphp

                    <td scope="col" class="text-center">
                        {{ number_format($item->$salesColumn) }}
                    </td>
                    <td scope="col" class="text-center">
                        {{ number_format($item->$stockColumn) }}
                    </td>
                @endforeach
                @php
                    $total_losssales += $item->losssales;
                @endphp
            </tr>
        @endforeach
    </tbody>

    <tfoot>
        <tr>
            <th colspan="5"><strong>Total</strong></th>
            <th><strong>{{ $total_losssales }}</strong></th>
        </tr>
    </tfoot>
</table>
