@extends('layouts.app')

@section('content')
    <style>
        .container {
            max-width: 1775px;
        }
    </style>
    <div class="sales-emp-page">
        <div class="row justify-content-center">
            <div class="col">
                <div>
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="title-page mb-0 fw-bolder">{{ __('Sales Employee') }}</h5>
                        <div class="logo">
                            <img src="{{ asset('assets/SoftComp - Logo-01.png') }}" alt="Image Description">
                        </div>
                        {{-- <a href="{{ route('welcome.dashboard') }}" class="btn badge btn-primary">POS</a> --}}
                    </div>
                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success" role="alert">
                                {{ session('status') }}
                            </div>
                        @endif
                        <livewire:pos.employee.emp-index />
                    </div>
                </div>
            </div>
        </div>
    </div>

    @if ($istutorials)
        <script>
            const salesEmpPopup = () => {
                const driver = window.driver.js.driver;
                const driverObj = driver({
                    showProgress: true,
                    steps: [
                        {
                            element: '.sales-emp-pop',
                            popover: {
                                description: 'The store staff menu is used to manage your store employees.'
                            }
                        },
                        {
                            element: '.add-sales-emp-pop',
                            popover: {
                                description: 'Click the button to add your store staff.'
                            }
                        },
                        {
                            element: '.go-pricelist-pop',
                            popover: {
                                description: 'After adding store staff, now you need to manage the product inventory in the "product" menu. There you can manage master products, pricelists, brands, categories, sizes. In addition, you can also manage sales promotions and goods receipt/return.'
                            }
                        },
                        {
                            element: '.description-add-pricelist-pop',
                            popover: {
                                description: 'First, you need to create a list of product brands you sell. Click the product menu, then the brand list menu.'
                            }
                        },
                    ],
                    onDeselected: () => {
                        $.ajax({
                            type: "POST",
                            url: '/update-status-driver',
                            data: {
                                menu: "SalesEmployee",
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                            },
                            error: function(data, textStatus, errorThrown) {
                            },
                        });
                    }
                });

                driverObj.drive();
            }
        </script>
    @endif
@endsection
