<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Status Update</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            background-color: #ffffff;
            margin: 20px auto;
            padding: 20px;
            max-width: 600px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .status-update-container {
            text-align: center;
            margin: 20px 0;
        }
        .btn-verify {
            display: inline-block;
            background-color: #007bff;
            color: black;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
        }
        .alert {
            margin-top: 20px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #888888;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="status-update-container">
            <p>Dear <strong>{{ $company->name }}</strong>,</p>
            <p>We wanted to inform you that the payment status for your order <strong>{{ $orderId }}</strong> has been updated to <strong>{{ $status }}</strong>.</p>

            @if ($status === 'success')
                <div class="alert alert-success">
                    Your payment was successful! Thank you for your order.
                </div>
            @elseif ($status === 'pending')
                <div class="alert alert-warning">
                    Your payment is currently pending. Please wait for further updates.
                </div>
            @elseif ($status === 'failed')
                <div class="alert alert-danger">
                    Unfortunately, your payment has failed. Please try again or contact support.
                </div>
            @endif

            <div>
                <button class="btn-verify"><a href="{{ route('paymentrenew') }}"  style="text-decoration: none; color: white;">View Order Details</a></button>
            </div>

            <hr>

        </div>
        <div class="footer">
            <p>Thank you for using our service!</p>
            <p>&copy; {{ date('Y') }} Softcomp. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
