<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscription Expiration Reminder</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            background-color: #ffffff;
            margin: 20px auto;
            padding: 20px;
            max-width: 600px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            padding: 20px 0;
        }
        .header h1 {
            color: #333333;
        }
        .content {
            margin: 20px 0;
        }
        .content p {
            font-size: 16px;
            color: #555555;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            color: #888888;
            font-size: 12px;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            color: white;
            font-size: 14px;
            font-weight: bold;
            margin: 10px 5px;
        }
        .btn-renew {
            background-color: #28a745;
        }
        .btn-whatsapp {
            background-color: #25d366;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Subscription Renewal Notification</h1>
        </div>
        <div class="content">
            <p>Dear. {{ $company->name }}</p>
            <p>We would like to remind you that your subscription is approaching its renewal date. To avoid service interruption, please take the time to renew your subscription.</p>
            <p>If you need assistance with the renewal process or have any questions, please feel free to contact us.</p>
            <p>
                <a href="{{ route('login') }}" class="btn btn-renew">Renew Subscription</a>
                <a href="https://wa.me/6285117031010?text=Hello,%20Saya%20butuh%20bantuan%20dengan%20subscription." class="btn btn-whatsapp">Contact Us on WhatsApp</a>
            </p>
        </div>
        <div class="footer">
            <p>Thank you for using our service!</p>
            <p>&copy; {{ date('Y') }} Softcomp. All rights reserved.</p>
        </div>
    </div>
    
</body>
</html>
