@extends('layouts.header')

@section('content')
    <style>
        .container {
            max-width: 1920px;
        }

        .container .row .card {
            width: 500px;
            margin: 30px;
            background: rgba(255, 255, 255, 0.1);
            overflow: hidden;
            backdrop-filter: blur(5px);
            border-top: 1px solid rgba(255, 255, 255, 0.5);
            border-left: 1px solid rgba(255, 255, 255, 0.5);
            border-radius: 15px;
        }

        .container .row .card .card-body {
            padding: 1rem 1.2rem;
        }

        .container .row .card .card-body .card-img img {
            width: 60px;
            height: 60px;
            object-fit: cover;
            transform: translateY(50px);
            transition: 0.5s;
            border-radius: 50%
        }

        .container .row .card .card-body .name {
            transform: translateY(50px);
            transition: 0.5s
        }

        html,
        body {
            height: 100%;
            margin: 0;
            padding: 0;
            font-family: 'Poppins', sans-serif;
        }

        .btn-google {
            background: rgba(255, 255, 255, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(5px);
            color: #000;
            transition: all 0.3s ease;
            padding: 0.5rem 1rem;
        }

        .btn-google:hover {
            background-color: rgba(255, 255, 255, 0.3);
            transform: scale(1.02);
        }
    </style>

    <div class="container login-container bg-home">
        <div class="d-flex justify-content-between" style="margin-inline: 7rem">
            <div>
                <div class="logo-home mt-4">
                    <img src="{{ asset('assets/Logo Softcomp - RGB-01.png') }}" alt="Image Description">
                </div>
            </div>
        </div>
        <div class="row justify-content-center align-items-center pt-4" style="min-height: 80vh">
            <div class="col-lg-4 d-flex justify-content-center">
                <div class="login-card" style="padding: 3rem;">
                    <div class="card-body">
                        <div class="get-started">
                            Get Started
                        </div>
                        <h3 class="fs-6">Welcome back! Please enter your details.</h3>
                        <div class="card-text">
                            <form method="POST" action="{{ route('logins') }}" class="pt-4">
                                @if ($errors->any())
                                    <div class="mx-2 alert alert-danger">
                                        <span>
                                            @foreach ($errors->all() as $error)
                                                {{ $error }}
                                            @endforeach
                                        </span>
                                    </div>
                                @endif
                                @csrf
                                <div class="mb-3">
                                    <label for="inputusername" class="form-label d-flex justify-start"
                                        style="margin-left: 7px">Username</label>
                                    <input type="text" name="username" class="form-control rounded-pill"
                                        id="inputusername" placeholder="Username"
                                        @if (isset($_COOKIE['name'])) value="{{ $_COOKIE['name'] }}" @endif>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="inputPassword" class="form-label d-flex justify-start"
                                        style="margin-left: 7px">Password</label>
                                    <input type="password" name="password" class="form-control rounded-pill"
                                        id="inputPassword" placeholder="Password"
                                        @if (isset($_COOKIE['password'])) value="{{ $_COOKIE['password'] }}" @endif>
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="bot-login">
                                    <div class="mb-3 form-check d-flex justify-start gap-2">
                                        <input type="checkbox" class="form-check-input" id="check" name="remember"
                                            @if (isset($_COOKIE['name'])) checked @endif>
                                        <label class="form-check-label" for="check">Remember me</label>
                                    </div>
                                </div>
                                <div class="bot-login text-center">
                                    <span>Don't Have an Account? <a href="{{ url('https://softcomp.io/register') }}">Register here</a></span>
                                    <br><a href="{{ route('forgotpassword') }}"><span>Reset Password</span></a>
                                </div>
                                <div class="d-grid gap-2 col-4 mx-auto mt-4 mb-2">
                                    <button class="custom-button1 rounded-pill" type="submit">Submit</button>
                                </div>
                            </form>

                            <div class="text-center mt-4">
                                <a href="{{ route('auth.google') }}"
                                   class="btn btn-google rounded-pill d-flex align-items-center justify-content-center gap-2">
                                    <img src="https://developers.google.com/identity/images/g-logo.png" alt="Google Logo"
                                         width="20" height="20">
                                    <span>Login with Google</span>
                                </a>
                            </div>
                        </div>
                        <livewire:test.testpageexp />
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
