@extends('layouts.app')

@section('content')
<style>
    .container {
        max-width: 1775px;
    }
</style>
<div>
    <div class="row justify-content-center">
        <div class="col">
            <div>
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="title-page mb-0 fw-bolder">{{ __('Activity Logs') }}</h5>
                    <div class="logo">
                        <img src="{{asset('assets/SoftComp - Logo-01.png')}}" alt="Image Description">
                    </div>
                </div>
                {{-- <div class="card-header">{{ __('Logs Table') }}</div> --}}

                <nav class="page-breadcrumb">
                    <div class="d-flex justify-content-between align-items-center breadcrumb-cashier">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a livewire:navigate href="/">{{ __('Main') }}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">
                                {{ __('Logs') }}
                            </li>
                        </ol>
                    </div>
                </nav>

                <div class="card-body pt-5" id="cashier">
                    <div class="table-responsive" id="my-table-logs">
                        <table id="example" class="my-table" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center" style="border-top-left-radius: 1rem">Activity</th>
                                    <th class="text-center">Description</th>
                                    <th class="text-center">Caused By</th>
                                    <th class="text-center">Before</th>
                                    <th class="text-center">After</th>
                                    <th class="text-center" style="border-top-right-radius: 1rem">Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($activities as $activity)
                                <tr>
                                    <td class="text-center">{{  ucfirst($activity->event) }} {{ $activity->log_name }}</td>
                                    <td>{{ $activity->description }}</td>
                                    <td class="text-center">{{ $activity->causer->username }}</td>
                                    @if($activity->event === 'updated')
                                    <td>
                                        @if(is_array($activity->changes['old']))
                                            @if (isset($activity->changes['old']['qty']))
                                                Quantity : {{ $activity->changes['old']['qty'] }} <br>
                                            @endif
    
                                            @if (isset($activity->changes['old']['total_price']))
                                                Total Price : {{ $activity->changes['old']['total_price'] }} <br>
                                            @endif
                                        @endif
                                    </td>
                                    <td>
                                        @if(is_array($activity->changes['attributes']))
                                            @if (isset($activity->changes['attributes']['qty']))
                                                Quantity : {{ $activity->changes['attributes']['qty'] }} <br>
                                            @endif
    
                                            @if (isset($activity->changes['attributes']['total_price']))
                                                Total Price : {{ $activity->changes['attributes']['total_price'] }} <br>
                                            @endif
                                        @endif
                                    </td>
                                @else
                                    <td>
                                        @if(is_array($activity->changes['old']))
                                            @php
                                                $newKeys = [
                                                    'code' => 'Code',
                                                    'name' => 'Name',
                                                    'price' => 'Price',
                                                    'qty' => 'Quantity',
                                                    'id_member' => 'Member',
                                                    'total_price' => 'Total Price',
                                                    'created_at' => 'Scanned',
                                                ];
                                            @endphp
    
                                            @foreach($activity->changes['old'] as $key => $itemChange)
                                                @if($key === 'created_at')
                                                    {{ $newKeys[$key] }} : {{ \Carbon\Carbon::parse($itemChange)->format('l, d F Y, H:i:s') }} <br>
                                                @elseif(isset($newKeys[$key]))
                                                    {{ $newKeys[$key] }} : {{ $itemChange }} <br>
                                                @else
                                                    {{ $key }} : {{ $itemChange }} <br>
                                                @endif
                                            @endforeach
                                        @endif
                                    </td>
                                    <td class="text-center">
                                        Deleted
                                    </td>
                                @endif
    
                                    <td>{{ $activity->formatted_created_at }}</td>
                                   
                                </tr>
                                @empty
    
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
