<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\DB;

class UniqueCompanyCode implements Rule
{
    protected $table;
    protected $companyCode;
    protected $ignoreId;

    /**
     * Create a new rule instance.
     *
     * @param  string  $table
     * @param  string  $companyCode
     * @param  mixed  $ignoreId
     * @return void
     */
    public function __construct(string $table, string $companyCode, $ignoreId = null)
    {
        $this->table = $table;
        $this->companyCode = $companyCode;
        $this->ignoreId = $ignoreId;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $query = DB::table($this->table)
            ->where($attribute, $value)
            ->where('company_code', $this->companyCode);

        if ($this->ignoreId !== null) {
            $query->where('id', '!=', $this->ignoreId);
        }

        return $query->count() === 0;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The :attribute must be unique within the company.';
    }
}
