<?php

namespace App\Providers;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\ServiceProvider;
use Maatwebsite\Excel\Sheet;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Blade::if('routeIs', function ($route) {
            return request()->route()->getName() === $route;
        });

        Blade::if('admin', function () {
            return Auth::check() && Auth::user()->role == 'Admin'; 
        });

        Blade::if('kasir', function () {
            return Auth::check() && Auth::user()->role == 'Cashier'; 
        });

        Blade::if('gudang', function () {
            return Auth::check() && Auth::user()->role == 'Gudang'; 
        });

        Blade::if('pro', function () {
            $user = Auth::user();
            $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();

            if (Auth::check() && $company) {
                if($company->plan != 'Basic') {
                    return true;
                }
            }
            return false;
        });
        
        Sheet::macro('styleCells', function (Sheet $sheet, string $cellRange, array $style) {
            $sheet->getDelegate()->getStyle($cellRange)->applyFromArray($style);
        });

        view()->composer(
            ['layouts.app'],
            function ($view) {
                $rateLogout = true;
    
                $user = Auth::user();
                if ($user) {
                    $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
                    $nps = DB::table('Luv2_nps')->where('company_code', $user->company_code)->first();
    
                    if (!$company && isset($company->verified_at)) {
                        if (Carbon::parse($company->verified_at)->lte(now()->subMonths(3))) {
                            $rateLogout = true;
                        }
                    }
    
                    if ($nps) {
                        $rateLogout = false;
                    }
                }
    
                $view->with('rateLogout', $rateLogout);
            }
        );
    }
}
