<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Member extends Model
{
    use HasFactory;

    protected $table = 'Luv2_member';
    protected $primaryKey = 'code';

    public $incrementing = false;

    protected $keyType = 'string';

    protected $fillable = [
        'company_code',
        'code', 
        'name',
        'phone',
        'email',
        'address',
        'active',
        'hobby',
        'created_at',
    ];
    protected $appends = [
        'formatted_created_at',
    ];

    public function getFormattedCreatedAtAttribute(): string {
        return $this->created_at->isoFormat('dddd, D MMMM YYYY, HH:mm:ss');
    }

    public function carts()
    {
        return $this->hasMany(Cart::class, 'member_code', 'code');
    }

    public function detailInvoices()
    {
        return $this->hasMany(DetailInvoice::class, 'member_code', 'code');
    }
    
    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'member_code', 'code');
    }
}
