<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class VerifyEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $companyname;
    public $companycode;

    /**
     * Create a new message instance.
     */
    public function __construct($name, $username, $companycode)
    {
        $this->name = $username;
        $this->companyname = $name;
        $this->companycode = $companycode;

        Log::info('VerifyEmail mailable data:', [
            'name' => $this->name,
            'companyname' => $this->companyname,
            'companycode' => $this->companycode,
        ]);
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Verify Your Account and Company'
        );
    }

    public function build()
    {

        return $this->view('email.verify')
            ->with([
                'name' => $this->name,
                'companyname' => $this->companyname,
                'companycode' => $this->companycode,
            ]);
    }
}
