<?php

namespace App\Mail;

use App\Models\Settings;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;

class MyTestMail extends Mailable
{
    use Queueable, SerializesModels;
    public $selisih;
    public $toko;

    /**
     * Create a new message instance.
     */


    public function __construct($data,$toko)
    {
        $selisih = abs($data['subtotal']);
        $this->selisih = $selisih;
        $this->toko = $toko;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Manual Journal Entry Mail',
        );
    }

    /**
     * Get the message content definition.
     */

    public function build()
    {
        return $this->view('report.emails')
        ->with([
            'data' => $this->selisih,
            'toko' => $this->toko,
        ]);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
