<?php

namespace App\Livewire\Warehouse;

use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;

class ModalWarehouse extends Component
{

    public $pricelist;
    #[Rule('required|string|max:255|unique:Luv2_warehouse,code')]
    public $code;
    #[Rule('required|string|max:255')]
    public $name;
    #[Rule('required|string|max:255')]
    public $pricelist_code;
    #[Rule('required|string|max:255')]
    public $address;
    #[Rule('required|string|max:255')]
    public $phone;
    #[Rule('required|email|max:255')]
    public $email;
    #[Rule('nullable|string')]
    public $receipt_footer;
    public $codewarehouse;
    public $pricelist_codenew;
    public $pricelist_name;
    public $isCreateNewPricelist = false;
    public $whs_central = 'N';
    public $centralWarehouseExists = false;
    public $existingCentralWarehouse = null;

    use LivewireAlert;

    public function render()
    {
        return view('livewire.warehouse.modal-warehouse');
    }

    public function mount()
    {
        $this->pricelist = DB::table('Luv2_pricelist')->where('company_code', Auth::user()->company_code)->get();
        $this->checkExistingCentralWarehouse();
    }

    public function checkExistingCentralWarehouse()
    {
        $existingWarehouse = DB::table('Luv2_warehouse')
            ->where('company_code', auth()->user()->company_code)
            ->where('whs_central', 'Y')
            ->when($this->codewarehouse != '', function ($query) {
                return $query->where('code', '!=', $this->codewarehouse);
            })
            ->first();

        $this->centralWarehouseExists = !is_null($existingWarehouse);
        $this->existingCentralWarehouse = $existingWarehouse;
    }

    #[On('bringEditCode')]
    public function getDataFromIndex($codewarehouse)
    {
        $this->codewarehouse = $codewarehouse;
        if ($this->codewarehouse != '') {
            $warehouse = DB::table('Luv2_warehouse')->where('company_code', auth()->user()->company_code)->where('code', $this->codewarehouse)->first();
            $this->code = $warehouse->code;
            $this->name = $warehouse->name;
            $this->pricelist_code = $warehouse->pricelist_code;
            $this->address = $warehouse->address;
            $this->email = $warehouse->email;
            $this->phone = $warehouse->phone;
            $this->receipt_footer = $warehouse->footer;
            $this->whs_central = $warehouse->whs_central == 'Y' ? 'Y' : 'N';
            $this->checkExistingCentralWarehouse();
        }
    }

    public function saveWarehouse()
    {
        if ($this->codewarehouse != '') {
            $warehouse = DB::table('Luv2_warehouse')
                ->where('company_code', auth()->user()->company_code)
                ->where('code', $this->codewarehouse)
                ->first();

            if ($warehouse) {
                if ($this->whs_central == 'Y' && $this->centralWarehouseExists) {
                    // Update previous central warehouse to N
                    DB::table('Luv2_warehouse')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('whs_central', 'Y')
                        ->where('code', '!=', $this->codewarehouse)
                        ->update(['whs_central' => 'N']);

                    $this->alert('info', 'Status warehouse utama sebelumnya telah diubah', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }

                DB::table('Luv2_warehouse')
                    ->where('company_code', auth()->user()->company_code)
                    ->where('code', $this->codewarehouse)
                    ->update([
                        'name' => $this->name,
                        'pricelist_code' => $this->pricelist_code,
                        'address' => $this->address,
                        'phone' => $this->phone,
                        'email' => $this->email,
                        'footer' => $this->receipt_footer,
                        'whs_central' => $this->whs_central,
                        'active' => 'Y',
                        'updated_at' => now(),
                    ]);

                $this->alert('success', 'Warehouse berhasil diupdate', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->validate();

            if ($this->whs_central == 'Y' && $this->centralWarehouseExists) {
                // Update previous central warehouse to N
                DB::table('Luv2_warehouse')
                    ->where('company_code', auth()->user()->company_code)
                    ->where('whs_central', 'Y')
                    ->update(['whs_central' => 'N']);

                $this->alert('info', 'Status warehouse utama sebelumnya telah diubah', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }

            Warehouse::create([
                'company_code' => auth()->user()->company_code,
                'code' => $this->code,
                'name' => $this->name,
                'pricelist_code' => $this->isCreateNewPricelist ? $this->pricelist_codenew : $this->pricelist_code,
                'address' => $this->address,
                'phone' => $this->phone,
                'email' => $this->email,
                'footer' => $this->receipt_footer,
                'whs_central' => $this->whs_central,
                'active' => 'Y',
            ]);

            $this->alert('success', 'Warehouse berhasil dibuat', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            if ($this->isCreateNewPricelist) {
                DB::table('Luv2_pricelist')->insert([
                    'company_code' => Auth::user()->company_code,
                    'code' => $this->pricelist_codenew,
                    'name' => $this->pricelist_name,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);
            }
        }

        $this->resetForm();
        $this->dispatch('refreshData')->to(TableWarehouse::class);
        $this->dispatch('closeModalWarehouse')->to(IndexWarehouse::class);
        $this->dispatch('refreshjs')->to(IndexWarehouse::class);
        $this->dispatch('refresh-modal');
    }

    public function updatedPricelistCode()
    {
        if ($this->pricelist_code == 'PricelistCN') {
            $this->isCreateNewPricelist = true;
        } else {
            $this->isCreateNewPricelist = false;
            $this->pricelist_codenew = '';
        }
    }

    public function updatedWhsCentral($value)
    {
        $this->whs_central = $value ? 'Y' : 'N';
        $this->checkExistingCentralWarehouse();
    }

    public function resetForm()
    {
        $this->code = '';
        $this->name = '';
        $this->pricelist_code = '';
        $this->address = '';
        $this->phone = '';
        $this->email = '';
        $this->receipt_footer = '';
        $this->codewarehouse = '';
        $this->whs_central = 'N';
        $this->checkExistingCentralWarehouse();
    }
}
