<?php

namespace App\Livewire\Warehouse;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class IndexWarehouse extends Component
{
    public $notPro = false;

    use LivewireAlert;

    public function mount()
    {
        $user = Auth::user();
        $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
        if($company->plan == 'Basic') {
            $this->notPro = true;
        }else{
            $this->notPro = false;
        }
    }
    public function render()
    {
        return view('livewire.warehouse.index-warehouse');
    }

    #[On('refreshjs')]
    public function refreshjs()
    {
        $this->dispatch('refreshjs');
    }

    #[On('closeModalWarehouse')]
    public function closeModalWarehouse()
    {
        $this->dispatch('closeModalWarehousebrowser');
    }

    public function thisNotPro()
    {
        $this->alert('warning', 'Upgrade ke pro untuk menabahkan toko baru!', [
            'position' => 'top-center',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->dispatch('redirectToPlan');
    }

    #[On('redirectToPlan')]
    public function notPro()
    {
        sleep(3);

        return redirect()->route('paymentrenew');
    }
}
