<?php

namespace App\Livewire\User;

use App\Models\User;
use Livewire\Component;

class UserIndex extends Component
{
    public function render()
    {
        $users = User::where('company_code', auth()->user()->company_code)
            ->where('role', '!=', 'Admin')
            ->get();
        $user = User::where('company_code', auth()->user()->company_code)
        ->get();
        return view('livewire.user.user-index', [
            'users' => $users,
            'user' => $user,
        ]);
    }
}
