<?php

namespace App\Livewire\Synchronization;

use App\Models\Settings;
use App\Models\User;
use App\Models\UserAuths;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Index extends Component
{

    use LivewireAlert;

    public $isloadingUser = false;
    public $isloadingAuth = false;
    public $isloadingWarehouse = false;
    public $isloadingSetting = false;
    public $testCheckbox;
    public $items = [];


    public function render()
    {
        // $sales = DB::table('Luv2_salesemp')->orderBy('name', 'desc')->get();

        // $this->items = $sales->map(function ($sales) {
        //     return [
        //         'code' => $sales->code,
        //         'name' => $sales->name,
        //         'checked' => $sales->active === 'Y',
        //     ];
        // })->toArray();

        // $this->testCheckbox = $sales->map(function ($sales) {
        //     return [
        //         'code' => $sales->code,
        //         'name' => $sales->name,
        //         'checked' => $sales->active === 'Y',
        //     ];
        // })->toArray();

        return view('livewire.synchronization.index');
    }

    // public function Cheeck($index)
    // {
    //     $this->testCheckbox[$index]['checked'] = !$this->testCheckbox[$index]['checked'];

    //     DB::table('Luv2_salesemp')
    //         ->where('code', $this->testCheckbox[$index]['code'])
    //         ->update(['active' => $this->testCheckbox[$index]['checked'] ? 'Y' : 'N']);

    // }


    public function test()
    {
        
        $user = Auth::user();
        $company_code = $user->company_code;
        $appurl = env('APP_URL');
        $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

        $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol . '/';
        // $user = Http::get($urladmin . 'user/' . $company_code)->json();
        // $warehouse = Http::get($urladmin . 'warehouse/30')->json();
        // $user_auth = Http::get($urladmin . 'user_auth/30')->json();
        $setting = Http::get($urladmin . 'setting/30')->json();

        dd($setting);
        
    }

    public function clickUser()
    {
        $this->isloadingUser = true;
        $this->dispatch('tosyncUser');
    }
    public function clickAuth()
    {
        $this->isloadingAuth = true;
        $this->dispatch('tosyncAuth');
    }
    public function clickWarehouse()
    {
        $this->isloadingWarehouse = true;
        $this->dispatch('tosyncWarehouse');
    }
    public function clickSetting()
    {
        $this->isloadingSetting = true;
        $this->dispatch('tosyncSetting');
    }

    #[On('tosyncUser')]
    public function syncUser()
    {
        $user = Auth::user();
        $company_code = $user->company_code;
        $appurl = env('APP_URL');
        $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

        $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol . '/';

        $user = Http::get($urladmin . 'user/' . $company_code)->json();
        foreach ($user as $item) {
            $existingUser = User::where('name', $item['username'])->first();
            
            if ($existingUser) {
                $existingUser->update([
                    'password' => $item['password'],
                    'id_company' => $item['id_company'],
                    'whs_code' => $item['whs_code'],
                    'active' => $item['active'],
                    'updated_at' => $item['updated_at'],
                ]);
            } else {
                User::create([
                    'name' => $item['username'],
                    'password' => $item['password'],
                    'id_company' => $item['id_company'],
                    'whs_code' => $item['whs_code'],
                    'active' => $item['active'],
                    'created_at' => $item['created_at'],
                    'updated_at' => $item['updated_at'],
                ]);
            }
        }
        $this->alert('success', 'Data user updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingUser = false;
    }

    #[On('tosyncAuth')]
    public function syncAuth()
    {
        $user = Auth::user();
        $company_code = $user->company_code;
        $appurl = env('APP_URL');
        $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

        $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol . '/';
        $userauth = Http::get($urladmin . 'user_auth/' . $company_code)->json();
        foreach ($userauth as $item) {
            $existingAuth = UserAuths::where('id_user', $item['id_user'])
                                    ->where('id_auth', $item['id_auth'])->first();
            
            if ($existingAuth) {
                $existingAuth->update([
                    'auth' => $item['auth'],
                    'updated_at' => $item['updated_at'],
                ]);
            } else {
                UserAuths::create([
                    'id_user' => $item['id_user'],
                    'id_auth' => $item['id_auth'],
                    'auth' => $item['auth'],
                    'created_at' => $item['created_at'],
                    'updated_at' => $item['updated_at'],
                    'id_company' => $item['id_company'],
                ]);
            }
        }
        $this->alert('success', 'Data user auth updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingAuth = false;
    }


    #[On('tosyncWarehouse')]
    public function syncWarehouse()
    {
        
        $user = Auth::user();
        $company_code = $user->company_code;
        $appurl = env('APP_URL');
        $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

        $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol. '/';
        $warehouse = Http::get($urladmin . 'warehouse/' . $company_code)->json();
        foreach ($warehouse as $item) {
            $existingWarehouse = DB::table('Luv2_warehouse')->where('code', $item['code'])->first();
            
            if ($existingWarehouse) {
                DB::table('Luv2_warehouse')->where('code', $item['code'])->update([
                    'name' => $item['name'],
                    'id_pricelist' => $item['id_pricelist'],
                    'cashacc' => $item['cashacc'],
                    'cardacc' => $item['cardacc'],
                    'active' => $item['active'],
                    'bpl_id' => $item['bpl_id'],
                    'sbu' => $item['sbu'], 
                    'cardcode' => $item['cardcode'], 
                    'address' => $item['address'], 
                    'phone' => $item['phone'], 
                    'email' => $item['email'], 
                    'footer' => $item['footer'], 
                ]);
            } else {
                DB::table('Luv2_warehouse')->insert([
                    'code' => $item['code'],
                    'name' => $item['name'],
                    'id_pricelist' => $item['id_pricelist'],
                    'cashacc' => $item['cashacc'],
                    'cardacc' => $item['cardacc'],
                    'active' => $item['active'],
                    'bpl_id' => $item['bpl_id'],
                    'sbu' => $item['sbu'], 
                    'cardcode' => $item['cardcode'], 
                    'address' => $item['address'], 
                    'phone' => $item['phone'], 
                    'email' => $item['email'], 
                    'footer' => $item['footer'], 

                ]);
            }
        }
        $this->alert('success', 'Data warehouse updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingWarehouse = false;
    }

    #[On('tosyncSetting')]
    public function syncSetting()
    {
        
        $user = Auth::user();
        $company_code = $user->company_code;
        $appurl = env('APP_URL');
        $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

        $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol . '/';
        $setting = Http::get($urladmin . 'setting/' . $company_code)->json();
        
        foreach ($setting as $item) {
            $existingSetting = DB::table('Luv2_settings')->where('id_company', $item['id_company'])->first();
            
            if ($existingSetting) {
                DB::table('Luv2_settings')->where('id_company', $item['id_company'])->update([
                    'id_company' => $item['id_company'],
                    'member' => $item['member'],
                    'member_pricelist' => $item['member_pricelist'],
                    'member_disc' => $item['member_disc'],
                    'auto_report' => $item['auto_report'],
                    'url' => $item['url'],
                    'email_sandbox' => $item['email_sandbox'],
                    'email_finance' => $item['email_finance'],
                    'member_prefix' => $item['member_prefix'],
                    'member_group' => $item['member_group'],
                ]);
            } else {
                Settings::create([
                    'id_company' => $item['id_company'],
                    'member' => $item['member'],
                    'member_pricelist' => $item['member_pricelist'],
                    'member_disc' => $item['member_disc'],
                    'auto_report' => $item['auto_report'],
                    'url' => $item['url'],
                    'email_sandbox' => $item['email_sandbox'],
                    'email_finance' => $item['email_finance'],
                    'member_prefix' => $item['member_prefix'],
                    'member_group' => $item['member_group'],
                ]);
            }
        }
        $this->alert('success', 'Data setting updated succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->isloadingSetting = false;
    }
   
}
