<?php

namespace App\Livewire;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class SetupPassword extends Component
{
    use LivewireAlert;

    public $token;
    public $password = '';
    public $password_confirmation = '';

    public $valid = false;

    public function mount($token)
    {
        $this->token = $token;
        
        $reset = DB::table('password_resets')
            ->where('token', $token)
            ->where('created_at', '>=', now()->subHours(24))
            ->first();
        $this->valid = $reset ? true : false;

        if (!$this->valid) {
            $this->alert('error', 'Token tidak valid atau sudah kadaluarsa. Silakan minta link pengaturan password baru.', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
            ]);
            $this->dispatch('redirecttohome');
        }
    }

    #[On('redirecttohome')]
    public function redirectToLogin()
    {
        sleep(5);
        return redirect('/');
    }

    public function rules()
    {
        return [
            'password' => ['required', 'string', 'min:8', 'confirmed'],
            'password_confirmation' => ['required'],
        ];
    }

    public function messages()
    {
        return [
            'password.required' => 'Password harus diisi',
            'password.min' => 'Password minimal 8 karakter',
            'password.confirmed' => 'Konfirmasi password tidak cocok',
            'password_confirmation.required' => 'Konfirmasi password harus diisi',
        ];
    }

    public function setupPassword()
    {
        $this->validate();

        $reset = DB::table('password_resets')
            ->where('token', $this->token)
            ->where('created_at', '>=', now()->subDays(7))
            ->first();

        if (!$reset) {
            $this->alert('error', 'Token tidak valid atau sudah kadaluarsa. Silakan minta link pengaturan password baru.');
            return;
        }

        try {
            DB::table('Luv2_supplier_dash')
                ->where('email', $reset->email)
                ->update([
                    'password' => Hash::make($this->password),
                ]);

            // Delete the used token
            DB::table('password_resets')
                ->where('token', $this->token)
                ->delete();

            $this->alert('success', 'Password berhasil disimpan! Anda sekarang dapat login ke dashboard supplier.', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
            ]);

            $this->dispatch('redirect-to-login');

        } catch (\Exception $e) {
            $this->alert('error', 'Terjadi kesalahan saat menyimpan password. Silakan coba lagi.');
        }
    }

    public function render()
    {
        return view('livewire.setup-password');
    }
} 