<?php

namespace App\Livewire\Settings;

use App\Models\Settings;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Form extends Component
{
    use LivewireAlert;

    public $setting;
    public $printername;
    public $wh_name;
    public $address;
    public $phone;
    public $email;
    public $footer;
    public $url_admin;
    public $salesemployee;
    public $editdiscount;
    public $editprice;
    public $sandbox;
    public $minustransaction;
    public $service;
    public $displayforfooter;
    public $nservice;

    public function render()
    {
        return view('livewire.settings.form');
    }


    #[On('afterUpdate')]
    public function mount()
    {
        $user = Auth::user();
        $setting = Warehouse::where('company_code', $user->company_code)->where('code', $user->whs_code)->first();
        $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
        
        $this->setting = $setting;
        $this->wh_name = $setting->name;
        $this->address = $setting->address;
        $this->phone = $setting->phone;
        $this->email = $setting->email;
        $this->salesemployee = $company->salesemployee == 'Y' ? true : false;
        $this->editdiscount = $company->editdiscount == 'Y' ? true : false;
        $this->editprice = $company->editprice == 'Y' ? true : false;
        $this->sandbox = $company->sandbox == 'Y' ? true : false;
        $this->minustransaction = $company->minus_transaction == 'Y' ? true : false;
        $this->service = $company->service == 'Y' ? true : false;
        $this->nservice = $company->nservice ?? 0;

        $this->footer = nl2br($setting->footer);

        $displayfooter = str_replace('\n', "\n", $setting->footer);
        $this->displayforfooter = nl2br($displayfooter);
    }

    public function save()
    {
        $user = Auth::user();
        $whs_code = $user->whs_code;
        $setting = $this->setting;
        
        // Update warehouse settings
        DB::table('Luv2_warehouse')
            ->where('code', $setting->code) 
            ->update([
                'name' => $this->wh_name,
                'address' => $this->address,
                'phone' => $this->phone,
                'email' => $this->email,
                'footer' => str_replace("\n", '\\n', $this->footer),
            ]);

        // Update company settings
        DB::table('Luv2_company')
            ->where('code', $user->company_code)
            ->update([
                'salesemployee' => $this->salesemployee ? 'Y' : 'N',
                'editdiscount' => $this->editdiscount ? 'Y' : 'N',
                'editprice' => $this->editprice ? 'Y' : 'N',
                'sandbox' => $this->sandbox ? 'Y' : 'N',
                'minus_transaction' => $this->minustransaction ? 'Y' : 'N',
                'service' => $this->service ? 'Y' : 'N',
                'nservice' => $this->nservice,
            ]);

        $this->alert('success', 'Setting berhasil diubah', [
            'position' => 'top',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->dispatch('afterUpdate');
    }

   

}
