<?php

namespace App\Livewire\Returnsale;

use App\Livewire\Returnsale\Table as ReturnsaleTable;
use App\Mail\MyTestMail;
use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\ItemPriceListDisc;
use App\Models\ItemPriceListDiscQty;
use App\Models\ItemTrans;
use App\Models\Settings;
use App\Models\User;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;



class Inputreturn extends Component
{
    use LivewireAlert;

    public $selectedItems;
    public $selectedItemsDetails;
    public $selectedItemsPrice;
    public $filteredProducts;
    public $member;
    public $payment = null;
    public $totalAmount = 0;
    public $change = null;
    public $type;
    public $transfer;
    public $cash = null;
    public $namaBank;
    public $namaPemegangKartu;
    public $inputs = [];
    public $i = 1;
    public $totalPrice = 0;
    public $cashier;
    public $invoice;
    public $sales;
    public $oldinvoice;
    public $itemReturnDetails;
    public $storeitem = [];
    public $oldPrice;

    #[Rule('min:4', message: 'Nomor Kartu must be 4 digits.')]
    #[Rule('max:4', message: 'Nomor Kartu must be 4 digits.')]
    public $nomorKartu;

    #[Rule('required', message: 'The payment option is required.')]
    public $paymentOption = 'cash';

    public function add()
    {
        $this->inputs[] = [
            'selectedFilteredItem' => null,
            'itemCode' => '',
            'itemName' => '',
            'itemPrice' => 0,
            'itemQty' => 0,
        ];

        $this->i++;

        $this->totalPrice = $this->calculateTotalPrice();
        $this->totalAmount = $this->totalPrice - $this->selectedItemsPrice;
        $this->dispatch('totalAmount', data: $this->totalAmount);
    }

    public function remove($index)
    {
        $this->totalPrice -= intval($this->inputs[$index]['itemPrice']) * $this->inputs[$index]['itemQty'];

        unset($this->inputs[$index]);
        $this->totalAmount = $this->totalPrice - $this->selectedItemsPrice;
        $this->dispatch('totalAmount', data: $this->totalAmount);
    }

    public function loadFilteredProducts()
    {
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $pricelist_code = $wh->pricelist_code;
        $this->filteredProducts = DB::table('Luv2_item')
            ->where('company_code', auth()->user()->company_code)
            ->join('Luv2_item_pricelist', 'Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
            ->where('Luv2_item_pricelist.pricelist_code', $pricelist_code)
            ->where('Luv2_item_pricelist.company_code', auth()->user()->company_code)
            ->where('Luv2_item_pricelist.price', '<=', intval($this->selectedItemsPrice))
            ->select('Luv2_item.*')
            ->orderBy('Luv2_item_pricelist.price', 'asc')
            ->get();


        foreach ($this->filteredProducts as $product) {
            $product->itemPrices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product->code)->where('pricelist_code', $pricelist_code)->get();
        }
    }


    #[On('openInputWithSelectedData')]
    public function mount($selectedItems, $selectedItemsPrice, $member, $selectedItemsDetails, $sales, $invoice, $itemReturnDetails)
    {
        $this->itemReturnDetails = $itemReturnDetails;
        $this->oldinvoice = $invoice;
        $this->sales = $sales;
        $this->member = $member;
        $this->selectedItemsDetails = $selectedItemsDetails;
        $this->selectedItems = $selectedItems;
        $this->selectedItemsPrice = $selectedItemsPrice;
        $this->inputs = [
            [
                'selectedFilteredItem' => null,
                'itemCode' => '',
                'itemName' => '',
                'itemPrice' => 0,
                'itemQty' => 0,
            ],
        ];
        // $this->loadFilteredProducts();
    }

    public function render()
    {
        return view('livewire.returnsale.inputreturn', [
            'filteredProducts' => $this->filteredProducts,
        ]);
    }

    public function updatedInputs()
    {
        // $this->loadFilteredProducts();
        $this->totalPrice = $this->calculateTotalPrice();
        $this->totalAmount = $this->totalPrice - $this->selectedItemsPrice;
        $this->dispatch('totalAmount', data: $this->totalAmount);
    }

    #[On('item-selected')]
    public function selectedFilteredItem($index, $product, $selectedItem)
    {
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $pricelist_code = $wh->pricelist_code;

        $selectedItem = $selectedItem;
        $product = $product;
        $product['itemPrices'] = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->get();
        $this->inputs[$index]['itemCode'] = $product['code'];
        $this->inputs[$index]['itemName'] = $product['name'];
        $now = now(); // Ambil tanggal saat ini
        //dinonaktifkandulu
        // if (session('discountmemb') == 1) {
        //     // Apply discount for member
        //     $pricelist_code = $setting->member_pricelist;
        //     $pricedisc = ItemPriceListDisc::where('item_code', $product['code'])
        //     ->where('cardcode', '*'.$pricelist_code)
        //     ->whereDate('from_date', '<=', $now)
        //     ->whereDate('to_date', '>=', $now)
        //     ->first();
        //     if ($pricedisc) {
        //         if ($this->member == null) {
        //             $this->inputs[$index]['itemPrice'] = $pricedisc->disc_price;
        //             $this->oldPrice = $this->inputs[$index]['itemPrice'];
        //         } else {
        //             $this->inputs[$index]['itemPrice'] = $pricedisc->disc_price;
        //             $this->oldPrice = $this->inputs[$index]['itemPrice'];
        //             // $disc = $product['itemPrices'][0]['price'] * 0.05;
        //             // $price = $product['itemPrices'][0]['price'] - $disc;
        //             // $this->inputs[$index]['itemPrice'] = $price;
        //         }
        //     } else {
        //         $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->first();
        //         $productprices = $prices->price;
        //         $this->inputs[$index]['itemPrice'] = $productprices;
        //         $this->oldPrice = $this->inputs[$index]['itemPrice'];

        //     }
        // } elseif(session('discountmemb') == 2){
        //     if ($this->member == null) {
        //         $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->first();
        //         $productprices = $prices->price;
        //         $this->inputs[$index]['itemPrice'] =  $productprices;
        //         $this->oldPrice = $this->inputs[$index]['itemPrice'];

        //     } else {
        //         $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->first();
        //         $productprices = $prices->price;
        //         $productpriceafterdisc = $productprices - ($productprices * $setting->member_disc);
        //         $this->inputs[$index]['itemPrice'] = $productpriceafterdisc;
        //         $this->oldPrice = $this->inputs[$index]['itemPrice'];

        //         // $disc = $product['itemPrices'][0]['price'] * 0.05;
        //         // $price = $product['itemPrices'][0]['price'] - $disc;
        //         // $this->inputs[$index]['itemPrice'] = $price;
        //     }
        // } elseif(session('discountmemb') == 0){
        //     $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->first();
        //             $productprices = $prices->price;
        //             $this->inputs[$index]['itemPrice'] = $productprices;
        // }

        $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $product['code'])->where('pricelist_code', $pricelist_code)->first();
        $productprices = $prices->price;
        $this->inputs[$index]['itemPrice'] = $productprices;
        $this->inputs[$index]['itemQty'] = 1;

        $this->totalPrice = $this->calculateTotalPrice();
        $this->totalAmount = $this->totalPrice - $this->selectedItemsPrice;
    }

    #[On('clear-product')]
    public function clearProduct($index)
    {
        $this->inputs[$index]['itemCode'] = '';
        $this->inputs[$index]['itemName'] = '';
        $this->inputs[$index]['itemPrice'] = '';
        $this->inputs[$index]['itemQty'] = 0;

        $this->totalPrice = $this->calculateTotalPrice();
        $this->totalAmount = $this->totalPrice - $this->selectedItemsPrice;
    }
    public function calculateTotalPrice()
    {
        $totalPrice = 0;

        foreach ($this->inputs as $input) {
            $totalPrice += (float)$input['itemPrice'] * (float)$input['itemQty'];
        }

        return $totalPrice;
    }

    public function updatePriceDisc($index)
    {
        $firstItem = reset($this->selectedItemsDetails);
        $memberId = $firstItem['id_member'];
        $sessionmember = session('discountmemb');
        $now = now();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $whs = Warehouse::where('code', $setting->wh_code)->first();
        $pricelist = $whs->pricelist_code;
        //dinonaktifkandulu
        // if (session('discountmemb') == 1) {
        //     $pricelist = $setting->member_pricelist;
        // }else{
        //     $pricelist = $whs->pricelist_code;
        // }
        // if ($sessionmember == 2 && !is_null($memberId)) { // 2 dan pakai member
        //     $price = $this->oldPrice;
        //     $this->inputs[$index]['itemPrice'] = $price * $this->inputs[$index]['itemQty'];
        //     $this->totalPrice = $this->calculateTotalPrice();
        // }
        // if ($sessionmember == 1 && !is_null($memberId)) {
        //     $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
        //                     ->where('cardcode', $memberId)
        //                     ->orderBy('qty', 'asc')
        //                     ->get();
        //     $discqty = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
        //                     ->where('cardcode', $memberId)
        //                     ->orderBy('qty', 'asc')
        //                     ->first();
        //     $pricedisc = ItemPriceListDisc::where('item_code', $this->inputs[$index]['itemCode'])
        //                     ->where('cardcode', $memberId)
        //                     ->whereDate('from_date', '<=', $now)
        //                     ->whereDate('to_date', '>=', $now)
        //                     ->first();

        //  } else {
        //     $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
        //                         ->where('cardcode', '*'.$pricelist)
        //                         ->orderBy('qty', 'asc')->get();
        //     $discqty = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
        //                         ->where('cardcode', '*'.$pricelist)
        //                         ->orderBy('qty', 'asc')->first();
        //     $pricedisc = ItemPriceListDisc::where('item_code', $this->inputs[$index]['itemCode'])
        //             ->where('cardcode', '*'.$pricelist)
        //             ->whereDate('from_date', '<=', $now)
        //             ->whereDate('to_date', '>=', $now)
        //             ->first();
        // }

        $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
            ->where('cardcode', '*' . $pricelist)
            ->orderBy('qty', 'asc')->get();
        $discqty = ItemPriceListDiscQty::where('item_code', $this->inputs[$index]['itemCode'])
            ->where('cardcode', '*' . $pricelist)
            ->orderBy('qty', 'asc')->first();
        $pricedisc = ItemPriceListDisc::where('item_code', $this->inputs[$index]['itemCode'])
            ->where('cardcode', '*' . $pricelist)
            ->whereDate('from_date', '<=', $now)
            ->whereDate('to_date', '>=', $now)
            ->first();
        foreach ($itemPriceDiscounts as $itemPriceDiscount) {
            if ($this->inputs[$index]['itemQty'] >= $itemPriceDiscount->qty) {
                $price = $itemPriceDiscount->disc_price;
                $this->inputs[$index]['itemPrice'] = $price;
                $this->totalPrice = $this->calculateTotalPrice();
            }
            if ($this->inputs[$index]['itemQty'] < $discqty->qty) {
                if ($pricedisc) {
                    $this->inputs[$index]['itemPrice'] = $pricedisc->disc_price;
                    $this->totalPrice = $this->calculateTotalPrice();
                } else {
                    $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $this->inputs[$index]['itemCode'])->where('pricelist_code', $pricelist)->first();
                    $this->inputs[$index]['itemPrice'] = $prices->price;
                    $this->totalPrice = $this->calculateTotalPrice();
                }
            }
        }
    }
    public function store()
    {
        $user = Auth::user();
        $item = $this->itemReturnDetails;
        $no = $item[0]['no'];
        $datainvoiceexist = Invoice::where('no', $no)->first();
        $huruf = 'RS';
        // Date
        $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

        // Count invoices created today
        $countinvoice = DB::table('Luv2_invoice')
            ->where('user_code', $user->code)
            ->whereDate('created_at', Carbon::today())
            ->count();
        $countinvoice += 1;

        // set max 999 to count inv
        $countinvoice = min($countinvoice, 999);
        // set default 3 digit count inv
        $countinvoice = str_pad($countinvoice, 3, '0', STR_PAD_LEFT);
        $code = $user->id;

        $invoicereturn = $huruf . $code . $tanggal . $countinvoice;
        $maxId = Invoice::max('id');
        $invoiceData = [
            'company_code' => $user->company_code,
            'whs_code' => $user->whs_code,
            'id' => $maxId + 1,
            'user_code' => $user->code,
            'no' => $invoicereturn,
            'member_code' => $datainvoiceexist->member_code,
            'payment' => null,
            'paid' => null,
            'change' => null,
            'must_paid' => $this->totalAmount,
            'date' => $datainvoiceexist->date,
            'note' =>  '',
            'promo' => '0',
            'cashback' => 'N',
            'subtotal' => $this->totalAmount,
            'no_inv' => $datainvoiceexist->no,
            // 'cardcode' => $datainvoiceexist->cardcode,
            'created_at' => $datainvoiceexist->date,
            'updated_at' => Carbon::now(),
        ];
        if ($datainvoiceexist->payment == 'Multi') {
            $invoiceNote = json_decode($datainvoiceexist->note, true);
            $cash = $invoiceNote['cash'] ?? 0; // Assuming default value of cash is 0 if not set
            $transfer = $invoiceNote['transfer'] ?? 0; // Assuming default value of transfer is 0 if not set
            $type = $invoiceNote['type'];
            $bank = $invoiceNote['nama_bank'];
            $pemegangkartu = $invoiceNote['nama_pemegang_kartu'];
            $nomorkartu = $invoiceNote['nomor_kartu'];

            if (abs($this->totalAmount) > $cash) {
                $remainingAmountTransfer = $this->totalAmount + $cash;
                $note = [
                    'type' => $type,
                    'nama_bank' => $bank,
                    'nama_pemegang_kartu' => $pemegangkartu,
                    'cash' => -$cash,
                    'transfer' => $remainingAmountTransfer,
                    'nomor_kartu' => $nomorkartu,
                ];

                $invoiceData['note'] = json_encode($note);
            } else {
                $note = [
                    'type' => $type,
                    'nama_bank' => $bank,
                    'nama_pemegang_kartu' => $pemegangkartu,
                    'cash' => $this->totalAmount,
                    'transfer' => 0,
                    'nomor_kartu' => $nomorkartu,
                ];

                $invoiceData['note'] = json_encode($note);
            }
        }
        Invoice::create($invoiceData);
        $newInvoice = Invoice::where('no', $invoicereturn)->first();
        $cashier = User::where('code', $newInvoice->user_code)->first();
        $this->invoice = $newInvoice;
        $this->cashier = $cashier;
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $pricelist_code = $wh->pricelist_code;
        $totalSubtotal = 0;
        $totalDiscount = 0;
        $totalQty = 0;
        $lineNumber = 1;
        foreach ($this->itemReturnDetails as $itemz) {
            $linenum = $lineNumber++;
            $items = DetailInvoice::where('no', $itemz['no'])->first();
            $item = ItemPrice::where('company_code', auth()->user()->company_code)->where('pricelist_code', $pricelist_code)->where('item_code', $itemz['code'])->first();
            $nprice = $item->price;
            DetailInvoice::insert([
                'company_code' => $user->company_code,
                'no' => $newInvoice->no,
                'whs_code' => $user->whs_code,
                'code' => $itemz['code'],
                'barcode' => $itemz['barcode'],
                'name' => $itemz['name'],
                'price' => $itemz['price'],
                'nprice' => $nprice,
                'qty' => -$itemz['qty'],
                'disc' => $itemz['disc'],
                'total_price' => -$itemz['qty'] * $itemz['price'],
                'sandbox' => 'N',
                'linenum' => $linenum,
                'promo' => 0,
                'promo_tipe' => 0,
                'pack' => 0,
                'sales_code' => $items->sales_code,
                'user_code' => $user->code,
                'member_code' => isset($itemz['member_code']) && !is_null($itemz['member_code']) ? $itemz['member_code'] : null,
                'benefit' => 'N',
                'status' => 0,
                'created_at' => $newInvoice->created_at,
            ]);
            // Calculate and add subtotal for each item
            $dataReturn = DetailInvoice::where('no', $newInvoice->no)
                ->where('code', $itemz['code'])
                ->first();
            if ($dataReturn->disc == '1') {
                $subtotal = $itemz['price'] * -$itemz['qty'];
            } else {
                $subtotal = $nprice * -$itemz['qty'];
            }
            $totalSubtotal += $subtotal;
        }
        $createdCartItems = [];
        $lineNumber = 1;
        foreach ($this->inputs as $input) {
            $items = DetailInvoice::where('no', $datainvoiceexist->no)->first();
            $item = ItemPrice::where('company_code', auth()->user()->company_code)->where('pricelist_code', $pricelist_code)->where('item_code', $input['itemCode'])->first();
            $selectitem = Item::where('code', $input['itemCode'])
                ->where('company_code', auth()->user()->company_code)->first();
            $barcode = $selectitem->barcode;
            $nprice = $item->price;
            $price = $input['itemPrice'];
            $linenum = $lineNumber++;
            $disc = ($price != $nprice) ? 1 : 0;

            DetailInvoice::insert([
                'company_code' => $user->company_code,
                'no' => $newInvoice->no,
                'whs_code' => $user->whs_code,
                'code' => $input['itemCode'],
                'barcode' => $barcode,
                'name' => $input['itemName'],
                'price' => $input['itemPrice'],
                'nprice' => $nprice,
                'qty' => $input['itemQty'],
                'disc' => $disc,
                'total_price' => $input['itemPrice'] * $input['itemQty'],
                'sandbox' => 'N',
                'linenum' => $linenum,
                'promo' => 0,
                'promo_tipe' => 0,
                'pack' => 0,
                'sales_code' => $items->sales_code,
                'user_code' => $cashier->code,
                'member_code' => isset($items->member_code) && !is_null($items->member_code) ? $items->member_code : null,
                'benefit' => 'N',
                'status' => 0,
                'created_at' => $newInvoice->created_at,
                'created_at' => $newInvoice->created_at,

            ]);
            $cartData = DetailInvoice::where('code', $input['itemCode'])
                ->where('no', $newInvoice->no)
                ->first();

            $createdCartItems[] = [
                'name' => $cartData->name,
                'price' => $cartData->price,
                'qty' => $cartData->qty,
            ];

            // Calculate and add discount for each item
            $discount = ($nprice - $input['itemPrice']);
            $totalDiscount += $discount;

            // Calculate and add qty for each item
            $qty = $input['itemQty'] > 0 ? $input['itemQty'] : 0;
            $totalQty += $qty;

            $sales = $items->sales_code;
        }
        $newInvoice = Invoice::where('no', $invoicereturn)->first();
        $newInvoice->update([
            'disc_total' => $totalDiscount,
            'sales_code' => $sales,
            'total_qty' => $totalQty,
        ]);

        $this->storeitem = $createdCartItems;
        $user = Auth::user();
        $warehouse = Warehouse::where('code', $user->whs_code)->first();
        foreach ($this->inputs as $key => $input) {
            $linenum = $lineNumber++;
            $item = Item::where('code', $input['itemCode'])
                ->where('company_code', auth()->user()->company_code)
                ->where('inventory', 'Y')->first();
            if ($item) {
                $transData = [
                    'no_trans' => $newInvoice->no, //invoice
                    'whs_code' => $user->whs_code,
                    'company_code' => $user->company_code,
                    'linenum' => $linenum,
                    'item_code' => $input['itemCode'],
                    'tipe' => '13',
                    'date' => Carbon::now(),
                    'qty' => -$input['itemQty'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'linenum' => $key, // Assuming linenum starts from 1
                ];
                ItemTrans::insert($transData);
            }
        }
        foreach ($this->selectedItemsDetails as $key => $selectedItem) {
            $item = Item::where('code', $selectedItem['code'])->where('inventory', 'Y')
                ->where('company_code', auth()->user()->company_code)
                ->first();
            if ($item) {
                $transData = [
                    'no_trans' => $newInvoice->no, //invoice
                    'whs_code' => $user->whs_code,
                    'company_code' => $user->company_code,
                    'linenum' => $linenum,
                    'item_code' => $selectedItem['code'],
                    'tipe' => '4',
                    'date' => Carbon::now(),
                    'qty' => $selectedItem['qty'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'linenum' => $key, // Assuming linenum starts from 1
                ];
                ItemTrans::insert($transData);
            }
        }

        $this->selectedItems = [];
        // $this->dispatch('syncreturn', $newInvoice->no);
        // $this->print();
        $this->dispatch('closeModalReturn');
        $this->dispatch('clearSelectedAfterReturn', data: $this->selectedItems)->to(ReturnsaleTable::class);
        $this->alert('success', 'Return data created succesfully', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->reset();
        // $this->dispatch('SendEmailReturn', data: $newInvoice);
    }

    #[On('SendEmailReturn')]
    public function sendEmailReturn($data)
    {
        $user = Auth::user();
        $toko = Settings::where('wh_code', $user->whs_code)->first();
        $email = $toko->email_finance;
        Mail::to($email)->send(new MyTestMail($data, $toko));
    }

    #[On('syncreturn')]
    public function syncreturn($code)
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;
        $detailinvoicememo = DetailInvoice::where('no', $code)->where('status', 1)->get();
        $detailinvoicear = DetailInvoice::where('no', $code)->where('status', 0)->get();

        $invoice = Invoice::where('no', $code)->first();
        $date = date_create($invoice->date);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $getsales = DetailInvoice::where('no', $code)->first();
        $idsales = $getsales->sales_code;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "") { //mzdihilangkan
            $cash = 0;
            $card = 0;
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        }


        foreach ($detailinvoicememo as $data) {
            $syncItemsmemo[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => ltrim($data->qty, '-'),
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => ltrim($data->total_price, '-'),
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                    // 'WhsCode' => "RCSM",
                    // 'SBU' => "Galaxy",
                ];
        }
        foreach ($detailinvoicear as $data) {
            $syncItemsar[] =
                [
                    'ItemCode' => $data->code,
                    'Quantity' => $data->qty,
                    'UnitPrice' => $data->nprice,
                    'LineTotal' => $data->total_price,
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                    // 'WhsCode' => "RCSM",
                    // 'SBU' => "Galaxy",
                ];
        }
        $commentcode = $user->whs_code . '/' . $code . '/' . $user->name;
        $datamemo = [
            "CardCode" => $invoice->cardcode,
            "CntctCode" => "0",
            "NumAtCard" => "0",
            "DocDate" => $formattedDate,
            "DocDueDate" => $formattedDate,
            "TaxDate" => $formattedDate,
            "SlpCode" => $idsales,
            "Comments" => $commentcode,
            "BPLId" => $setting->bpl_id,
            "DocType" => "C",
            "Lines" => $syncItemsmemo,
        ];

        if ($invoice->subtotal <= 0) { //mzditambahkan jika rs
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        } else {
            $data = [
                "CardCode" => $invoice->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $syncItemsar,
                "CreditMemo" => $datamemo,
            ];
        }

        $response = Http::post($url . '/api/search', [
            "Select" => "\"Comments\"",
            "From" => "OINV",
            "Where" => "\"Comments\"='" . $commentcode . "' AND \"CANCELED\"='N' LIMIT 1",
        ]);

        $responseBody = $response->getBody()->getContents();
        $responseData = json_decode($responseBody, true);
        if ($responseData[0]['Comments'] == $commentcode) {
            $invoice = Invoice::where('no', $code)->first();
            $invoice->sync = 'Y';
            $invoice->save();
            $this->alert('info', 'Invoice already exists on SAP', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } else {
            try {
                $user = Auth::user();
                $setting = Settings::where('wh_code', $user->whs_code)->first();
                $url = $setting->url;
                $client = new Client();
                $route = ($invoice->subtotal <= 0) ? '/api/addarexchange' : '/api/addarexchangepayment'; //mzdiubah jika rs

                $response = $client->post($url . $route, [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);


                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = Invoice::where('no', $code)->first();
                    $invoice->sync = 'Y';
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    // $this->creditmemo($code, $commentcode, $datamemo);
                }
            } catch (\Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }
    public function updatedCash()
    {
        $cashWithoutDots = str_replace('.', '', $this->cash);
        $cashFloat = (float) $cashWithoutDots;
        $this->transfer = $this->totalAmount - $cashFloat;
    }

    public function updatedPayment()
    {
        $paymentWithoutDots = str_replace('.', '', $this->payment);
        $paymentFloat = (float) $paymentWithoutDots;
        $this->change = $paymentFloat - $this->totalAmount;
    }
    public function storewithmoney()
    {

        $user = Auth::user();
        $item = $this->itemReturnDetails;
        $paymentWithoutDots = str_replace('.', '', $this->payment);
        $paymentFloat = (float) $paymentWithoutDots;
        $invoice = $item[0]['no'];
        $datainvoiceexist = Invoice::where('no', $invoice)->first();

        $pembayaran = $this->paymentOption;
        $totalAmount = $this->totalAmount;
        $payment = $paymentFloat;
        $change = $this->change;
        $huruf = 'RS';
        // Date
        $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

        // Count invoices created today
        $countinvoice = DB::table('Luv2_invoice')
            ->where('user_code', $user->code)
            ->whereDate('created_at', Carbon::today())
            ->count();
        $countinvoice += 1;

        // set max 999 to count inv
        $countinvoice = min($countinvoice, 999);
        // set default 3 digit count inv
        $countinvoice = str_pad($countinvoice, 3, '0', STR_PAD_LEFT);
        $code = $user->id;
        $invoicereturn = $huruf . $code . $tanggal . $countinvoice;
        if ($this->paymentOption == 'card' && $this->paymentOption == 'multi') {
            $this->validate();
        }
        $maxId = Invoice::max('id');
        $invoiceData = [
            'company_code' => $user->company_code,
            'whs_code' => $user->whs_code,
            'id' => $maxId + 1,
            'user_code' => $user->code,
            'member_code' => $datainvoiceexist->member_code,
            'no' => $invoicereturn,
            'payment' => ucwords($pembayaran),
            'paid' => ($pembayaran === 'card' || $pembayaran === 'multi') ? $totalAmount : ($pembayaran === 'qris' ? $totalAmount : $payment),
            'must_paid' => $this->totalPrice - $this->selectedItemsPrice,
            'change' => $change,
            'date' => Carbon::now(),
            // 'cardcode' => $datainvoiceexist->cardcode,
            'no_inv' => $datainvoiceexist->no,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),

        ];
        if ($pembayaran === 'multi' || $pembayaran === 'card') {
            $cashWithoutDots = str_replace('.', '', $this->cash);
            $cashFloat = (float) $cashWithoutDots;
            $note = [
                'type' => $this->type ?? 'Credit',
                'nama_bank' => $this->namaBank,
                'nama_pemegang_kartu' => $this->namaPemegangKartu,
                'cash' => ($pembayaran === 'multi') ? $cashWithoutDots : null,
                'transfer' => ($pembayaran === 'multi') ? ($totalAmount - $cashFloat) : ($pembayaran === 'card' ? $totalAmount : null), // Set 'transfer' based on the condition
                'nomor_kartu' => $this->nomorKartu,
            ];

            $invoiceData['note'] = json_encode($note);
        }

        Invoice::insert($invoiceData);
        $newInvoice = Invoice::where('no', $invoiceData['no'])->first();
        $cashier = User::where('code', $newInvoice->user_code)->first();
        $this->invoice = $newInvoice;
        $this->cashier = $cashier;
        $user = Auth::user();
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $pricelist_code = $wh->pricelist_code;
        $totalSubtotal = 0;
        $totalDiscount = 0;
        $totalQty = 0;
        $lineNumber = 1;

        foreach ($this->itemReturnDetails as $itemz) {
            $linenum = $lineNumber++;
            $items = DetailInvoice::where('no', $itemz['no'])->first();
            $item = ItemPrice::where('company_code', auth()->user()->company_code)->where('pricelist_code', $pricelist_code)->where('item_code', $itemz['code'])->first();
            $nprice = $item->price;
            DetailInvoice::insert([
                'company_code' => $user->company_code,
                'no' => $newInvoice->no,
                'whs_code' => $user->whs_code,
                'code' => $itemz['code'],
                'barcode' => $itemz['barcode'],
                'name' => $itemz['name'],
                'price' => $itemz['price'],
                'nprice' => $nprice,
                'qty' => -$itemz['qty'],
                'disc' => $itemz['disc'],
                'total_price' => -$itemz['qty'] * $itemz['price'],
                'sandbox' => 'N',
                'linenum' => $linenum,
                'promo' => 0,
                'promo_tipe' => 0,
                'pack' => 0,
                'sales_code' => $items->sales_code,
                'user_code' => $user->code,
                'member_code' => isset($itemz['member_code']) && !is_null($itemz['member_code']) ? $itemz['member_code'] : null,
                'benefit' => 'N',
                'status' => 0,
                'created_at' => $newInvoice->created_at,
                'created_at' => $newInvoice->created_at,
            ]);
            // Calculate and add subtotal for each item
            $dataReturn = DetailInvoice::where('no', $newInvoice->no)
                ->where('code', $itemz['code'])
                ->first();
            if ($dataReturn->disc == '1') {
                $subtotal = $itemz['price'] * -$itemz['qty'];
            } else {
                $subtotal = $nprice * -$itemz['qty'];
            }
            $totalSubtotal += $subtotal;
        }
        $createdCartItems = [];
        foreach ($this->inputs as $input) {
            $items = DetailInvoice::where('no', $datainvoiceexist->no)->first();
            $item = ItemPrice::where('company_code', auth()->user()->company_code)->where('pricelist_code', $pricelist_code)->where('item_code', $input['itemCode'])->first();
            $selectitem = Item::where('code', $input['itemCode'])
                ->where('company_code', auth()->user()->company_code)
                ->first();
            $barcode = $selectitem->barcode;
            $nprice = $item->price;
            $price = $input['itemPrice'];

            $disc = ($price != $nprice) ? 1 : 0;

            DetailInvoice::insert([
                'company_code' => $user->company_code,
                'no' => $newInvoice->no,
                'whs_code' => $user->whs_code,
                'code' => $input['itemCode'],
                'barcode' => $barcode,
                'name' => $input['itemName'],
                'price' => $input['itemPrice'],
                'nprice' => $nprice,
                'qty' => $input['itemQty'],
                'disc' => $disc,
                'total_price' => $input['itemPrice'] * $input['itemQty'],
                'sandbox' => 'N',
                'linenum' => $linenum,
                'promo' => 0,
                'promo_tipe' => 0,
                'pack' => 0,
                'sales_code' => $items->sales_code,
                'user_code' => $cashier->code,
                'member_code' => isset($items->member_code) && !is_null($items->member_code) ? $items->member_code : null,
                'benefit' => 'N',
                'status' => 0,
                'created_at' => $newInvoice->created_at,
                'created_at' => $newInvoice->created_at,
            ]);
            $cartData = DetailInvoice::where('code', $input['itemCode'])
                ->where('no', $newInvoice->no)
                ->first();
            $createdCartItems[] = [
                'name' => $cartData->name,
                'price' => $cartData->price,
                'qty' => $cartData->qty,
            ];
            // Calculate and add subtotal for each item
            $subtotal = $nprice * $input['itemQty'];
            $totalSubtotal += $subtotal;

            // Calculate and add discount for each item
            $discount = ($nprice - $input['itemPrice']);
            $totalDiscount += $discount;

            // Calculate and add qty for each item
            $qty = $input['itemQty'] > 0 ? $input['itemQty'] : 0;
            $totalQty += $qty;

            $sales = $items->sales_code;
        }
        $newInvoice = Invoice::where('no', $invoicereturn)->first();
        $newInvoice->update([
            'subtotal' => $totalSubtotal,
            'disc_total' => $totalDiscount,
            'sales_code' => $sales,
            'total_qty' => $totalQty,
        ]);

        $this->storeitem = $createdCartItems;
        $user = Auth::user();
        $warehouse = Warehouse::where('code', $user->whs_code)->first();
        foreach ($this->inputs as $key => $input) {
            $item = Item::where('code', $input['itemCode'])->where('inventory', 'Y')
                ->where('company_code', auth()->user()->company_code)
                ->first();
            if ($item) {
                $transData = [
                    'no_trans' => $newInvoice->no, //invoice
                    'whs_code' => $user->whs_code,
                    'company_code' => $user->company_code,
                    'linenum' => $linenum,
                    'item_code' => $input['itemCode'],
                    'tipe' => '13',
                    'date' => Carbon::now(),
                    'qty' => -$input['itemQty'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'linenum' => $key, // Assuming linenum starts from 1
                ];
                ItemTrans::insert($transData);
            }
        }
        foreach ($this->selectedItemsDetails as $key => $selectedItem) {
            $item = Item::where('code', $selectedItem['code'])->where('inventory', 'Y')
                ->where('company_code', auth()->user()->company_code)
                ->first();
            if ($item) {
                $transData = [
                    'no_trans' => $newInvoice->no, //invoice
                    'whs_code' => $user->whs_code,
                    'company_code' => $user->company_code,
                    'linenum' => $linenum,
                    'item_code' => $selectedItem['code'],
                    'tipe' => '14',
                    'date' => Carbon::now(),
                    'qty' => $selectedItem['qty'],
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'linenum' => $key, // Assuming linenum starts from 1
                ];
                ItemTrans::insert($transData);
            }
        }
        $this->selectedItems = [];
        // $this->printwithmoney();
        // $this->dispatch('syncreturn', $newInvoice->no);
        $this->dispatch('closeModalReturn');
        $this->dispatch('clearSelectedAfterReturn', data: $this->selectedItems)->to(ReturnsaleTable::class);
        $this->alert('success', 'Return data created succesfully', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->reset();
    }

    public function print()
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            $cashier = Auth::user()->name;
            // Set the font size
            $printer->setTextSize(1, 1);

            // $cashier = $this->cashier;
            $now = Carbon::now();

            // Format the current date and time
            $formattedDateTime = $now->format('d/m/Y H:i:s');

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . $cashier;
            $billNo = "Bill No   : " . $this->oldinvoice;
            $returNo = "Return No : " . $this->invoice->no;
            $date = "Date      : " . $formattedDateTime;
            if (!isset($this->sales->position) || $this->sales->position === '') {
                $handledBy = "Handled by : " . $this->sales->name;
            } else {
                $handledBy = "Handled by : " . $this->sales->position;
            }
            // Define your item list (replace this with your actual item data)
            $itemsreturn = [];

            foreach ($this->itemReturnDetails as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $itemsreturn[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                ];
            }

            $items = [];

            foreach ($this->storeitem as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $items[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                ];
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print totals

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print totals

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            $this->dispatch('printernotfound');
        }
    }

    public function printwithmoney()
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            $cashier = Auth::user()->name;
            // Set the font size
            $printer->setTextSize(1, 1);

            // $cashier = $this->cashier;
            $now = Carbon::now();

            // Format the current date and time
            $formattedDateTime = $now->format('d/m/Y H:i:s');

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . $cashier;
            $billNo = "Bill No   : " . $this->oldinvoice;
            $returNo = "Return No : " . $this->invoice->no;
            $date = "Date      : " . $formattedDateTime;
            if (!isset($this->sales->position) || $this->sales->position === '') {
                $handledBy = "Handled by : " . $this->sales->name;
            } else {
                $handledBy = "Handled by : " . $this->sales->position;
            }
            // Define your item list (replace this with your actual item data)
            if ($this->invoice->payment === "Multi") {
                $note = json_decode($this->invoice['note'], true);
                // Check if the 'cash' key exists in the decoded note data
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            }
            if ($this->invoice->payment === "Card") {
                $note = json_decode($this->invoice['note'], true);
                // Check if the 'cash' key exists in the decoded note data
                $cash = 0;
                $card = $note['transfer'];
                $change = $this->invoice->change;
            }
            if ($this->invoice->payment === "Cash") {
                $cash = $this->invoice->paid;
                $card = 0;
                $change = $this->invoice->change;
            }
            if ($this->invoice->payment === "Qris") {
                $cash = 0;
                $card = $this->invoice->must_paid;
                $change = 0;
            }
            $itemsreturn = [];

            foreach ($this->itemReturnDetails as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $itemsreturn[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                ];
            }

            $items = [];

            foreach ($this->storeitem as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $items[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                ];
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $grandTotal = $subTotalitems - $subTotalreturn;
            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print Information card
            if ($this->invoice->payment === "Card" || $this->invoice->payment === "Multi") {
                $note = json_decode($this->invoice['note'], true);
                $printer->text("---------------------------------------\n");
                $nocard = "Number     : " . $note['nomor_kartu'];
                $name = "Name       : " . $note['nama_pemegang_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }
            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print totals

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);
            $grandTotal = "GrandTotal: " . number_format($grandTotal, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedGrandTotal\n");
            $cash = "Cash      : " . number_format($cash, 2);
            $card = "Card      : " . number_format($card, 2);
            $change = "Change    : " . number_format($this->invoice->change, 2);
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");
            $printer->text("---------------------------------------\n");


            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            $this->dispatch('printernotfound');
        }
    }
}
