<?php

namespace App\Livewire\Report;

use App\Models\Warehouse;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class Voucher extends Component
{

    public $data;
    public $whs_code;
    public function render()
    {
        $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();

        return view('livewire.report.voucher', [
            'warehouse' => $warehouse,
        ]);
    }

    #[On('refresh')]
    public function mount()
    {
        if (auth()->user()->role == 'Admin') {
            $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->first();
            $user = auth()->user();
            if ($user->whs_code == '-') {
                $user->whs_code = $warehouse->code;
                $user->save();
            }

        }

        $data = DB::table('Luv2_promo_voucher')
            ->leftjoin('Luv2_promo', 'Luv2_promo_voucher.no', '=', 'Luv2_promo.no')
            ->leftJoin('Luv2_invoice', 'Luv2_promo_voucher.voucher', '=', 'Luv2_invoice.cashback')
            ->where('Luv2_invoice.whs_code', auth()->user()->whs_code)
            ->select(
                'Luv2_promo_voucher.no',
                'Luv2_promo_voucher.company_code',
                'Luv2_promo_voucher.voucher',
                'Luv2_promo_voucher.value',
                'Luv2_promo_voucher.used',
                'Luv2_promo.pricelist_code',
                'Luv2_promo.name',
                'Luv2_promo.from_date',
                'Luv2_promo.to_date',
                'Luv2_promo.deleted',
                'Luv2_promo.tipe',
                'Luv2_promo.benefit',
                'Luv2_promo.date',
                'Luv2_promo.disc',
                'Luv2_promo.disc_price',
                'Luv2_promo.qty_pack',
                'Luv2_promo.value_pack',
                'Luv2_promo.voucher_from_date',
                'Luv2_promo.voucher_to_date',
                'Luv2_promo.no as createdBy',
                'Luv2_invoice.no as usedBy'
            )
            ->get();

        $this->data = $data;
        $this->dispatch('refreshjs');
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;
        $user->save();
        $this->dispatch('refresh');
        $this->dispatch('refreshjs');

    }

}
