<?php

namespace App\Livewire\Report;

use App\Exports\ExportOpnameDetail;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class OpnameDetail extends Component
{
    public $details;
    public $no;

    public function exportExcel()
    {
        $filename = "Opname Detail Report No. {$this->no->no}.xlsx";
        return Excel::download(new ExportOpnameDetail($this->details), $filename);
    }

    public function render()
    {
        return view('livewire.report.opname-detail');
    }

    public function mount($id)
    {
        $this->details = DB::table('Luv2_opname_detail as pd')
            ->join('Luv2_opname as p', 'pd.no', '=', 'p.no')
            ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
            ->select(
                'i.code',
                'i.barcode',
                'i.name',
                DB::raw('SUM(pd.qty) as qty'),
                DB::raw('SUM(pd.opname) as opname'),
                DB::raw('SUM(pd.difference) as difference')
            )
            ->where('p.no', $id)
            ->groupBy(
                'i.code',
                'i.barcode',
                'i.name',
            )
            ->get();


        $this->no = DB::table('Luv2_opname')
            ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
            ->where('no', $id)
            ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name')
            ->first();
    }
}
