<?php

namespace App\Livewire\Report;

use App\Exports\ExportOpname;
use App\Exports\ExportOpnameDet;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class Opname extends Component
{
    use LivewireAlert;

    public $focusedHeader = true;
    public $supplier;
    public $startDate;
    public $endDate;
    public $selectedDate;
    public $dataDetail;
    public $searchsupplier = '';
    public $selectedSupplier = null;
    public $selectedIndex;
    public $selectedCode = '';
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $opname;
    public $opnameDet;

    public function mount()
    {
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
    }

    public function focusedHeaderTrue()
    {
        $this->focusedHeader = true;
        $this->dispatch('refreshjs');
    }

    public function focusedHeaderFalse()
    {
        $this->focusedHeader = false;
        $this->dispatch('refreshjs');
    }

    public function filters()
    {
        $this->opname = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->opnameDet = DB::table('Luv2_return')
            ->join('Luv2_return_detail', 'Luv2_return.no', '=', 'Luv2_return_detail.no')
            ->join('Luv2_item', 'Luv2_return_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_return.user_code', $user->code)
            // ->where('Luv2_return.deleted', '<>', 'Y')
            ->where('Luv2_return.date', '>=', $this->startDate)
            ->where('Luv2_return.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_return.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_return.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_return.no', 'Luv2_return.date', 'Luv2_return.remark', 'Luv2_return_detail.qty', 'Luv2_item.*', 'Luv2_supplier.name as supp', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->dispatch('refreshjs');

        // dd($this->selectedSupplier, $this->selectedWarehouse, $this->return, $this->returnDet);
    }

    public function exportExcel()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Opname Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Opname Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');

        return Excel::download(new ExportOpname($this->opname), $filename);
    }

    public function exportExcelDetail()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Opname Detail Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Opname Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportOpnameDet($this->opnameDet), $filename);
    }

    public function updated()
    {
        $this->dispatch('refreshjs');
    }

    public function render()
    {
        $resultwarehouse = [];
        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }
        $user = Auth::user();
        if ($user->role != 'Admin') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)
                ->where('company_code', auth()->user()->company_code)
                ->first();

            if ($warehouse) {

                $this->searchwarehouse = $warehouse->name;
                $this->selectedWarehouse = $warehouse;
            }
        }

        $this->opname = DB::table('Luv2_opname')
            ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
            ->where('Luv2_opname.adjust', '=', 'Y')
            ->where('Luv2_opname.date', '>=', $this->startDate)
            ->where('Luv2_opname.date', '<=', $this->endDate)
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_opname.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name')
            ->orderBy('Luv2_opname.date', 'ASC')
            ->orderBy('Luv2_opname.no', 'ASC')
            ->get();

        $this->opnameDet = DB::table('Luv2_opname')
            ->join('Luv2_opname_detail', 'Luv2_opname.no', '=', 'Luv2_opname_detail.no')
            ->join('Luv2_item', 'Luv2_opname_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
            ->where('Luv2_opname.adjust', '=', 'Y')
            ->where('Luv2_opname.date', '>=', $this->startDate)
            ->where('Luv2_opname.date', '<=', $this->endDate)
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_opname.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_opname.no', 'Luv2_opname.date', 'Luv2_opname_detail.linenum', 'Luv2_opname_detail.qty', 'Luv2_opname_detail.opname', 'Luv2_opname_detail.difference', 'Luv2_item.*', 'Luv2_warehouse.name as whs_name')
            ->orderBy('Luv2_opname.date', 'ASC')
            ->orderBy('Luv2_opname.no', 'ASC')
            ->orderBy('Luv2_opname_detail.linenum', 'ASC')
            ->get();

        return view('livewire.report.opname', [
            'resultwarehouse' => $resultwarehouse,
            'opname' => $this->opname,
            'opnameDet' => $this->opnameDet,
        ]);
    }

    public function clearfilters()
    {
        $this->searchsupplier = '';
        $this->searchwarehouse = '';
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        $this->selectedSupplier = null;
        $this->selectedWarehouse = null;

        $this->opname = collect();
        $this->opnameDet = collect();
        $this->dispatch('refreshjs');

    }


    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
        $this->dispatch('refreshjs');
    }
}
