<?php

namespace App\Livewire\Report;

use App\Exports\ExportGoodsReturnDetail;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class GoodsReturnDetail extends Component
{
    public $details;
    public $no;

    public function exportExcel()
    {
        $filename = "Goods Return Detail Report No. {$this->no->no}.xlsx";
        return Excel::download(new ExportGoodsReturnDetail($this->details), $filename);
    }

    public function render()
    {
        return view('livewire.report.goods-return-detail');
    }

    public function mount($id)
    {
        $this->details = DB::table('Luv2_return_detail as pd')
            ->join('Luv2_return as p', 'pd.no', '=', 'p.no')
            ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
            ->select(
                'i.code',
                'i.barcode',
                'i.name',
                'i.size_code',
                'pd.price',
                'pd.total',
                'pd.qty as qty_detail',
                DB::raw('SUM(pd.qty) as qty')
            )
            ->where('p.no', $id)
            ->groupBy(
                'i.code',
                'i.barcode',
                'i.name',
                'i.size_code',
                'pd.qty',
                'pd.price',
                'pd.total'
            )
            ->get();


        $this->no = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            ->where('no', $id)
            ->where('Luv2_return.company_code', auth()->user()->company_code)
            ->select('Luv2_return.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name')
            ->first();
    }

    public function exportPDF()
    {
        // dd($this->no, $this->details);
        $items = [];
        $number = 1;
        $documentDate = Carbon::parse($this->no->date)->format('d.m.y');

        $company = DB::table('Luv2_company')->where('code', auth()->user()->company_code)->first();
        foreach ($this->details as $detail) {
            $items[] = [
                'number' => $number++, 
                'item_code' => $detail->code ?? '',
                'barcode' => $detail->barcode ?? '',
                'description' => $detail->name ?? '',
                'size' => $detail->size_code ?? 'All Size',
                'price' => $detail->price ?? 0,
                'total' => $detail->total ?? 0,
                'qty'  => $detail->qty_detail,
            ];
        }
    
        $chunks = array_chunk($items, 34);
        $addedEmptyPage = false;
    
        if (count($chunks) > 0) {
            $lastChunkIndex = count($chunks) - 1;
            $lastChunkCount = count($chunks[$lastChunkIndex]);
    
            if ($lastChunkCount >= 28 && $lastChunkCount <= 34) {
                $chunks[] = [];
                $addedEmptyPage = true;
            }
        }
    
        $totalPages = count($chunks);
        $dataPages = [];
    
        foreach ($chunks as $pageIndex => $items) {
            $isEmptyPage = $addedEmptyPage && empty($items);
    
            $dataPages[] = [
                'company' => $company->name,
                'documentNumber' => $this->no->no,
                'documentDate' => $documentDate,
                'items' => $items,
                'totalPages' => $totalPages,
                'currentPage' => $pageIndex + 1,
                'isLastPage' => ($pageIndex + 1) === $totalPages,
                'isEmptyPage' => $isEmptyPage,
                'totalItems' => $this->no->qty,
                'grandTotal' => $this->no->total,
                'remark' => $this->no->remark,
                'asal' => $this->no->whs_name,
                'tujuan' => $this->no->name,
            ];
        }

        $label = 'Purchase Return';
    
        $pdf = Pdf::loadView('export.printpurchasereturn', compact('dataPages', 'label'))
            ->setPaper('A4', 'portrait');
    
        $fileName = 'purchase-return-' . $this->no->no. '.pdf';
        $pdfPath = storage_path('app/public/report/' . $fileName);
    
        $pdf->save($pdfPath);
    
        // Redirect to the file download
        return response()->streamDownload(function () use ($pdfPath) {
            echo file_get_contents($pdfPath);
        }, $fileName);
    }
}
