<?php

namespace App\Livewire\Report;

use App\Exports\ExportGoodsReceipt;
use App\Exports\ExportGoodsReceiptDet;
use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportMemberTransaction;
use App\Mail\MyTestMail;
use App\Models\DetailInvoice;
use App\Models\Invoice;
use App\Models\Member;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class GoodsReceipt extends Component
{
    use LivewireAlert;

    public $focusedHeader = true;
    public $supplier;
    public $startDate;
    public $endDate;
    // public $purchase;
    public $selectedDate;
    public $dataDetail;
    public $searchsupplier = '';
    public $selectedSupplier = null;
    public $selectedIndex;
    public $selectedCode = '';
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $purchase;
    public $purchaseDet;

    public function mount()
    {
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        $user = Auth::user();
        if ($user->role != 'Admin') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)
                ->where('company_code', auth()->user()->company_code)
                ->first();

            if ($warehouse) {

                $this->searchwarehouse = $warehouse->name;
                $this->selectedWarehouse = $warehouse;
            }
        }

    }

    public function focusedHeaderTrue()
    {
        $this->focusedHeader = true;
        $this->dispatch('refreshjs');
    }

    public function focusedHeaderFalse()
    {
        $this->focusedHeader = false;
        $this->dispatch('refreshjs');
    }

    public function filters()
    {
        $this->purchase = DB::table('Luv2_receipt')
            ->leftJoin('Luv2_supplier', 'Luv2_receipt.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_receipt.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_receipt.user_code', $user->code)
            // ->where('Luv2_receipt.deleted', '<>', 'Y')
            ->where('Luv2_receipt.date', '>=', $this->startDate)
            ->where('Luv2_receipt.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_receipt.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_receipt.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_receipt.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->purchaseDet = DB::table('Luv2_receipt')
            ->join('Luv2_receipt_detail', 'Luv2_receipt.no', '=', 'Luv2_receipt_detail.no')
            ->join('Luv2_item', 'Luv2_receipt_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_supplier', 'Luv2_receipt.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_receipt.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_receipt.user_code', $user->code)
            // ->where('Luv2_receipt.deleted', '<>', 'Y')
            ->where('Luv2_receipt.date', '>=', $this->startDate)
            ->where('Luv2_receipt.date', '<=', $this->endDate)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_receipt.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_receipt.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_receipt.no', 'Luv2_receipt.date', 'Luv2_receipt.remark', 'Luv2_receipt_detail.qty', 'Luv2_item.*', 'Luv2_supplier.name as supp', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->dispatch('refreshjs');

        // dd($this->selectedSupplier, $this->selectedWarehouse, $this->purchase, $this->purchaseDet);
    }

    public function exportExcel()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Goods Receipt Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Goods Receipt Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');

        return Excel::download(new ExportGoodsReceipt($this->purchase), $filename);
    }

    #[On('refreshTable')]
    public function refreshTable()
    {
        dd('aaa');
        $this->dispatch('refreshjs');
    }

    public function exportExcelDetail()
    {
        if ($this->startDate === $this->endDate) {
            $filename = "Goods Receipt Detail Report - {$this->startDate}.xlsx";
        } else {
            $filename = "Goods Receipt Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportGoodsReceiptDet($this->purchaseDet), $filename);
    }

    public function openModal($code)
    {
        // $members = Member::withCount(['invoices' => function ($query) {
        //     if ($this->startDate && $this->endDate) {
        //         $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        //     } elseif ($this->startDate) {
        //         $query->whereDate('created_at', '=', $this->startDate);
        //     } elseif ($this->endDate) {
        //         $query->whereDate('created_at', '<=', $this->endDate);
        //     }
        // }])->orderBy('invoices_count', 'desc')->get();

        // $members = $members->where('invoices_count', '>', 0);
        // $this->members = $members;

        // $data = Invoice::where('member_code', $code)
        //     ->when($this->startDate && $this->endDate, function ($query) {
        //         $query->whereBetween('created_at', [$this->startDate, $this->endDate]);
        //     })
        //     ->when($this->startDate && !$this->endDate, function ($query) {
        //         $query->whereDate('created_at', '=', $this->startDate);
        //     })
        //     ->when(!$this->startDate && $this->endDate, function ($query) {
        //         $query->whereDate('created_at', '<=', $this->endDate);
        //     })
        //     ->get();
        // $data->load('detailInvoices');

        // $this->dataDetail = $data;
    }

    public function updated()
    {
        $this->dispatch('refreshjs');
    }

    public function render()
    {
        $results = [];
        $resultwarehouse = [];

        if (strlen($this->searchsupplier) >= 1) {
            $results = DB::table('Luv2_supplier')->where('name', 'ILIKE', '%' . $this->searchsupplier . '%')->limit(10)
                ->where('company_code', auth()->user()->company_code)
                ->get();
            $this->supplier = $results;
        }
        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }
        $this->purchase = DB::table('Luv2_receipt')
            ->leftJoin('Luv2_supplier', 'Luv2_receipt.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_receipt.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_receipt.user_code', $user->code)
            // ->where('Luv2_receipt.deleted', '<>', 'Y')
            ->where('Luv2_receipt.date', '>=', $this->startDate)
            ->where('Luv2_receipt.date', '<=', $this->endDate)
            ->where('Luv2_receipt.company_code', auth()->user()->company_code)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_receipt.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_receipt.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_receipt.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->get();

        $this->purchaseDet = DB::table('Luv2_receipt')
            ->join('Luv2_receipt_detail', 'Luv2_receipt.no', '=', 'Luv2_receipt_detail.no')
            ->join('Luv2_item', 'Luv2_receipt_detail.item_code', '=', 'Luv2_item.code')
            ->leftJoin('Luv2_supplier', 'Luv2_receipt.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_receipt.whs_code', '=', 'Luv2_warehouse.code')
            // ->where('Luv2_receipt.user_code', $user->code)
            // ->where('Luv2_receipt.deleted', '<>', 'Y')
            ->where('Luv2_receipt.date', '>=', $this->startDate)
            ->where('Luv2_receipt.date', '<=', $this->endDate)
            ->where('Luv2_receipt.company_code', auth()->user()->company_code)
            ->when($this->selectedSupplier, function ($query) {
                $query->where('Luv2_receipt.supp_code', $this->selectedSupplier->code);
            })
            ->when($this->selectedWarehouse, function ($query) {
                $query->where('Luv2_receipt.whs_code', $this->selectedWarehouse->code);
            })
            ->select('Luv2_receipt.no', 'Luv2_receipt.date', 'Luv2_receipt_detail.linenum', 'Luv2_receipt_detail.qty', 'Luv2_receipt_detail.total', 'Luv2_item.*', 'Luv2_supplier.name as supp', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->orderBy('Luv2_receipt.date', 'ASC')
            ->orderBy('Luv2_receipt.no', 'ASC')
            ->orderBy('Luv2_receipt_detail.linenum', 'ASC')
            ->get();

        return view('livewire.report.goods-receipt', [
            'results' => $results,
            'resultwarehouse' => $resultwarehouse,
            'purchase' => $this->purchase,
            'purchaseDet' => $this->purchaseDet,
        ]);
    }

    public function clearfilters()
    {
        $this->searchsupplier = '';
        $this->searchwarehouse = '';
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');
        $this->selectedSupplier = null;
        $this->selectedWarehouse = null;

        $this->purchase = collect();
        $this->purchaseDet = collect();
        $this->dispatch('refreshjs');

    }


    public function selectSupplier($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->supplier[$index]->code;

        $supplier = DB::table('Luv2_supplier')->where('code', $this->selectedCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->selectedCode = null;
            $this->selectedIndex = null;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function selectSupplierByClick($supplierCode)
    {

        $supplier = DB::table('Luv2_supplier')->where('code', $supplierCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshjs');
        }
    }


    public function updatedSearchsupplier()
    {
        $this->selectedSupplier = null;
        $this->dispatch('refreshjs');
    }

    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }

        $this->dispatch('refreshjs');
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
        $this->dispatch('refreshjs');
    }
}
