<?php

namespace App\Livewire\Report\Analysis;

use App\Exports\ReportLossSales;
use App\Models\ItemGroup;
use App\Models\Pricelist;
use App\Models\Udf;
use App\Models\Warehouse;
use Carbon\Carbon;
use DateTime;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Calculation\TextData\Replace;
use Ramsey\Collection\Collection;

class StockAlert extends Component
{
    use LivewireAlert;

    public $period;
    public $to_date;
    public $id_pricelist;
    public $groupCheckboxes = [];
    public $collectionCheckboxes = [];
    public $groupSelectAll = false;
    public $collectionSelectAll = false;
    public $flagGroup = true;
    public $flagCollection = true;
    public $tableName = '';
    public $tableNameSales = '';
    public $tableNameResume = '';
    public $tableNameResumeMoh = '';
    public $issearch = false;
    public $udfs;
    public $collects;
    public $ignore_mdq = false;
    public $ignore_mdq_day = 0;
    public $udf2s;
    public $udf3s;
    public $search1;
    public $search2;
    public $search3;
    public $filterby;
    public $filterby2;
    public $filterby3;
    public $filterfield;
    public $filtername;
    public $searchby;
    public $searchby2;
    public $searchby3;
    public $filterfield2;
    public $filtername2;
    public $filterfield3;
    public $filtername3;

    // Add missing properties used in blade
    public $flagFilter1 = true;
    public $flagFilter2 = true;
    public $flagFilter3 = true;
    public $searchSelectAll1 = false;
    public $searchSelectAll2 = false;
    public $searchSelectAll3 = false;
    public $searchCheckboxes1 = [];
    public $searchCheckboxes2 = [];
    public $searchCheckboxes3 = [];

    protected $rules = [
        'period' => 'required',
        'ignore_mdq_day' => 'required|numeric|min:1',
    ];

    protected $messages = [
        'period.required' => 'The period field is required.',
        'ignore_mdq_day.required' => 'The ignore MDQ days field is required.',
        'ignore_mdq_day.numeric' => 'The ignore MDQ days must be a number.',
        'ignore_mdq_day.min' => 'The ignore MDQ days must be at least 1.',
    ];

    public function mount()
    {
        $this->period = Carbon::now()->format('Y-m-d');
    }

    public function render()
    {
        $groups = [];
        $this->udfs = [];
        $collections = [];
        $this->collects = [];

        try {
            // $groups = ItemGroup::where('id_company', session('id_company'))->where('whs_code', '<>', '')->orderBy('name', 'asc')->get();
            //$this->udfs = Udf::where('company_code', session('id_company'))->where('active', 'Y')->where('moh_rank', '>', 0)->orderBy('moh_rank', 'asc')->get();

            // $query = "select \"collection\" from (select min(\"CreateDate\") \"tgl\",\"U_IDU_Collection\" \"collection\" from \"" . session('database') . "\".oitm group by \"U_IDU_Collection\") z order by \"tgl\" desc;";
            // $url = session('url');
            // $response = Http::post($url . '/api/search', [
            //     "CustomQuery" => $query
            // ]);

            // if ($response->successful()) {
            //     $jsonData = $response->json();

            //     if (!empty($jsonData)) {
            //         if ($jsonData[0]['collection'] == '') {
            //             $jsonData = [];
            //         }

            //         if ($jsonData) {
            //             $collections = $jsonData;
            //             $this->collects = $collections;
            //         }
            //     }
            // }
            $udfs = collect([
                (object)['field' => 'brand_code', 'name' => 'Brand'],
                (object)['field' => 'category_code', 'name' => 'Category'],
                (object)['field' => 'size_code', 'name' => 'Size']
            ])->merge(
                DB::table('Luv2_udf')
                    ->where('company_code', auth()->user()->company_code)
                    ->where('active', 'Y')
                    ->get()
            )->sortBy('name');
            $this->udfs = $udfs;
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            // $this->dispatch('home');
        }

        //return view('livewire.report.analysis.stock-alert', compact('groups', 'collections'));
        return view('livewire.report.analysis.stock-alert');
    }

    public function checkData()
    {
        // $check = false;

        $this->validate([
            'period' => 'required'
        ]);

        // $check = true;

        // $this->flagGroup = false;
        // if ($this->groupSelectAll) {
        //     $this->flagGroup = true;
        //     $check = true;
        // } else {
        //     $trueValues = array_filter($this->groupCheckboxes, function ($value) {
        //         return $value === true;
        //     });

        //     $i = 0;
        //     foreach ($trueValues as $key) {
        //         $i++;
        //     }

        //     if ($i > 0) {
        //         $this->flagGroup = true;
        //         $check = true;
        //     } else {
        //         $this->flagGroup = false;
        //         $check = false;
        //     }
        // }

        // if ($check) {
        //     $check = false;

        //     $this->flagCollection = false;
        //     if ($this->collectionSelectAll) {
        //         $this->flagCollection = true;
        //         $check = true;
        //     } else {
        //         $trueValues = array_filter($this->collectionCheckboxes, function ($value) {
        //             return $value === true;
        //         });

        //         $i = 0;
        //         foreach ($trueValues as $key) {
        //             $i++;
        //         }

        //         if ($i > 0) {
        //             $this->flagCollection = true;
        //             $check = true;
        //         } else {
        //             $this->flagCollection = false;
        //             $check = false;
        //         }
        //     }
        // }

        if ($this->ignore_mdq) {
            $this->validate([
                'ignore_mdq_day' => 'required|numeric|min:1'
            ]);
        }

        // if ($check) {
        $this->dispatch('setData');
        // }
    }

    public function updatedFilterby()
    {
        if ($this->filterby == '') {
            $this->filterby2 = '';
            $this->filterby3 = '';
        } else {
            list($this->filterfield, $this->filtername) = explode('|', $this->filterby);
            $this->searchby = $this->filtername;

            try {
                // Remove the selected filter from udf2s options
                $this->udf2s = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->where('field', '<>', $this->filterfield)  // This removes the selected filter
                    ->sortBy('name');

                if ($this->filterfield == 'brand_code' || $this->filterfield == 'category_code' || $this->filterfield == 'size_code') {
                    $this->search1 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->get();
                } else {
                    $this->search1 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function updatedFilterby2()
    {
        if ($this->filterby2 == '') {
            $this->filterby3 = '';
        } else {
            list($this->filterfield2, $this->filtername2) = explode('|', $this->filterby2);
            $this->searchby2 = $this->filtername2;

            try {
                // Remove both filter1 and filter2 from udf3s options
                $this->udf3s = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->where('field', '<>', $this->filterfield)
                    ->where('field', '<>', $this->filterfield2)
                    ->sortBy('name');

                if ($this->filterfield2 == 'brand_code' || $this->filterfield2 == 'category_code' || $this->filterfield2 == 'size_code') {
                    $this->search2 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield2), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield2) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->get();
                } else {
                    $this->search2 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield2)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function updatedFilterby3()
    {
        if ($this->filterby3 != '') {
            list($this->filterfield3, $this->filtername3) = explode('|', $this->filterby3);
            $this->searchby3 = $this->filtername3;

            try {
                if ($this->filterfield3 == 'brand_code' || $this->filterfield3 == 'category_code' || $this->filterfield3 == 'size_code') {
                    $this->search3 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield3), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield3) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->get();
                } else {
                    $this->search3 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield3)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public $startTime;

    function stopTimer($startTime)
    {
        $endTime = microtime(true);
        $duration = round($endTime - $startTime, 4); // Calculate duration in seconds (rounded to 4 decimal places)
        return $duration;
    }

    #[On('setData')]
    public function setData()
    {
        // DB::statement('
        // CREATE EXTENSION IF NOT EXISTS tablefunc;
        // ');

        // $query = DB::select(
        //     '
        // WITH cte AS (
        // SELECT DISTINCT udf_no FROM "Luv2_warehouse_udf_detail" ORDER BY udf_no
        // )
        // SELECT \'SELECT no, \' || string_agg(\'MAX(CASE WHEN udf_no = \' || udf_no || \' THEN udf END) AS udf_\' || udf_no, \', \') || 
        // \' FROM "Luv2_warehouse_udf_detail" GROUP BY no;\' as q
        // FROM cte;'
        // );

        // if ($query) {
        //     // $data = DB::select($query[0]);
        //     $sql = $query[0]->q;
        //     $result = DB::select($sql);
        //     dd($result);
        // }


        $this->issearch = true;
        $this->dispatch('getData');
    }

    #[On('getData')]
    public function getData()
    {
        try {

            $this->startTime = microtime(true);

            // $group = '';

            // if ($this->groupSelectAll) {
            //     $groupList = ItemGroup::where('company_code', session('id_company'))->where('whs_code', '<>', '')->orderBy('name', 'asc')->get();

            //     foreach ($groupList as $grp) {
            //         $group .= "'" . $grp->code . "',";
            //     }
            // } else {
            //     $trueValues = array_filter($this->groupCheckboxes, function ($value) {
            //         return $value === true;
            //     });

            //     foreach ($trueValues as $key => $value) {
            //         $group .= "'" . $key . "',";
            //     }
            // }

            // if ($group != "") {
            //     $group = " and a.\"ItmsGrpCod\" in (" . rtrim($group, ',') . ")";
            // }

            // $collections = '';

            // if ($this->collectionSelectAll) {
            //     foreach ($this->collects as $collect) {
            //         $collections .= "'" . $collect['collection'] . "',";
            //     }
            // } else {
            //     $trueValues = array_filter($this->collectionCheckboxes, function ($value) {
            //         return $value === true;
            //     });

            //     foreach ($trueValues as $key => $value) {
            //         $collections .= "'" . $key . "',";
            //     }
            // }

            // if ($collections != "") {
            //     $collections = " and a.\"U_IDU_Collection\" in (" . rtrim($collections, ',') . ")";
            // }

            // $udfColumn = '';
            // $udfGroup = '';
            // $udfField = '';
            // if ($this->udfs) {
            //     foreach ($this->udfs as $udf) {
            //         $udfColumn .= "," . $udf->no . " \"" . $udf->field . "_no\",a.\"" . $udf->field . "\"";
            //         $udfGroup .= ",a.\"" . $udf->field . "\"";
            //         $udfField .= "\"" . $udf->field . "_no\" int2,\"" . $udf->field . "\" varchar(254),";
            //     }
            // }

            // $query = "select a.\"ItmsGrpCod\" \"group_code\",c.\"ItmsGrpNam\" \"group_name\",b.\"Warehouse\" \"whs_code\",d.\"WhsName\" \"whs_name\"" . $udfColumn . ",a.\"ItemCode\" \"code\",a.\"CodeBars\" \"barcode\",a.\"ItemName\" \"name\",sum(b.\"InQty\"-b.\"OutQty\") \"onhand\",COALESCE(DAYS_BETWEEN(min(b.\"DocDate\"), TO_DATE('" . $this->period . "')), 0) \"aging\" from \"" . session('database') . "\".oitm a inner join \"" . session('database') . "\".oinm b on a.\"ItemCode\"=b.\"ItemCode\" inner join \"" . session('database') . "\".oitb c on a.\"ItmsGrpCod\"=c.\"ItmsGrpCod\" inner join \"" . session('database') . "\".owhs d on b.\"Warehouse\"=d.\"WhsCode\" where b.\"DocDate\"<='" . $this->period . "'" . $group . $collections . " group by a.\"ItmsGrpCod\",c.\"ItmsGrpNam\",b.\"Warehouse\",d.\"WhsName\"" . $udfGroup . ",a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\" order by a.\"ItmsGrpCod\",b.\"Warehouse\"" . $udfGroup . ";";

            // $url = session('url');
            // $response = Http::post($url . '/api/search', [
            //     "CustomQuery" => $query
            // ]);

            // if ($response->successful()) {
            //     $jsonData = $response->json();

            //     if (!empty($jsonData)) {
            //         if ($jsonData[0]['group_code'] == '') {
            //             $jsonData = [];
            //         }

            //         if ($jsonData) {

            $user = auth()->user()->id;
            $this->tableName = $user . "_" . Carbon::now()->format('ymdHis');
            $this->tableNameSales = $this->tableName . "_sales";
            $this->tableNameResume = $this->tableName . "_resume";
            $this->tableNameResumeMoh = $this->tableName . "_resumemoh";

            DB::statement('DROP TABLE IF EXISTS "' . $this->tableName . '";');
            // DB::statement('
            //     CREATE TABLE "' . $this->tableName . '" (
            //     "id_company" int2,
            //     "group_code" int2,
            //     "group_name" varchar(20),
            //     "whs_code" varchar(8),
            //     "whs_central" varchar(8) default \'\',
            //     "whs_name" varchar(100),' . $udfField . '
            //     "code" varchar(30),
            //     "barcode" varchar(255),
            //     "name" varchar(100),
            //     "moh" numeric(10,0) default 0,
            //     "mdq" int2 default 0,
            //     "moh_rank" int2 default 0,
            //     "aging" int2 default 0,
            //     "from_date" date,
            //     "to_date" date,
            //     "sales" numeric(10,0) default 0,
            //     "avgsales" numeric(10,2) default 0.00,
            //     "sas" numeric(10,2) default 0.00,
            //     "onhand" numeric(10,0) default 0,
            //     "moh_actual" numeric(10,2) default 0.00,
            //     "moh_info" varchar(3),
            //     "moh_diff" numeric(10,2) default 0.00,
            //     "moh_diff_0" numeric(10,2) default 0.00,
            //     "moh_sas" numeric(10,2) default 0.00,
            //     "moh_consolidation" numeric(10,2) default 0.00,
            //     "moh_round" numeric(10,2) default 0.00,
            //     "moh_sasxonhand" numeric(10,2) default 0.00,
            //     "moh_round2" numeric(10,0) default 0,
            //     "moh_diff2" numeric(10,2) default 0.00,
            //     "rank" numeric(10) default 0,
            //     "rank_sas" numeric(10,2) default 0.00,
            //     "salesminstock" numeric(10,2) default 0.00,
            //     "recommend" numeric(10,0) default 0,
            //     "used_qty_transfer" numeric(10,0) default 0,
            //     "used_qty_return" numeric(10,0) default 0);');

            DB::statement('
            CREATE TABLE "' . $this->tableName . '" (
            "whs_code" varchar(30),
            "whs_central" varchar(30) default \'\',
            "whs_name" varchar(100),
            "brand_code" varchar(30),
            "brand" varchar(50),
            "category_code" varchar(30),
            "category" varchar(50),
            "size_code" varchar(30),
            "size" varchar(50),
            "code" varchar(30),
            "barcode" varchar(30),
            "name" varchar(100),
            "moh" numeric(10,0) default 0,
            "mdq" int2 default 0,
            "moh_rank" int2 default 0,
            "aging" int2 default 0,
            "from_date" date,
            "to_date" date,
            "sales" numeric(10,0) default 0,
            "avgsales" numeric(10,2) default 0.00,
            "sas" numeric(10,2) default 0.00,
            "onhand" numeric(10,0) default 0,
            "moh_actual" numeric(10,2) default 0.00,
            "moh_info" varchar(3),
            "moh_diff" numeric(10,2) default 0.00,
            "moh_diff_0" numeric(10,2) default 0.00,
            "moh_sas" numeric(10,2) default 0.00,
            "moh_consolidation" numeric(10,2) default 0.00,
            "moh_round" numeric(10,2) default 0.00,
            "moh_sasxonhand" numeric(10,2) default 0.00,
            "moh_round2" numeric(10,0) default 0,
            "moh_diff2" numeric(10,2) default 0.00,
            "rank" numeric(10) default 0,
            "rank_sas" numeric(10,2) default 0.00,
            "salesminstock" numeric(10,2) default 0.00,
            "recommend" numeric(10,0) default 0,
            "used_qty_transfer" numeric(10,0) default 0,
            "used_qty_return" numeric(10,0) default 0);');

            DB::statement('
            CREATE INDEX "' . $this->tableName . '_whs_code" ON "' . $this->tableName . '" ("whs_code");');
            DB::statement('
            CREATE INDEX "' . $this->tableName . '_whs_central" ON "' . $this->tableName . '" ("whs_central");');
            DB::statement('
            CREATE INDEX "' . $this->tableName . '_brand" ON "' . $this->tableName . '" ("brand_code");');
            DB::statement('
            CREATE INDEX "' . $this->tableName . '_category" ON "' . $this->tableName . '" ("category_code");');
            DB::statement('
            CREATE INDEX "' . $this->tableName . '_size" ON "' . $this->tableName . '" ("size_code");');
            DB::statement('
            CREATE INDEX "' . $this->tableName . '_code" ON "' . $this->tableName . '" ("code");');

            // if ($this->udfs) {
            //     foreach ($this->udfs as $udf) {
            //         DB::statement('
            //             CREATE INDEX "' . $this->tableName . '_' .  $udf->field . '" ON "' . $this->tableName . '" ("' .  $udf->field . '");');
            //     }
            // }

            //$chunks = array_chunk($jsonData, 1000);

            // foreach ($chunks as $chunk) {
            //     $insertData = [];

            //     foreach ($chunk as $data) {
            //         $row = [
            //             'id_company' => session('id_company'),
            //             'group_code' => $data['group_code'],
            //             'group_name' => $data['group_name'],
            //             'whs_code' => $data['whs_code'],
            //             'whs_name' => $data['whs_name'],
            //             'code' => $data['code'],
            //             'barcode' => $data['barcode'],
            //             'name' => $data['name'],
            //             'to_date' => $this->period,
            //             'onhand' => $data['onhand'],
            //             'aging' => $data['aging'],
            //         ];

            //         foreach ($this->udfs as $udf) {
            //             $row[$udf->field . "_no"] = $data[$udf->field . "_no"] ?? null;
            //             $row[$udf->field] = $data[$udf->field] ?? null;
            //         }

            //         $insertData[] = $row;
            //     }

            //     DB::table($this->tableName)->insert($insertData);
            // }

            $queryFilter1 = '';
            $queryFilterUdf1 = '';
            if ($this->filterby != '') {
                list($this->filterfield, $this->filtername) = explode('|', $this->filterby);
                // $queryFilter1 = " and upper(b.\"" . $this->filterfield . "\")=upper('" . $this->filter . "')";

                if ($this->filterfield == 'brand_code' || $this->filterfield == 'category_code' || $this->filterfield == 'size_code') {
                    if ($this->searchSelectAll1) {
                        $queryFilter1 = " and a.\"" . $this->filterfield . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes1, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter1 .= "'" . $key . "',";
                        }

                        if ($queryFilter1 != '') {
                            $queryFilter1 = " and a.\"" . $this->filterfield . "\" in (" . rtrim($queryFilter1, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield)->where('company_code', auth()->user()->company_code)->first();
                    if ($this->searchSelectAll1) {
                        $queryFilterUdf1 = " and \"code_udf\"='" . $code->code . "' and \"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes1, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf1 .= "'" . $key . "',";

                        }

                        if ($queryFilterUdf1 != '') {
                            $queryFilterUdf1 = " and \"code_udf\"='" . $code->code . "' and \"value\" in (" . rtrim($queryFilterUdf1, ',') . ")";
                        }
                    }
                }
            }


            $queryFilter2 = '';
            $queryFilterUdf2 = '';
            if ($this->filterby2 != '') {
                list($this->filterfield2, $this->filtername2) = explode('|', $this->filterby2);
                // $queryFilter2 = " and upper(b.\"" . $this->filterfield2 . "\")=upper('" . $this->filter2 . "')";

                if ($this->filterfield2 == 'brand_code' || $this->filterfield2 == 'category_code' || $this->filterfield2 == 'size_code') {
                    if ($this->searchSelectAll2) {
                        $queryFilter2 = " and a.\"" . $this->filterfield2 . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes2, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter2 .= "'" . $key . "',";
                        }

                        if ($queryFilter2 != '') {
                            $queryFilter2 = " and a.\"" . $this->filterfield2 . "\" in (" . rtrim($queryFilter2, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield2)->where('company_code', auth()->user()->company_code)->first();
                    if ($this->searchSelectAll2) {
                        $queryFilterUdf2 = " and \"code_udf\"='" . $code->code . "' and \"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes2, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf2 .= "'" . $key . "',";
                        }

                        if ($queryFilterUdf2 != '') {
                            $queryFilterUdf2 = " and \"code_udf\"='" . $code->code . "' and \"value\" in (" . rtrim($queryFilterUdf2, ',') . ")";
                        }
                    }
                }
            }

            $queryFilter3 = '';
            $queryFilterUdf3 = '';
            if ($this->filterby3 != '') {
                list($this->filterfield3, $this->filtername3) = explode('|', $this->filterby3);
                // $queryFilter3 = " and upper(b.\"" . $this->filterfield3 . "\")=upper('" . $this->filter3 . "')";

                if ($this->filterfield3 == 'brand_code' || $this->filterfield3 == 'category_code' || $this->filterfield3 == 'size_code') {
                    if ($this->searchSelectAll3) {
                        $queryFilter3 = " and a.\"" . $this->filterfield3 . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes3, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter3 .= "'" . $key . "',";
                        }

                        if ($queryFilter3 != '') {
                            $queryFilter3 = " and a.\"" . $this->filterfield3 . "\" in (" . rtrim($queryFilter3, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield3)->where('company_code', auth()->user()->company_code)->first();
                    if ($this->searchSelectAll3) {
                        $queryFilterUdf3 = " and \"code_udf\"='" . $code->code . "' and \"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes3, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf3 .= "'" . $key . "',";
                        }

                        if ($queryFilterUdf3 != '') {
                            $queryFilterUdf3 = " and \"code_udf\"='" . $code->code . "' and \"value\" in (" . rtrim($queryFilterUdf3, ',') . ")";
                        }
                    }
                }
            }


            if ($queryFilterUdf1 != '' || $queryFilterUdf2 != '' || $queryFilterUdf3 != '') {
                $query = "
                INSERT INTO \"" . $this->tableName . "\" (whs_code,whs_name,brand_code,brand,category_code,category,size_code,size,code,barcode,name,to_date,onhand,aging) select b.whs_code,d.name whs_name,a.brand_code,e.name brand,a.category_code,f.name category,a.size_code,g.name size,a.code,a.barcode,a.name,'" . $this->period . "',sum(b.qty) onhand,COALESCE(((DATE('" . $this->period . "')-min(b.date))/86400)::int, 0) aging from \"Luv2_item\" a inner join \"Luv2_item_trans\" b on a.code=b.item_code and a.company_code=b.company_code inner join \"Luv2_warehouse\" d on b.whs_code=d.code and a.company_code=d.company_code inner join \"Luv2_brand\" e on a.brand_code=e.code and a.company_code=e.company_code inner join \"Luv2_category\" f on a.category_code=f.code and a.company_code=f.company_code inner join \"Luv2_size\" g on a.size_code=g.code and a.company_code=g.company_code inner join (
                        select item_code, company_code
                        from \"Luv2_udf_item\" 
                        where company_code='" . auth()->user()->company_code . "'" . $queryFilterUdf1 . $queryFilterUdf2 . $queryFilterUdf3 . "
                        group by item_code, company_code
                        having count(distinct code_udf) = " . (
                            ($queryFilterUdf1 != '' ? 1 : 0) + 
                            ($queryFilterUdf2 != '' ? 1 : 0) + 
                            ($queryFilterUdf3 != '' ? 1 : 0)
                        ) . "
                    ) h on a.\"code\"=h.\"item_code\" and a.\"company_code\"=h.\"company_code\" where b.date<='" . $this->period . "' and a.company_code='" . auth()->user()->company_code . "'" . $queryFilter1 . $queryFilter2 . $queryFilter3 ." group by b.whs_code,d.name,a.brand_code,e.name,a.category_code,f.name,a.size_code,g.name,a.code,a.barcode,a.name order by b.whs_code;";
                DB::statement($query);
        
            } else {
                $query = "
                INSERT INTO \"" . $this->tableName . "\" (whs_code,whs_name,brand_code,brand,category_code,category,size_code,size,code,barcode,name,to_date,onhand,aging) select b.whs_code,d.name whs_name,a.brand_code,e.name brand,a.category_code,f.name category,a.size_code,g.name size,a.code,a.barcode,a.name,'" . $this->period . "',sum(b.qty) onhand,COALESCE(((DATE('" . $this->period . "')-min(b.date))/86400)::int, 0) aging from \"Luv2_item\" a inner join \"Luv2_item_trans\" b on a.code=b.item_code and a.company_code=b.company_code inner join \"Luv2_warehouse\" d on b.whs_code=d.code and a.company_code=d.company_code inner join \"Luv2_brand\" e on a.brand_code=e.code and a.company_code=e.company_code inner join \"Luv2_category\" f on a.category_code=f.code and a.company_code=f.company_code inner join \"Luv2_size\" g on a.size_code=g.code and a.company_code=g.company_code where b.date<='" . $this->period . "' and a.company_code='" . auth()->user()->company_code . "'" . $queryFilter1 . $queryFilter2 . $queryFilter3 ." group by b.whs_code,d.name,a.brand_code,e.name,a.category_code,f.name,a.size_code,g.name,a.code,a.barcode,a.name order by b.whs_code;";
                DB::statement($query);
            }



            DB::statement('update "' . $this->tableName . '" set "whs_central"=b."code" from "Luv2_warehouse" b where b."company_code"=\'' . auth()->user()->company_code . '\' and b."whs_central"=\'Y\';');

            // $query = DB::select("select * from \"" . $this->tableName . "\";");
            // dd($query);

            $check = DB::table($this->tableName)->first();

            if ($check) {
                //$this->dispatch('getMoh', $group);
                $this->dispatch('getMoh');
            } else {
                $this->alert('warning', 'Tidak ada data untuk ditampilkan', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->issearch = false;
            }
            //         } else {
            //             $this->alert('warning', 'No data to show', [
            //                 'position' => 'top-end',
            //                 'timer' => 2500,
            //                 'toast' => true,
            //                 'timerProgressBar' => true,
            //             ]);
            //             $this->issearch = false;
            //         }
            //     } else {
            //         $this->alert('warning', 'No data to show', [
            //             'position' => 'top-end',
            //             'timer' => 2500,
            //             'toast' => true,
            //             'timerProgressBar' => true,
            //         ]);
            //         $this->issearch = false;
            //     }
            // } else {
            //     $this->alert('error', 'No Connection to server', [
            //         'position' => 'top-end',
            //         'timer' => 2500,
            //         'toast' => true,
            //         'timerProgressBar' => true,
            //     ]);
            //     $this->issearch = false;
            // }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", coba lagi" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    // private function generateUdfIndexes($udfField)
    // {
    //     $udfColumns = explode(',', $udfField);
    //     $indexes = '';
    //     foreach ($udfColumns as $column) {
    //         $columnName = trim($column, '" ');
    //         $indexes .= 'CREATE INDEX "' . $this->tableName . '_' . $columnName . '" ON "' . $this->tableName . '" ("' . $columnName . '");';
    //     }
    //     return $indexes;
    // }

    #[On('getMoh')]
    public function getMOH()
    {
        try {
            DB::statement('update "' . $this->tableName . '" a set "moh"=b."moh","mdq"=b."mdq","moh_rank"=b."moh_rank" from "Luv2_warehouse" b where a."whs_code"=b."code" and b."company_code"=\'' . auth()->user()->company_code . '\' and b."moh"<>0;');
            DB::statement('update "' . $this->tableName . '" a set "moh"=b."moh","mdq"=b."mdq" from "Luv2_udf_moh" b where a."whs_code"=b."whs_code" and a."brand_code"=b."brand_code" and a."category_code"=b."category_code" and a."size_code"=b."size_code" and b."company_code"=\'' . auth()->user()->company_code . '\' and b."moh"<>0;');

            $this->dispatch('getFromDate');
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", coba lagi" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('getFromDate')]
    public function getFromDate()
    {
        try {
            DB::statement('
            UPDATE "' . $this->tableName . '" SET "from_date" = "to_date" - ("moh" || \' days\')::interval;');

            $this->dispatch('getSalesSAP');
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", coba lagi" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('getSalesSAP')]
    public function getSalesSAP()
    {
        // try {
        $moh = DB::select('select max(moh) dif from "' . $this->tableName . '";');
        $from_date = Carbon::parse($this->period)->subDays($moh[0]->dif)->format('Y-m-d');

        DB::statement('DROP TABLE IF EXISTS "' . $this->tableNameSales . '";');
        DB::statement('
            CREATE TABLE "' . $this->tableNameSales . '" (
            "whs_code" varchar(12),
            "date" date,
            "item_code" varchar(30),
            "qty" numeric(10,0) default 0);');

        DB::statement('insert into "' . $this->tableNameSales . '" (whs_code,date,item_code,qty) select a.whs_code,a.date,b.code,sum(b.qty) qty from "Luv2_invoice" a inner join "Luv2_invoice_detail" b on a.no=b.no and a.company_code=b.company_code inner join "Luv2_item" c on b.code=c.code and b.company_code=c.company_code where a.date between \'' . $from_date . '\' and \'' . $this->period . '\' and a.company_code=\'' . auth()->user()->company_code . '\' group by a.whs_code,a.date,b.code;');
        $check = DB::table($this->tableNameSales)->first();

        if ($check) {
            $this->dispatch('getSales');
        } else {
            $this->alert('warning', 'Tidak ada data untuk ditampilkan', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
        // } catch (Exception $ex) {
        //     $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", coba lagi" : $ex->getMessage();
        //     $this->alert('error', $message, [
        //         'position' => 'top-end',
        //         'timer' => 2500,
        //         'toast' => true,
        //         'timerProgressBar' => true,
        //     ]);
        //     $this->issearch = false;
        // }
    }

    #[On('getSales')]
    public function getSales()
    {
        try {
            DB::statement('update "' . $this->tableName . '" a set "sales"=(select sum(b."qty") from "' . $this->tableNameSales . '" b where b."whs_code"=a."whs_code" and b."item_code"=a."code" and b."date" between a."from_date" AND a."to_date");');
            // DB::statement('update "' . $this->tableName . '" a set "sales"=(select c."qty" from "' . $this->tableName . '" a inner join (select a."whs_code",a."code",sum(b."qty") "qty" from "' . $this->tableName . '" a inner join "' . $this->tableNameSales . '" b on b."whs_code"=a."whs_code" and b."item_code"=a."code" and b."date" between a."from_date" AND a."to_date" group by a."whs_code",a."code") c on c."whs_code"=a."whs_code" and c."code"=a."code");');
            DB::statement('update "' . $this->tableName . '" set "sales"=0 where "sales" is null;');
            DB::statement('delete from "' . $this->tableName . '" where "onhand"=0 and "sales"=0;');
            DB::statement('update "' . $this->tableName . '" set "avgsales"=case when "moh"=0 then 0 else "sales"/"moh" end;');

            $this->dispatch('getSalesResume');
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('getSalesResume')]
    public function getSalesResume()
    {
        try {
            DB::statement('DROP TABLE IF EXISTS "' . $this->tableNameResume . '";');
            DB::statement('
            CREATE TABLE "' . $this->tableNameResume . '" (
            "whs_central" varchar(12),
            "item_code" varchar(30),
            "avgsales" numeric(10,2) default 0.00,
            "onhand" numeric(10,2) default 0.00,
            "onhand_central" numeric(10,2) default 0.00,
            "onhand_available" numeric(10,2) default 0.00,
            "moh" numeric(10,2) default 0.00,
            "used_qty" numeric(10,0) default 0,
            "used_qty_transfer" numeric(10,0) default 0,
            "used_qty_return" numeric(10,0) default 0);');

            DB::statement('
                CREATE INDEX "' . $this->tableNameResume . 'whs_central" ON "' . $this->tableNameResume . '" ("whs_central");');
            DB::statement('
                CREATE INDEX "' . $this->tableNameResume . 'item_code" ON "' . $this->tableNameResume . '" ("item_code");');


            DB::statement('insert into "' . $this->tableNameResume . '" select \'\',"code",sum("avgsales"),sum("onhand"),0,0,0 from "' . $this->tableName . '" group by "code";');
            DB::statement('update "' . $this->tableNameResume . '" set "moh"=case when "avgsales"=0 then 0 else "onhand"/"avgsales" end;');
            DB::statement('update "' . $this->tableNameResume . '" set "whs_central"=b."code" from "Luv2_warehouse" b where b."company_code"=\'' . auth()->user()->company_code . '\' and b."whs_central"=\'Y\';');
            DB::statement('update "' . $this->tableNameResume . '" set "onhand_central"=b."onhand" from "' . $this->tableName . '" b where "' . $this->tableNameResume . '"."whs_central"=b."whs_code" and "' . $this->tableNameResume . '"."item_code"=b."code";');
            DB::statement('update "' . $this->tableName . '" set "sas"=case when b."avgsales"=0 then 0 else "' . $this->tableName . '"."avgsales"/b."avgsales" end from "' . $this->tableNameResume . '" b where "' . $this->tableName . '"."code"=b."item_code";');

            $this->dispatch('getMohActual');
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('getMohActual')]
    public function getMohActual()
    {
        try {
            $whs_central = DB::table($this->tableNameResume)
                ->select('whs_central')
                ->first();

            DB::statement('update "' . $this->tableName . '" set "moh_actual"=case when b."avgsales"=0 then 0 else  "' . $this->tableName . '"."onhand"/b."avgsales" end from "' . $this->tableNameResume . '" b where "' . $this->tableName . '"."code"=b."item_code";');
            DB::statement('update "' . $this->tableName . '" set "moh_actual"=case when "avgsales"=0 then 0 else "onhand"/"avgsales" end where "whs_code"<>\'' . $whs_central->whs_central . '\';');

            DB::statement('update "' . $this->tableName . '" set "moh_info"=case when "' . $this->tableName . '"."moh_actual">b."moh" then \'Y\' else \'N\' end,"moh_diff"=b."moh"-"' . $this->tableName . '"."moh_actual" from "' . $this->tableNameResume . '" b where "' . $this->tableName . '"."code"=b."item_code" AND b."whs_central" IS NOT NULL AND b."item_code" IS NOT NULL;');

            DB::statement('update "' . $this->tableName . '" set "moh_diff_0"=case when "moh_diff"<=0 then 0 else "moh_diff" end;');

            $this->dispatch("getMohResume");
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('getMohResume')]
    public function getMohResume()
    {
        try {
            DB::statement('DROP TABLE IF EXISTS "' . $this->tableNameResumeMoh . '";');
            DB::statement('
        CREATE TABLE "' . $this->tableNameResumeMoh . '" (
            "item_code" varchar(30),
            "moh_diff_0" numeric(10,2) default 0.00);');

            DB::statement('
                CREATE INDEX "' . $this->tableNameResumeMoh . 'item_code" ON "' . $this->tableNameResumeMoh . '" ("item_code");');

            DB::statement('insert into "' . $this->tableNameResumeMoh . '" select "code",sum("moh_diff_0") from "' . $this->tableName . '" group by "code";');
            DB::statement('update "' . $this->tableName . '" set "moh_sas"=case when b."moh_diff_0"=0 then 0 else "' . $this->tableName . '"."moh_diff_0"/b."moh_diff_0" end from "' . $this->tableNameResumeMoh . '" b where "' . $this->tableName . '"."code"=b."item_code";');
            DB::statement('update "' . $this->tableName . '" set "moh_consolidation"=b."moh"*"' . $this->tableName . '"."avgsales"-"' . $this->tableName . '"."onhand" from "' . $this->tableNameResume . '" b where "' . $this->tableName . '"."code"=b."item_code";');
            DB::statement('update "' . $this->tableName . '" set "moh_round"=case when "moh_consolidation"<0 then ceil("moh_consolidation") else "moh_consolidation" end;');
            DB::statement('update "' . $this->tableName . '" set "moh_sasxonhand"="' . $this->tableName . '"."moh_sas"*b."onhand_central" from "' . $this->tableNameResume . '" b where "' . $this->tableName . '"."code"=b."item_code";');
            DB::statement('update "' . $this->tableName . '" set "moh_round2"=floor("moh_sasxonhand");');
            DB::statement('update "' . $this->tableName . '" set "moh_diff2"="moh_sasxonhand"-"moh_round2";');
            DB::statement('with ranked_data AS (SELECT "code", "whs_code", "avgsales", DENSE_RANK() OVER (PARTITION BY "code" ORDER BY "sales" DESC) AS rank FROM "' . $this->tableName . '") UPDATE "' . $this->tableName . '" SET "rank" = "ranked_data"."rank" FROM "ranked_data" WHERE "' . $this->tableName . '"."code" = "ranked_data"."code" AND "' . $this->tableName . '"."whs_code" = "ranked_data"."whs_code";');
            DB::statement('update "' . $this->tableName . '" set "rank_sas"=case when "rank"=1 then 1 else 0 end,"salesminstock"="sales"-"onhand";');
            DB::statement('update "' . $this->tableName . '" set "recommend"=case when "moh_round"<0 then "moh_round" else "moh_round2"+"rank_sas" end;');
            DB::statement('update "' . $this->tableName . '" set "recommend"=case when "recommend"<0 and "onhand"+"recommend"=0 then (case when "recommend"*-1<"mdq" then 0 else "mdq"-"onhand" end) else "recommend" end;');

            DB::statement('delete from "' . $this->tableName . '" where "whs_code"="whs_central";');

            $where = '';
            if ($this->ignore_mdq) {
                $where = ' and a.aging<=' . $this->ignore_mdq_day;
            }


            DB::statement('
                WITH total_recommend AS (
                    SELECT 
                        code, 
                        SUM(recommend) AS total_recommend
                    FROM "' . $this->tableName . '"
                    WHERE recommend>0
                    GROUP BY code
                )
                UPDATE "' . $this->tableNameResume . '" ar
                SET onhand_available = ar.onhand_central - tr.total_recommend,used_qty = tr.total_recommend
                FROM total_recommend tr
                WHERE ar.item_code = tr.code;
            ');

            DB::statement('update "' . $this->tableNameResume . '" set "onhand_available"="onhand_central" where "onhand_available"=0 and "onhand_central">0 and "used_qty"=0;');

            DB::statement('
                WITH ranked AS (
                    SELECT 
                        a."code",
                        a."whs_code",
                        a."recommend",
                        a."mdq",
                        a."onhand",
                        a."moh_rank",
                        b."onhand_available",
                        SUM(a."mdq" - a."recommend" - a."onhand") OVER (
                            PARTITION BY a."code" ORDER BY a."moh_rank" ASC 
                            ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
                        ) AS cumulative_needed
                    FROM "' . $this->tableName . '" a
                    JOIN "' . $this->tableNameResume . '" b ON a."code" = b."item_code"
                    WHERE a."recommend" >= 0 AND a."recommend" < a."mdq"
                ),
                updated AS (
                    SELECT 
                        "code",
                        "whs_code",
                        LEAST(
                            GREATEST("onhand_available" - COALESCE(LAG(cumulative_needed, 1, 0) OVER (
                                PARTITION BY "code" ORDER BY "moh_rank"
                            ), 0), 0),
                            ("mdq" - "recommend" - "onhand")
                        ) AS used_qty_transfer
                    FROM ranked
                )
                UPDATE "' . $this->tableName . '" a
                SET 
                    "recommend" = "recommend" + updated.used_qty_transfer,
                    "used_qty_transfer" = updated.used_qty_transfer
                FROM updated
                WHERE a."code" = updated."code" 
                AND a."whs_code" = updated."whs_code"
                AND a."recommend" >= 0 AND a."recommend" < a."mdq";
            ');

            DB::statement('
                WITH summed_used_qty_transfer AS (
                    SELECT 
                        "code",
                        SUM("used_qty_transfer") AS total_used_qty_transfer
                    FROM "' . $this->tableName . '"
                    GROUP BY "code"
                )
                UPDATE "' . $this->tableNameResume . '" b
                SET
                "used_qty_transfer"=COALESCE(summed_used_qty_transfer.total_used_qty_transfer, 0),
                "onhand_available"="onhand_available"-COALESCE(summed_used_qty_transfer.total_used_qty_transfer, 0)
                FROM summed_used_qty_transfer
                WHERE b."item_code" = summed_used_qty_transfer."code";
            ');

            DB::statement('
                WITH ranked AS (
                    SELECT 
                        a."code",
                        a."whs_code",
                        a."recommend",
                        a."onhand",
                        a."mdq",
                        a."moh_rank",
                        b."onhand_available",
                        SUM(a."mdq" - a."onhand") OVER (
                            PARTITION BY a."code" ORDER BY a."moh_rank" ASC 
                            ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW
                        ) AS cumulative_needed
                    FROM "' . $this->tableName . '" a
                    JOIN "' . $this->tableNameResume . '" b ON a."code" = b."item_code"
                    WHERE a."recommend" < 0 AND a."onhand" < a."mdq"' . $where . '
                ),
                updated AS (
                    SELECT 
                        "code",
                        "whs_code",
                        "onhand", 
                        LEAST(
                            GREATEST("onhand_available" - COALESCE(LAG(cumulative_needed, 1, 0) OVER (
                                PARTITION BY "code" ORDER BY "moh_rank"
                            ), 0), 0),
                            ("mdq" - "onhand")
                        ) AS new_recommend,
                        LEAST(
                            GREATEST("onhand_available" - COALESCE(LAG(cumulative_needed, 1, 0) OVER (
                                PARTITION BY "code" ORDER BY "moh_rank"
                            ), 0), 0),
                            ("mdq" - "onhand")
                        ) AS used_qty_return
                    FROM ranked
                )
                UPDATE "' . $this->tableName . '" a
                SET 
                    --"recommend" = updated.new_recommend,
                    "used_qty_return" = updated.used_qty_return
                FROM updated
                WHERE a."code" = updated."code"
                AND a."whs_code" = updated."whs_code"
                AND a."recommend" < 0 AND a."onhand" < a."mdq"' . $where . ';
            ');

            if ($this->ignore_mdq) {
                DB::statement('update "' . $this->tableName . '" set "recommend"=(case when "aging"<=' . $this->ignore_mdq_day . ' then (case when "mdq">"onhand" then 0 else "mdq"-"onhand" end) else "recommend" end) where "recommend"<0 and "used_qty_return"=0 and "onhand"+"recommend"=0;');
            } else {
                DB::statement('update "' . $this->tableName . '" set "recommend"=(case when "mdq">"onhand" then 0 else "mdq"-"onhand" end) where "recommend"<0 and "used_qty_return"=0 and "onhand"+"recommend"=0;');
            }

            DB::statement('update "' . $this->tableName . '" set "recommend"="used_qty_return" where "recommend"<0 and "used_qty_return">0;');


            $this->dispatch('showTable', $this->tableName, $this->period)->to(StockAlertTable::class);

            $this->issearch = false;

            $duration = round(microtime(true) - $this->startTime, 4);

            $this->alert('success', "The process took {$duration} seconds", [
                'position' => 'top-end',
                'timer' => 10000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->issearch = false;
        }
    }

    #[On('refreshData')]
    public function refreshData()
    {
        $this->dispatch('refresh');
    }

    public function updateGroupCheckboxes($i)
    {
        $this->groupCheckboxes[$i] = !$this->checkboxes[$i];
    }

    #[On('home')]
    public function home()
    {
        sleep(2.5);
        return $this->redirect('/dashboard');
    }
}
