<?php

namespace App\Livewire\Promo;

use App\Models\PromoItemQtyTemp;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoAddItemQty extends Component
{
    public $tipe;
    public $item_code;

    public function mount($tipe, $item_code)
    {
        $this->tipe = $tipe;
        $this->item_code = $item_code;
    }

    public function render()
    {
        $items = [];
        try {


            $items = PromoItemQtyTemp::where('company_code', session('company_code'))
                ->where('id_user', session('userId'))
                ->where('item_code', $this->item_code)
                ->where('tipe', $this->tipe)
                ->orderBy('qty')
                ->get();
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        return view('livewire.promo.promo-add-item-qty', compact('items'));
    }

    #[On('refreshQty')]
    public function refreshQty()
    {
    }

    public function remove($item_code, $qty)
    {
        try {


            DB::table('Luv2_promo_item_qty_temp')
                ->where('company_code', session('company_code'))
                ->where('id_user', session('userId'))
                ->where('item_code', $item_code)
                ->where('qty', $qty)
                ->where('tipe', $this->tipe)
                ->delete();
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
}
