<?php

namespace App\Livewire\Promo;

use App\Models\PromoBundlingQtyTemp;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoAddBundlingQty extends Component
{
    public function render()
    {
        $items = [];
        try {


            $items = PromoBundlingQtyTemp::where('company_code', session('company_code'))
                ->where('id_user', session('userId'))
                ->orderBy('qty')
                ->get();
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        return view('livewire.promo.promo-add-bundling-qty', compact('items'));
    }

    #[On('refreshQty')]
    public function refreshQty()
    {
    }

    public function remove($qty)
    {
        try {


            DB::table('Luv2_promo_bundling_qty_temp')
                ->where('company_code', session('company_code'))
                ->where('id_user', session('userId'))
                ->where('qty', $qty)
                ->delete();
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
}
