<?php

namespace App\Livewire\Pos\PurchaseReturn;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use LivewireAlert, WithPagination;

    protected $paginationTheme = 'bootstrap';
    public $noGR = '';
    public $search = '';
    public $sortField = 'date';
    public $sortDirection = 'desc';
    public $perPage = 10;

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function render()
    {
        $user = Auth::user();
        $gr = DB::table('Luv2_return')
            ->select(
                'Luv2_return.no',
                'Luv2_return.date',
                'Luv2_return.qty',
                'Luv2_return.total',
                'Luv2_return.remark',
                'Luv2_return.created_at',
                'Luv2_supplier.name',
                'Luv2_warehouse.name as whs_name'
            )
            ->leftJoin('Luv2_supplier', function($join) {
                $join->on('Luv2_return.supp_code', '=', 'Luv2_supplier.code')
                    ->where('Luv2_supplier.company_code', '=', auth()->user()->company_code);
            })
            ->leftJoin('Luv2_warehouse', function($join) {
                $join->on('Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
                    ->where('Luv2_warehouse.company_code', '=', auth()->user()->company_code);
            })
            ->when(auth()->user()->role !== 'Admin', function ($query) use ($user) {
                return $query->where('Luv2_return.whs_code', $user->whs_code);
            })
            ->where('Luv2_return.company_code', auth()->user()->company_code)
            ->where('Luv2_return.deleted', '<>', 'Y')
            ->when($this->search, function($query) {
                $query->where(function($q) {
                    $q->where('Luv2_return.no', 'like', '%' . $this->search . '%')
                      ->orWhere('Luv2_supplier.name', 'like', '%' . $this->search . '%')
                      ->orWhere('Luv2_warehouse.name', 'like', '%' . $this->search . '%')
                      ->orWhere('Luv2_return.remark', 'like', '%' . $this->search . '%');
                });
            })
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);

        $totalQty = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->where('Luv2_return.company_code', auth()->user()->company_code)
            ->where('Luv2_return.deleted', '<>', 'Y')
            ->when(auth()->user()->role !== 'Admin', function ($query) use ($user) {
                return $query->where('Luv2_return.whs_code', $user->whs_code);
            })
            ->sum('Luv2_return.qty');

        return view('livewire.pos.purchase-return.index', [
            'purchase' => $gr,
            'totalSumQty' => $totalQty,
        ]);
    }

    #[On('refresh')]
    public function mount()
    {
        Session::forget('NoPO');

        $this->dispatch('refreshDatatable');
    }

    public function toCreatePO()
    {
        $user = Auth::user();
        $huruf = 'GR';
        $tanggal = Carbon::now()->isoFormat('YYMMDDHHmmss');

        $countgr = DB::table('Luv2_receipt')
            ->where('user_code', $user->code)
            ->whereDate('created_at', Carbon::today())
            ->count();
        $countgr += 1;

        $countgr = min($countgr, 999);
        $countgr = str_pad($countgr, 3, '0', STR_PAD_LEFT);
        $no = $huruf . $tanggal . $countgr;
        Session::put('NoPO', $no);
        
        return redirect()->route('pr.create');
    }
    #[On('removeItem')]
    public function toDeleteGR($no)
    {
        $this->noGR = $no;
        $this->dispatch('openModalDel');
    }

    public function deleteGR()
    {
        $updated = DB::table('Luv2_return')
            ->where('no', $this->noGR)
            ->update(['deleted' => 'Y']);

        if ($updated) {
            $this->alert('info', 'Good Return no : ' . $this->noGR . ' successfully deleted', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } else {
            $this->alert('warning', 'Failed to delete Good Return no : ' . $this->noGR, [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        $this->dispatch('closeModalDel');

        $this->dispatch('refresh');

    }
}
