<?php

namespace App\Livewire\Pos\PurchaseOrder;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;

class Create extends Component
{
    public $supplier;
    public $item;
    public $searchsupplier = "";
    public $searchitem = "";
    public $selectedSupplier = null;
    public $selectedCode;
    public $selectedIndex;
    public $selectedItem = null;
    public $selectedCodeItem;
    public $selectedIndexItem;
    public $date;
    public $tableItems = [];

    #[Rule('required', message: 'Please fill the remarks.')]
    public $remarks = '';
    // #[Rule('required', message: 'Please fill the No.')]
    // public $dynamicNoPoPart = '';
    public $no = '';
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $noPO;


    use LivewireAlert;

    public function render()
    {
        $results = [];
        $resultitem = [];
        $resultwarehouse = [];
        if (strlen($this->searchsupplier) >= 1) {
            $results = DB::table('Luv2_supplier')->where('name', 'ILIKE', '%' . $this->searchsupplier . '%')->limit(10)
                ->where('company_code', auth()->user()->company_code)
                // ->where('whs_code', auth()->user()->whs_code)
                ->get();
            $this->supplier = $results;
        }
        if (strlen($this->searchitem) >= 1) {
            $resultitem = DB::table('Luv2_item')
                ->where('company_code', auth()->user()->company_code)
                ->where(function ($query) {
                    $query->where('name', 'ILIKE', '%' . $this->searchitem . '%')
                        ->orWhere('code', 'ILIKE', '%' . $this->searchitem . '%')
                        ->orWhere('barcode', 'ILIKE', '%' . $this->searchitem . '%');
                })
                ->where(function ($query) {
                    $query->whereNull('supp_code')
                        ->orWhere('supp_code', '')
                        ->orWhere('supp_code', $this->selectedSupplier->code);
                })
                ->limit(10)
                ->get();
            $this->item = $resultitem;
        }

        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')
                ->where('company_code', auth()->user()->company_code)
                ->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }
        return view('livewire.pos.purchase-order.create', [
            'results' => $results,
            'resultitem' => $resultitem,
            'resultwarehouse' => $resultwarehouse,
        ]);
    }

    public function mount()
    {
        $user = Auth::user();
        if ($user->whs_code != '-') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)->first();
            $this->selectedWarehouse = $warehouse;
            $this->searchwarehouse = $warehouse->name;
        }
        $this->no = Session::get('NoPO');
        $this->noPO = 'PR/' . $this->no . '/';
        $this->date = Carbon::now()->format('Y-m-d');
    }


    // public function getNoPOProperty()
    // {
    //     return 'PR/' . $this->no . '/' . $this->dynamicNoPoPart;
    // }

    public function selectSupplier($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->supplier[$index]->code;

        $supplier = DB::table('Luv2_supplier')->where('code', $this->selectedCode)
            ->where('company_code', auth()->user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->selectedCode = null;
            $this->selectedIndex = null;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }

    public function selectSupplierByClick($supplierCode)
    {

        $supplier = DB::table('Luv2_supplier')->where('code', $supplierCode)
            ->where('company_code', auth()->user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->first();

        if ($supplier) {

            $this->searchsupplier = $supplier->name;
            $this->selectedSupplier = $supplier;

            $this->alert('info', 'Supplier: ' . $supplier->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }


    public function updatedSearchsupplier()
    {
        $this->selectedSupplier = null;
    }

    public function selectItem($index)
    {
        $this->selectedIndexItem = $index;
        $this->selectedCodeItem = $this->item[$index]->code;

        $item = DB::table('Luv2_item')->where('code', $this->selectedCodeItem)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($item) {
            $this->searchitem = $item->name;
            $this->selectedItem = $item;
            $itemArray = (array) $item;
            $data = DB::table('Luv2_item_unit as iuu')
                ->where('iuu.company_code', auth()->user()->company_code)
                ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                ->where('iuu.item_code', $item->code)
                ->get();
            $itemArray['qtypcs'] = 1;
            $itemArray['unit'] = 0;
            $itemArray['units'] = $data;
            $itemArray['unitforselect'] = $data->first()->id ?? null;
            $itemArray['unitnameforselect'] = $data->first()->name ?? null;
            $itemArray['consignment'] = $item->consignment;

            // Initialize a flag to check if the item already exists in the tableItems
            $itemExists = false;

            // Check if the item already exists in the tableItems
            foreach ($this->tableItems as &$tableItem) {
                if ($tableItem['code'] === $itemArray['code']) {
                    // If item exists, increment the quantity
                    $tableItem['quantity'] += 1;
                    // Update qtypcs based on unit
                    if ($tableItem['unit'] != 0) {
                        $unitItem = DB::table('Luv2_item_unit')
                            ->where('item_code', $tableItem['code'])
                            ->where('company_code', auth()->user()->company_code)
                            ->where('id_unit', $tableItem['unit'])
                            ->first();
                        if ($unitItem) {
                            $tableItem['qtypcs'] = $tableItem['quantity'] * $unitItem->qty;
                        }
                    } else {
                        $tableItem['qtypcs'] = $tableItem['quantity'];
                    }
                    $itemExists = true;
                    break;
                }
            }

            // If the item does not exist in the tableItems, add it with a default quantity of 1
            if (!$itemExists) {
                $itemArray['quantity'] = 1;
                $itemArray['price'] = 0;
                $itemArray['qtypcs'] = 1; // Will be updated by updatedTableItems when unit changes

                $this->tableItems[] = $itemArray;
            }

            $this->searchitem = '';

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('refreshDatatable');
        }
    }

    public function selectItemByName()
    {
        if (strlen($this->searchitem) >= 1) {
            if (!$this->selectedItem) {
                $item = DB::table('Luv2_item')->where('barcode', $this->searchitem)
                    ->where('company_code', auth()->user()->company_code)
                    ->first();
                if ($item) {
                    $this->searchitem = $item->name;
                    $this->selectedItem = $item;
                    $itemArray = (array) $item;
                    $data = DB::table('Luv2_item_unit as iuu')
                        ->where('iuu.company_code', auth()->user()->company_code)
                        ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                        ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                        ->where('iuu.item_code', $item->code)
                        ->get();
                    $itemArray['qtypcs'] = 1;
                    $itemArray['unit'] = 0;
                    $itemArray['units'] = $data;
                    $itemArray['unitforselect'] = $data->first()->id ?? null;
                    $itemArray['unitnameforselect'] = $data->first()->name ?? null;
                    $itemArray['consignment'] = $item->consignment;

                    // Initialize a flag to check if the item already exists in the tableItems
                    $itemExists = false;

                    // Check if the item already exists in the tableItems
                    foreach ($this->tableItems as &$tableItem) {
                        if ($tableItem['code'] === $itemArray['code']) {
                            // If item exists, increment the quantity
                            $tableItem['quantity'] += 1;
                            // Update qtypcs based on unit
                            if ($tableItem['unit'] != 0) {
                                $unitItem = DB::table('Luv2_item_unit')
                                    ->where('item_code', $tableItem['code'])
                                    ->where('company_code', auth()->user()->company_code)
                                    ->where('id_unit', $tableItem['unit'])
                                    ->first();
                                if ($unitItem) {
                                    $tableItem['qtypcs'] = $tableItem['quantity'] * $unitItem->qty;
                                }
                            } else {
                                $tableItem['qtypcs'] = $tableItem['quantity'];
                            }
                            $itemExists = true;
                            break;
                        }
                    }

                    // If the item does not exist in the tableItems, add it with a default quantity of 1
                    if (!$itemExists) {
                        $itemArray['quantity'] = 1;
                        $itemArray['price'] = 0;
                        $itemArray['qtypcs'] = 1; // Will be updated by updatedTableItems when unit changes

                        $this->tableItems[] = $itemArray;
                    }

                    $this->searchitem = '';

                    $this->alert('info', 'Item: ' . $item->name, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);

                    $this->dispatch('refreshDatatable');
                } else {
                    $this->alert('info', 'Barcode is incorrect !', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            }
        } else {
            $this->alert('info', 'Barcode is empty !', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }


    public function selectItemByClick($itemCode)
    {
        $item = DB::table('Luv2_item')->where('code', $itemCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($item) {
            $this->searchitem = $item->name;
            $this->selectedItem = $item;
            $itemArray = (array) $item;
            $data = DB::table('Luv2_item_unit as iuu')
                ->where('iuu.company_code', auth()->user()->company_code)
                ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                ->where('iuu.item_code', $item->code)
                ->get();
            $itemArray['qtypcs'] = 1;
            $itemArray['unit'] = 0;
            $itemArray['units'] = $data;
            $itemArray['unitforselect'] = $data->first()->id ?? null;
            $itemArray['unitnameforselect'] = $data->first()->name ?? null;
            $itemArray['consignment'] = $item->consignment;

            // Initialize a flag to check if the item already exists in the tableItems
            $itemExists = false;

            // Check if the item already exists in the tableItems
            foreach ($this->tableItems as &$tableItem) {
                if ($tableItem['code'] === $itemArray['code']) {
                    // If item exists, increment the quantity
                    $tableItem['quantity'] += 1;
                    // Update qtypcs based on unit
                    if ($tableItem['unit'] != 0) {
                        $unitItem = DB::table('Luv2_item_unit')
                            ->where('item_code', $tableItem['code'])
                            ->where('company_code', auth()->user()->company_code)
                            ->where('id_unit', $tableItem['unit'])
                            ->first();
                        if ($unitItem) {
                            $tableItem['qtypcs'] = $tableItem['quantity'] * $unitItem->qty;
                        }
                    } else {
                        $tableItem['qtypcs'] = $tableItem['quantity'];
                    }
                    $itemExists = true;
                    break;
                }
            }

            // If the item does not exist in the tableItems, add it with a default quantity of 1
            if (!$itemExists) {
                $itemArray['quantity'] = 1;
                $itemArray['price'] = 0;
                $itemArray['qtypcs'] = 1; // Will be updated by updatedTableItems when unit changes

                $this->tableItems[] = $itemArray;
            }

            $this->searchitem = '';

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('refreshDatatable');
        }
    }


    #[On('removeItem')]
    public function removeItem($index)
    {
        if (isset($this->tableItems[$index])) {
            unset($this->tableItems[$index]);
            $this->tableItems = array_values($this->tableItems);
            $this->alert('info', 'Item removed successfully.', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }
    public function updatedTableItems($value, $key)
    {
        $parts = explode('.', $key);
        $index = $parts[0];
        $field = $parts[1];
        $code = $this->tableItems[$index]['code']; // Assuming you have 'code' in tableItems
        $unitItem = DB::table('Luv2_item_unit')
        ->where('item_code', $code)
        ->where('company_code', auth()->user()->company_code)
        ->where('id_unit', $value)->first();
        if ($this->tableItems[$index]['unit'] != 0 && $unitItem) {
            $this->tableItems[$index]['qtypcs'] = $this->tableItems[$index]['quantity'] * $unitItem->qty;
        } else {
            // $this->tableItems[$index]['quantity'] = $this->tableItems[$index]['qtypcs'];
            $this->tableItems[$index]['qtypcs'] = $this->tableItems[$index]['quantity'];
        }
    }


    public function updatedSearchitem()
    {
        $this->selectedItem = null;
    }

    public function savetoTable()
    {
        $this->validate();
        if ($this->selectedWarehouse) {
            $user = Auth::user();
            //Code Generate No
            // $huruf = 'GR';
            // $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

            // $countgr = DB::table('Luv2_receipt')
            //     ->where('user_code', $user->code)
            //     ->whereDate('created_at', Carbon::today())
            //     ->count();
            // $countgr += 1;

            // $countgr = min($countgr, 999);
            // $countgr = str_pad($countgr, 3, '0', STR_PAD_LEFT);
            // $no = $huruf . $tanggal . $countgr;
            // $this->no = $no;
            $lineNum = 1;

            $insertdetail = collect($this->tableItems)->map(function ($item) use (&$lineNum) {
                $user = Auth::user();
                return [
                    'company_code' => $user->company_code,
                    'no' => $this->no,
                    'item_code' => $item['code'],
                    'qty' => $item['qtypcs'],
                    'price' => $item['price'],
                    'disc' => 0,
                    'qty_unit' => $item['quantity'],
                    'unit' => $item['unit'],
                    'total' => $item['qtypcs'] * $item['price'],
                    'linenum' => $lineNum++,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            })->toArray();
            $toAvg = collect($this->tableItems)->map(function ($item) use (&$lineNum) {
                $user = Auth::user();
                return [
                    'company_code' => $user->company_code,
                    'no' => $this->no,
                    'item_code' => $item['code'],
                    'qty' => $item['qtypcs'],
                    'qty_unit' => $item['quantity'],
                    'unit' => $item['unit'],
                    'price' => $item['price'],
                    'avgprice' => $item['avgprice'],
                    'disc' => 0,
                    'total' => $item['qtypcs'] * $item['price'],
                    'linenum' => $lineNum++,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            })->toArray();
            $totalSum = collect($insertdetail)->sum('total');
            $qtySum = collect($insertdetail)->sum('qty');
            $insertheader =
                [
                    'company_code' => $user->company_code,
                    'no' => $this->no,
                    'date' => $this->date,
                    'whs_code' => $this->selectedWarehouse->code,
                    'supp_code' => $this->supplier[0]->code,
                    'remark' => $this->remarks,
                    'qty' => $qtySum,
                    'total' => $totalSum,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'user_code' => $user->code,
                ];

            DB::beginTransaction();

            try {
                DB::table('Luv2_receipt')->insert($insertheader);

                DB::table('Luv2_receipt_detail')->insert($insertdetail);

                DB::commit();

                $this->alert('info', 'Purchase and details stored successfully.', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);

                $this->dispatch('insertAverage', $toAvg);
            } catch (\Exception $e) {
                DB::rollBack();

                $this->alert('info', 'Failed to store purchase and details: ' . $e->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->alert('warning', 'Please select warehouse ! ', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function clearAftersave()
    {

        $this->selectedSupplier = null;
        $this->item = '';
        $this->tableItems = [];
        $this->remarks = '';
        $this->no = '';
        $this->searchsupplier = '';
        $this->searchwarehouse = '';
        $this->selectedWarehouse = null;
    }

    #[On('insertAverage')]
    public function createAverage($toAvg)
    {
        foreach ($toAvg as $avg) {
            // Get current stock and transactions
            $trans = DB::table('Luv2_item_trans')
                ->where('company_code', $avg['company_code'])
                ->where('item_code', $avg['item_code'])
                ->where('no_trans', '!=', $this->no)
                ->get();
            $sisaStok = $trans->sum('qty');
            
            // Handle unit price conversion if needed
            $price = $avg['price'];
            if ($avg['unit'] != 0) {
                $price = $avg['price'] / $avg['qty']; // Convert to per unit price
            }
            
            // Calculate new average price
            $currentValue = $sisaStok * $avg['avgprice']; // Current stock value
            $newValue = $avg['qty'] * $price; // New stock value
            $totalQty = $sisaStok + $avg['qty']; // Total quantity
            
            // Avoid division by zero
            $averageBaru = $totalQty > 0 ? 
                ($currentValue + $newValue) / $totalQty : 
                $price;
                
            $averageBaruRounded = round($averageBaru);
            $priceBuyRounded = round($avg['price']);

            // Update item unit price
            DB::table('Luv2_item_unit')
                ->where('item_code', $avg['item_code'])
                ->where('company_code', auth()->user()->company_code)
                ->update([
                    'pricebuy' => $priceBuyRounded,
                    'updated_at' => now(),
                ]);

            // Update item average price
            DB::table('Luv2_item')
                ->where('company_code', auth()->user()->company_code)
                ->where('code', $avg['item_code'])
                ->update([
                    'avgprice' => $averageBaruRounded,
                ]);
        }
        $this->clearAfterSave();
        $this->dispatch('redirectTo');
    }

    #[On('redirectTo')]
    public function redirectTo()
    {
        sleep(2);
        return redirect()->route('po.index');
    }

    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
    }
}
