<?php

namespace App\Livewire\Pos\Opname;

use App\Exports\SOExport;
use App\Models\Opname;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class DetailOpname extends Component
{
    public $opnames;
    public $opnameh;
    public $no;


    public function mount($no)
    {
        $this->no = $no;
        $this->opnames = DB::table('Luv2_opname_detail')
            ->where('no', $no)
            ->orderBy('item_code')
            ->get();

        $this->opnameh = 
        DB::table('Luv2_opname')
        ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
        ->where('no', $no)
        ->where('Luv2_opname.company_code', auth()->user()->company_code)
        ->where('Luv2_opname.user_code', Auth::user()->code)
        ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
        ->first();
        

        $this->dispatch('refreshDatatable');
    }


    #[On('refreshJs')]
    public function refreshJs()
    {
        $this->dispatch('refreshDatatable');
    }

    public function export()
    {
        $opnames =
            DB::table('Luv2_opname_detail')
            ->where('company_code', auth()->user()->company_code)
            ->where('no', $this->no)
            ->where('difference', '>', 0)
            ->orderBy('item_code')
            ->get();


        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $filename = "SO Report Difference - {$now}.xlsx";
        return Excel::download(new SOExport($opnames), $filename);
    }

    public function exportNoDiff()
    {
        $opnames =
            DB::table('Luv2_opname_detail')
            ->where('no', $this->no)
            ->where('company_code', auth()->user()->company_code)
            ->where('difference', '=', 0)
            ->orderBy('item_code')
            ->get();

        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $filename = "SO Report - {$now}.xlsx";
        return Excel::download(new SOExport($opnames), $filename);
    }
    public function close()
    {
        return $this->redirect('/opname');
    }


    public function render()
    {
        return view('livewire.pos.opname.detail-opname');
    }
}
