<?php

namespace App\Livewire\Pos\Moh;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Jantinnerezo\LivewireAlert\LivewireAlert;

class SettingMoh extends Component
{
    public $code;
    public $name;
    public $moh;
    public $min_display;
    public $warehouse_code;

    use LivewireAlert;

    public function mount($code = null)
    {
        $this->warehouse_code = $code;

        $warehouse = DB::table('Luv2_warehouse')
            ->where('code', $this->warehouse_code)
            ->where('company_code', Auth::user()->company_code)
            ->first();

        if ($warehouse) {
            $this->code = $warehouse->code;
            $this->name = $warehouse->name;
            $this->moh = $warehouse->moh;
            $this->min_display = $warehouse->mdq;
        } else {
            return redirect()->route('setting-moh-list');
        }
    }

    public function updateSettings()
    {
        $this->validate([
            'moh' => 'required|numeric|min:0',
            'min_display' => 'required|numeric|min:0',
        ]);

        try {
            DB::table('Luv2_warehouse')
                ->where('code', $this->warehouse_code)
                ->where('company_code', Auth::user()->company_code)
                ->update([
                    'moh' => $this->moh,
                    'mdq' => $this->min_display,
                ]);

            $this->alert('success', 'Setting MOH berhasil diubah', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,

            ]);
        } catch (\Exception $e) {
            $this->alert('error', 'Gagal mengubah setting MOH', [
                'position' => 'top-end',
                'timer' => 1000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function render()
    {
        return view('livewire.pos.moh.setting-moh');
    }
}
