<?php

namespace App\Livewire\Pos\Moh;

use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;

class AddMohUDF extends Component
{
    use LivewireAlert;

    public $code;
    public $company_code;

    public function mount()
    {
        $this->company_code = auth()->user()->company_code;
    }

    public function addMohUDF()
    {
        return redirect()->route('create-moh-udf');
    }

    #[On('delete')]
    public function delete($code)
    {
        try {
            DB::table('Luv2_udf_moh')
                ->where('code', $code)
                ->where('company_code', $this->company_code)
                ->delete();

            $this->alert('success', 'MOH UDF deleted successfully.');

            $this->dispatch('home');
        } catch (\Exception $e) {
            $this->alert('error', 'Failed to delete MOH UDF.');
        }
    }

    #[On('home')]
    public function home()
    {
        sleep(2.5);
        return $this->redirect('/setting-moh-udf');
    }

    #[On('edit')]
    public function edit($code)
    {
        return redirect()->route('create-moh-udf', ['code' => $code]);
    }

    public function render()
    {
        $mohData = DB::table('Luv2_udf_moh')
            ->leftJoin('Luv2_category', function ($join) {
                $join->on('Luv2_udf_moh.category_code', '=', 'Luv2_category.code')
                    ->on('Luv2_udf_moh.company_code', '=', 'Luv2_category.company_code');
            })
            ->leftJoin('Luv2_warehouse', function ($join) {
                $join->on('Luv2_udf_moh.whs_code', '=', 'Luv2_warehouse.code')
                    ->on('Luv2_udf_moh.company_code', '=', 'Luv2_warehouse.company_code');
            })
            ->leftJoin('Luv2_brand', function ($join) {
                $join->on('Luv2_udf_moh.brand_code', '=', 'Luv2_brand.code')
                    ->on('Luv2_udf_moh.company_code', '=', 'Luv2_brand.company_code');
            })
            ->leftJoin('Luv2_size', function ($join) {
                $join->on('Luv2_udf_moh.size_code', '=', 'Luv2_size.code')
                    ->on('Luv2_udf_moh.company_code', '=', 'Luv2_size.company_code');
            })
            ->select(
                'Luv2_udf_moh.company_code',
                'Luv2_udf_moh.code',
                'Luv2_udf_moh.brand_code',
                'Luv2_brand.name as brand_name',
                'Luv2_udf_moh.category_code',
                'Luv2_category.name as category_name',
                'Luv2_udf_moh.size_code',
                'Luv2_size.name as size_name',
                'Luv2_udf_moh.moh',
                'Luv2_udf_moh.mdq',
                'Luv2_warehouse.name as warehouse_name',
                'Luv2_warehouse.code as warehouse_code'
            )
            ->where('Luv2_udf_moh.company_code', $this->company_code)
            ->orderBy('Luv2_udf_moh.whs_code', 'asc')
            ->orderBy('Luv2_udf_moh.brand_code', 'asc')
            ->orderBy('Luv2_udf_moh.category_code', 'asc')
            ->orderBy('Luv2_udf_moh.size_code', 'asc')
            ->get();

        return view('livewire.pos.moh.add-moh-u-d-f', [
            'mohData' => $mohData
        ]);
    }

    #[On('aaa')]
    public function deleteModal($code)
    {

        $this->code = $code;
        $this->dispatch("deleteModal");
    }
}
