<?php

namespace App\Livewire\Pos\ItemTransfer;

use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use LivewireAlert;
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    
    public $totalSumQty;
    public $selectedOption = 'In';
    public $whs_code;
    public $warehouse;
    public $sortField = 'date';
    public $sortDirection = 'desc';
    public $search = '';
    public $perPage = 10;

    protected $queryString = [
        'search' => ['except' => ''],
        'sortField' => ['except' => 'date'],
        'sortDirection' => ['except' => 'desc'],
        'perPage' => ['except' => 10],
    ];

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function render()
    {
        $user = Auth::user();
        $query = DB::table('Luv2_transfer')
            ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
            ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
            ->where('Luv2_transfer.company_code', $user->company_code)
            ->select(
                'Luv2_transfer.*',
                'whs.name as whs_name',
                'to_whs.name as to_whs_name'
            );

        if ($this->selectedOption == 'In') {
            $query->where('Luv2_transfer.whs_code_to', $user->whs_code);
        } else {
            $query->where('Luv2_transfer.whs_code', $user->whs_code);
        }

        if ($this->search) {
            $query->where(function($q) {
                $q->where('Luv2_transfer.no', 'like', '%' . $this->search . '%')
                  ->orWhere('whs.name', 'like', '%' . $this->search . '%')
                  ->orWhere('to_whs.name', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_transfer.remark', 'like', '%' . $this->search . '%');
            });
        }

        $query->orderBy($this->sortField, $this->sortDirection);

        $itemtransfer = $query->paginate($this->perPage);
        $this->totalSumQty = $query->sum('qty_close');
        $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();

        // $this->check = $itemtransfer;
        return view('livewire.pos.item-transfer.index', [
            'itemtransfer' => $itemtransfer
        ]);
    }

    #[On('updated')]
    public function mount()
    {
        $user = Auth::user();
        // if ($user->role == 'Admin') {
        //     $it = DB::table('Luv2_transfer')
        //         ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
        //         ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
        //         ->where('Luv2_transfer.company_code', $user->company_code)
        //         ->select(
        //             'Luv2_transfer.*',
        //             'whs.name as whs_name',
        //             'to_whs.name as to_whs_name'
        //         )
        //         ->get();

        //     $totalQty = $it->sum('qty');
        // } else {
            $it = DB::table('Luv2_transfer')
                ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
                ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
                ->where('Luv2_transfer.company_code', $user->company_code)
                ->where('Luv2_transfer.whs_code_to', $user->whs_code)
                ->select(
                    'Luv2_transfer.*',
                    'whs.name as whs_name',
                    'to_whs.name as to_whs_name'
                )
                ->get();

            $totalQty = $it->sum('qty_close');
        // }
        $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
        $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->where('whs_central', 'Y')->first();
        if($warehouse){
            $this->whs_code = $warehouse->code;
        }else{
            $this->whs_code = $user->whs_code;
        }
        $this->totalSumQty = $totalQty;

        session()->forget('CreateIT' . Auth::user()->code);
    }


    public function updatedSelectedOption()
    {
        $user = Auth::user();
        if ($this->selectedOption == 'In') {
            $it = DB::table('Luv2_transfer')
                ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
                ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
                ->where('Luv2_transfer.company_code', $user->company_code)
                ->where('Luv2_transfer.whs_code_to', $user->whs_code)
                ->select(
                    'Luv2_transfer.*',
                    'whs.name as whs_name',
                    'to_whs.name as to_whs_name'
                )
                ->get();
            $totalQty = $it->sum('qty_close');
        } else {
            $it = DB::table('Luv2_transfer')
                ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
                ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
                ->where('Luv2_transfer.company_code', $user->company_code)
                ->where('Luv2_transfer.whs_code', $user->whs_code)
                ->select(
                    'Luv2_transfer.*',
                    'whs.name as whs_name',
                    'to_whs.name as to_whs_name'
                )
                ->get();

            $totalQty = $it->sum('qty_close');
        }
        $this->totalSumQty = $totalQty;

        $this->dispatch('refreshDatatable');
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;  
        $user->save();
        $this->selectedOption = 'In';
        $this->dispatch('updated');
        $this->dispatch('refreshDatatable');
    }

    public function toCreateITIn()
    {
        session()->put('CreateIT' . Auth::user()->code, 'In');
        return redirect()->route('item-transfer.create');
    }

    public function toCreateITOut()
    {
        session()->put('CreateIT' . Auth::user()->code, 'Out');
        return redirect()->route('item-transfer.create');
    }

    public function toITTrans($no)
    {
        $dataHeader = DB::table('Luv2_transfer')->where('no', $no)->first();
        $data = DB::table('Luv2_transfer_detail')->where('no', $no)->get();

        try {
            DB::table('Luv2_transfer')
                ->where('no', $no)
                ->update([
                    'status' => 1,
                    'whs_code' => $dataHeader->whs_code_to,
                    'whs_code_to' => $dataHeader->whs_code,
                    'qty_open' => $dataHeader->qty_request
                ]);

            $this->dispatch('closeModal', $no);
            $this->alert('success', 'Item Transfer Open Successfully !', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (\Exception $e) {
            if ($e->getCode() == "23505") {
                $this->alert('warning', 'Failed ! There\'s a unique violation', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('warning', 'Failed, please check your data!', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }
}
