<?php

namespace App\Livewire\Pos\ItemTransfer;

use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Detail extends Component
{
    public $details;
    public $no;
    public $id;

    use LivewireAlert;
    
    public function render()
    {
        return view('livewire.pos.item-transfer.detail');
    }

    public function mount($id)
    {
        $this->id = $id;
        $this->details = DB::table('Luv2_transfer_detail as pd')
            ->join('Luv2_transfer as p', 'pd.no', '=', 'p.no')
            ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
            ->select(
                'i.code',
                'i.barcode',
                'i.name',
                'pd.actualqty',
                'pd.qty_request',
                'pd.qty_open',
                'pd.qty_close',

                DB::raw('SUM(pd.qty) as qty')
            )
            ->where('p.no', $id)
            ->groupBy(
                'i.code',
                'i.barcode',
                'i.name',
                'pd.actualqty',
                'pd.qty_request',
                'pd.qty_open',
                'pd.qty_close',

            )
            ->get();


        $this->no = DB::table('Luv2_transfer')
            ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
            ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
            ->where('no', $id)
            ->select(
                'Luv2_transfer.*',
                'whs.name as whs_name',
                'to_whs.name as to_whs_name'
            ) // Select all columns from both tables and the specific columns with aliases
            ->first();
    }

    public function openIT()
    {
        $dataHeader = DB::table('Luv2_transfer')->where('no', $this->id)->first();
        $data = DB::table('Luv2_transfer_detail')->where('no', $this->id)->get();

        try {
            $linenum = 1; // Initialize line number counter

            // $insertData = $data->map(function ($item) use (&$linenum, $dataHeader) {
            //     $user = Auth::user();

            //     return [
            //         'company_code' => $user->company_code,
            //         'whs_code' => $dataHeader->whs_code,
            //         'tipe' => 3,
            //         'no_trans' => $item->no,
            //         'date' => $item->created_at,
            //         'item_code' => $item->item_code,
            //         'linenum' => $linenum++, // Increment line number
            //         'qty' => $item->qty,
            //         'canceled' => $dataHeader->canceled,
            //         'created_at' => Carbon::now(),
            //         'updated_at' => Carbon::now(),
            //     ];
            // })->toArray();

            // // Insert the data into Luv2_item_transfer
            // DB::table('Luv2_item_trans')->insert($insertData);

            // Update the header record to approved
            DB::table('Luv2_transfer')
                ->where('no', $this->id)
                ->update(['status' => 1,
                                    // 'whs_code' => $dataHeader->whs_code_to,
                                    // 'whs_code_to' => $dataHeader->whs_code,
                                    'qty_open' => $dataHeader->qty_request]);
            $this->dispatch('updated');
            $this->alert('success', 'Item Transfer Open Succesfully !', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('locationReload');

        } catch (\Exception $e) {
            if ($e->getCode() == "23505") {
                // Handle unique violation exception
                $this->alert('warning', 'Failed ! Theres a unique violation', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('warning', 'Failed, please check your data!', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }event: 
    }

    #[On('locationReload')]
    public function locationReload()
    {
        sleep(3);
        return redirect(route('item-transfer.detail', $this->id));
    }
}
