<?php

namespace App\Livewire\Pos\ItemTransfer;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;

class Create extends Component
{
    public $ITSess;
    public $item;
    public $searchitem = "";
    public $selectedItem = null;
    public $selectedCodeItem;
    public $selectedIndexItem;
    public $date;
    public $tableItems = [];

    #[Rule('required', message: 'Please fill the remarks.')]
    public $remarks = '';
    public $no = '';
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    public $selectedWarehouseto = null;
    public $selectedCodeWarehouseto;
    public $selectedIndexWarehouseto;
    public $searchwarehouseto;
    public $warehouseto;
    public $isRequest = false;

    use LivewireAlert;


    public function render()
    {
        $results = [];
        $resultitem = [];
        $resultwarehouse = [];
        $resultwarehouseto = [];

        if (strlen($this->searchitem) >= 1) {
            // $resultitem = DB::table('Luv2_item')->where('name', 'ILIKE', '%' . $this->searchitem . '%')->limit(10)
            //     ->where('company_code', auth()->user()->company_code)
            //     ->where('whs_code', auth()->user()->whs_code)
            //     ->get();
            // $this->item = $resultitem;

            if ($this->isRequest) {
                $resultitem = DB::table('Luv2_item as a')
                    ->select('a.*', DB::raw('COALESCE((
                    SELECT SUM(qty)
                    FROM "Luv2_item_trans" as trans
                    WHERE trans.item_code = a.code
                    AND trans.company_code = \'' . auth()->user()->company_code . '\'
                    AND trans.whs_code = \'' . $this->selectedWarehouse->code . '\'
                ), 0) as total_qty'))
                    ->where('a.name', 'ILIKE', '%' . $this->searchitem . '%')
                    ->where('a.company_code', auth()->user()->company_code)
                    ->limit(10)
                    ->get();

                $this->item = $resultitem;
            } else {
                $resultitem = DB::table('Luv2_item')
                    ->where('company_code', auth()->user()->company_code)
                    ->where(function ($query) {
                        $query->where('name', 'ILIKE', '%' . $this->searchitem . '%')
                            ->orWhere('code', 'ILIKE', '%' . $this->searchitem . '%')
                            ->orWhere('barcode', 'ILIKE', '%' . $this->searchitem . '%');
                    })
                    ->limit(10)
                    ->where('company_code', auth()->user()->company_code)
                    // ->where('whs_code', auth()->user()->whs_code)
                    ->get();
                $this->item = $resultitem;
            }
        }
        if (strlen($this->searchwarehouse) >= 1) {
            if ($this->isRequest) {
                $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')->limit(10)
                    ->where('company_code', auth()->user()->company_code)
                    ->where('code', '!=', $this->selectedWarehouseto->code ?? '')
                    ->get();
            } else {
                $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')->limit(10)
                    ->where('company_code', auth()->user()->company_code)
                    ->get();
            }

            $this->warehouse = $resultwarehouse;
        }
        if (strlen($this->searchwarehouseto) >= 1) {
            $resultwarehouseto = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouseto . '%')
                ->where('code', '!=', $this->selectedWarehouse->code ?? '')
                ->limit(10)
                ->where('company_code', auth()->user()->company_code)
                ->get();
            $this->warehouseto = $resultwarehouseto;
        }
        return view('livewire.pos.item-transfer.create', [
            'results' => $results,
            'resultitem' => $resultitem,
            'resultwarehouse' => $resultwarehouse,
            'resultwarehouseto' => $resultwarehouseto,

        ]);
    }

    public function mount()
    {
        $this->ITSess = session()->get('CreateIT' . Auth::user()->code) ?? 'In';

        $user = Auth::user();
        if ($user->role != 'Admin') {
            $warehouse = DB::table('Luv2_warehouse')->where('code', $user->whs_code)->first();
            $this->selectedWarehouse = $warehouse;
            $this->searchwarehouse = $warehouse->name;
        }

        $this->date = Carbon::now()->format('Y-m-d');
    }


    public function selectItem($index)
    {
        $this->selectedIndexItem = $index;
        $this->selectedCodeItem = $this->item[$index]->code;

        $item = DB::table('Luv2_item')->where('code', $this->selectedCodeItem)
            ->where('company_code', auth()->user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->first();

        if ($item) {
            $this->searchitem = $item->name;
            $this->selectedItem = $item;
            $itemArray = (array) $item;
            // $data = DB::table('Luv2_item_unit as iuu')
            // ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
            // ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
            // ->where('iuu.item_code', $item->code)
            // ->first();

            $data = DB::table('Luv2_item_unit as iuu')
                ->where('iuu.company_code', auth()->user()->company_code)
                ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                ->where('iuu.item_code', $item->code)
                ->get();
            $itemArray['qtypcs'] = 1;
            $itemArray['unit'] = 0;
            $itemArray['units'] = $data;
            $itemArray['unitforselect'] = $data->first()->id ?? null;
            $itemArray['unitnameforselect'] = $data->first()->name ?? null;
            $itemExists = false;

            // Check if the item already exists in the tableItems
            foreach ($this->tableItems as &$tableItem) {
                if ($tableItem['code'] === $itemArray['code']) {
                    // If item exists, increment the quantity
                    $tableItem['quantity'] += 1;
                    $itemExists = true;
                    break;
                }
            }

            // If the item does not exist in the tableItems, add it with a default quantity of 1
            if (!$itemExists) {
                $itemArray['quantity'] = 1;
                $this->tableItems[] = $itemArray;
            }

            $this->searchitem = '';

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('refreshDatatable');
        }
    }
    public function selectItemByName()
    {
        if (strlen($this->searchitem) >= 1) {
            if (!$this->selectedItem) {
                $item = DB::table('Luv2_item')->where('barcode', $this->searchitem)
                    ->where('company_code', auth()->user()->company_code)
                    ->first();
                if ($item) {
                    $this->searchitem = $item->name;
                    $this->selectedItem = $item;
                    $itemArray = (array) $item;
                    $data = DB::table('Luv2_item_unit as iuu')
                        ->where('iuu.company_code', auth()->user()->company_code)
                        ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                        ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                        ->where('iuu.item_code', $item->code)
                        ->get();
                    $itemArray['qtypcs'] = 1;
                    $itemArray['unit'] = 0;
                    $itemArray['units'] = $data;
                    $itemArray['unitforselect'] = $data->first()->id ?? null;
                    $itemArray['unitnameforselect'] = $data->first()->name ?? null;
                    // Initialize a flag to check if the item already exists in the tableItems
                    $itemExists = false;

                    // Check if the item already exists in the tableItems
                    foreach ($this->tableItems as &$tableItem) {
                        if ($tableItem['code'] === $itemArray['code']) {
                            // If item exists, increment the quantity
                            $tableItem['quantity'] += 1;
                            $itemExists = true;
                            break;
                        }
                    }

                    // If the item does not exist in the tableItems, add it with a default quantity of 1
                    if (!$itemExists) {
                        $itemArray['quantity'] = 1;
                        $itemArray['price'] = 0;

                        $this->tableItems[] = $itemArray;
                    }

                    $this->searchitem = '';

                    $this->alert('info', 'Item: ' . $item->name, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);

                    $this->dispatch('refreshDatatable');
                } else {
                    $this->alert('info', 'Barcode is incorrect !', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            }
        } else {
            $this->alert('info', 'Barcode is empty !', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function selectItemByClick($itemCode)
    {
        $item = DB::table('Luv2_item')->where('code', $itemCode)
            ->where('company_code', auth()->user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->first();

        if ($item) {
            $this->searchitem = $item->name;
            $this->selectedItem = $item;
            $itemArray = (array) $item;
            $data = DB::table('Luv2_item_unit as iuu')
                ->where('iuu.company_code', auth()->user()->company_code)
                ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                ->where('iuu.item_code', $item->code)
                ->get();
            $itemArray['qtypcs'] = 1;
            $itemArray['unit'] = 0;
            $itemArray['units'] = $data;
            $itemArray['unitforselect'] = $data->first()->id ?? null;
            $itemArray['unitnameforselect'] = $data->first()->name ?? null;
            // Initialize a flag to check if the item already exists in the tableItems
            $itemExists = false;

            // Check if the item already exists in the tableItems
            foreach ($this->tableItems as &$tableItem) {
                if ($tableItem['code'] === $itemArray['code']) {
                    // If item exists, increment the quantity
                    $tableItem['quantity'] += 1;
                    $itemExists = true;
                    break;
                }
            }

            // If the item does not exist in the tableItems, add it with a default quantity of 1
            if (!$itemExists) {
                $itemArray['quantity'] = 1;
                $this->tableItems[] = $itemArray;
            }

            $this->searchitem = '';

            $this->alert('info', 'Item: ' . $item->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('refreshDatatable');
        }
    }

    public function updatedTableItems($value, $key)
    {
        $parts = explode('.', $key);
        $index = $parts[0];
        $field = $parts[1];
        $code = $this->tableItems[$index]['code']; // Assuming you have 'code' in tableItems
        // $unitItem = DB::table('Luv2_item_unit')
        //     ->where('item_code', $code)
        //     ->where('company_code', auth()->user()->company_code)
        //     ->where('whs_code', auth()->user()->whs_code)
        //     ->first();
        $unitItem = DB::table('Luv2_item_unit')
            ->where('item_code', $code)
            ->where('company_code', auth()->user()->company_code)
            ->where('id_unit', $value)->first();

        if ($this->tableItems[$index]['unit'] != 0 && $unitItem) {
            $this->tableItems[$index]['qtypcs'] = $this->tableItems[$index]['quantity'] * $unitItem->qty;
        } else {
            // $this->tableItems[$index]['quantity'] = $this->tableItems[$index]['qtypcs'];
            $this->tableItems[$index]['qtypcs'] = $this->tableItems[$index]['quantity'];
        }
    }


    #[On('removeItem')]
    public function removeItem($index)
    {
        if (isset($this->tableItems[$index])) {
            unset($this->tableItems[$index]);
            $this->tableItems = array_values($this->tableItems);
            $this->alert('info', 'Item removed successfully.', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function updatedSearchitem()
    {
        // dd($this->item);
        $this->selectedItem = null;
    }


    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
            $this->dispatch('activeF4');
        }
    }


    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
    }

    public function selectWarehouseto($index)
    {
        $this->selectedIndexWarehouseto = $index;
        $this->selectedCodeWarehouseto = $this->warehouseto[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouseto)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouseto = $warehouse->name;
            $this->selectedWarehouseto = $warehouse;

            $this->selectedCodeWarehouseto = null;
            $this->selectedIndexWarehouseto = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function selectWarehousetoByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouseto = $warehouse->name;
            $this->selectedWarehouseto = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }


    public function updatedSearchwarehouseto()
    {
        $this->selectedWarehouseto = null;
    }

    public function updatedIsRequest()
    {
        $this->isRequest != $this->isRequest;
        $this->searchitem = '';
        if ($this->isRequest) {
            $this->selectedWarehouse = '';
            $this->searchwarehouse = '';
            if (auth()->user()->role != 'Admin') {
                $warehouse = DB::table('Luv2_warehouse')->where('code', auth()->user()->whs_code)->first();
                $this->selectedWarehouseto = $warehouse;
                $this->searchwarehouseto = $warehouse->name;
            }
        } else {
            $this->selectedWarehouseto = '';
            $this->searchwarehouseto = '';
            if (auth()->user()->role != 'Admin') {
                $warehouse = DB::table('Luv2_warehouse')->where('code', auth()->user()->whs_code)->first();
                $this->selectedWarehouse = $warehouse;
                $this->searchwarehouse = $warehouse->name;
            }
        }
    }

    public function savetoTable()
    {
        $this->validate();
        if ($this->selectedWarehouseto) {
            $user = Auth::user();
            //Code Generate No
            $huruf = 'IT';
            $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

            $countgr = DB::table('Luv2_return')
                ->where('user_code', $user->code)
                ->whereDate('created_at', Carbon::today())
                ->count();
            $countgr += 1;

            $countgr = min($countgr, 999);
            $countgr = str_pad($countgr, 3, '0', STR_PAD_LEFT);
            $no = $huruf . $tanggal . $countgr;
            $this->no = $no;

            $insertdetail = collect($this->tableItems)->map(function ($item) {
                $user = Auth::user();
                $quantity = $item['qtypcs'];

                $lineNum = 1;

                return [
                    'company_code' => $user->company_code,
                    'no' => $this->no,
                    'item_code' => $item['code'],
                    'qty' => $quantity,
                    'actualqty' => $quantity,
                    'price' => $item['price'],
                    'qty_unit' => $item['quantity'],
                    'unit' => $item['unit'],
                    'total' => $quantity * $item['price'],
                    'linenum' => $lineNum++,
                    $this->isRequest ? 'qty_request' : 'qty_open' => $quantity,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            })->toArray();

            $totalSum = collect($insertdetail)->sum('total');
            $qtySum = collect($insertdetail)->sum('qty');
            if ($this->isRequest) {
                $status = 5;
                $qtyRequest = $qtySum;
                $qtyOpen = 0;
            } else {
                $status = 1;
                $qtyOpen = $qtySum;
                $qtyRequest = 0;
            }

            // dd($status);

            $insertheader =
                [
                    'company_code' => $user->company_code,
                    'no' => $this->no,
                    'date' => $this->date,
                    'whs_code' => $this->selectedWarehouse->code,
                    'whs_code_to' => $this->selectedWarehouseto->code,
                    'remark' => $this->remarks,
                    'qty' => $qtySum,
                    'qty_request' => $qtyRequest,
                    'qty_open' => $qtyOpen,
                    'total' => $totalSum,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'user_code' => $user->code,
                    'status' => $status,
                ];

            DB::beginTransaction();

            try {
                // Insert into Luv2_transfer
                DB::table('Luv2_transfer')->insert($insertheader);

                // Insert into Luv2_transfer_detail
                DB::table('Luv2_transfer_detail')->insert($insertdetail);

                // Commit the transaction
                DB::commit();

                $this->alert('info', 'Item Transfer and details stored successfully.', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);

                $this->clearAfterSave();
            } catch (\Exception $e) {
                // Rollback the transaction if any operation fails
                DB::rollBack();

                $this->alert('info', 'Failed to store item transfer and details: ' . $e->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->alert('warning', 'Please select warehouse ! ', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function clearAftersave()
    {

        $this->item = '';
        $this->tableItems = [];
        $this->remarks = '';
        $this->no = '';
        $this->searchwarehouse = '';
        $this->selectedWarehouse = null;
        $this->searchwarehouseto = '';
        $this->selectedWarehouseto = null;
    }
}
