<?php

namespace App\Livewire\Pos\Item;

use App\Models\ItemTemp;
use App\Models\ItemTransTemp;
use App\Models\Settings;
use App\Models\Warehouse;
use App\Traits\GetItemTraits;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class ItemIndex extends Component
{
    use LivewireAlert;
    use GetItemTraits;

    public $isloadingitem = false;
    public $isloadingtrans = false;
    public $isloadingsearch = false;
    public $isloadingpromo = false;

    public $isFilter = false;
    public $inputfilter;
    public $type = 'Barcode';
    public $item;
    public $whs_code;
    public $warehouse = '';

    protected function isConnectionResetError($e)
    {
        return $e instanceof \GuzzleHttp\Exception\RequestException &&
            (
                strpos($e->getMessage(), 'cURL error 56: Recv failure: Connection was reset') !== false ||
                strpos($e->getMessage(), 'cURL error 28: Connection timed out') !== false ||
                strpos($e->getMessage(), 'cURL error 7: Failed to connect') !== false
            );
    }

    protected function reDoFunction($function, $args = [])
    {
        call_user_func_array([$this, $function], $args);
    }

    public function render()
    {
        return view('livewire.pos.item.item-index');
    }

    public function mount()
    {

        if (auth()->user()->role == 'Admin') {
            $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
            $this->whs_code = Auth::user()->whs_code;
        }
    }

    public function updatedType()
    {
        $this->isFilter = false;
    }


    public function updatedinputfilter()
    {
        $this->isFilter = false;
    }

    public function firstClick()
    {
        $this->isloadingsearch = true;
        $this->dispatch('toFilter');
    }

    #[On('toFilter')]
    public function filterItem()
    {
        ini_set('max_execution_time', '1000');
        $user = Auth::user();
        if ($user->whs_code == '-') {
            $wh = Warehouse::where('company_code', $user->company_code)->first();
        } else {
            $wh = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        }
        $pricelist_code = $wh->pricelist_code;

        $columnToFilter = match ($this->type) {
            'Barcode' => 'a.barcode',
            'Code' => 'a.code',
            'Name' => 'a.name',
            default => null,
        };

        // $query = DB::table('Luv2_item as a')
        //     ->select([
        //         'a.code',
        //         'a.barcode',
        //         'a.name',
        //         'a.avgprice',
        //         'u.name as unit_name',
        //         DB::raw('COALESCE((
        //         SELECT COALESCE(b.price, 0)
        //         FROM "Luv2_item_pricelist" b
        //         WHERE a.code = b.item_code
        //         AND b.pricelist_code = \'' . $pricelist_code . '\'
        //         AND b.company_code = \'' . $user->company_code . '\'
        //         LIMIT 1
        //     ), 0) AS price'),
        //         DB::raw('COALESCE((
        //         SELECT SUM(qty)
        //         FROM "Luv2_item_trans"
        //         WHERE item_code = a.code
        //         AND company_code = \'' . $user->company_code . '\'
        //         AND whs_code = \'' . $user->whs_code . '\'
        //     ), 0) AS trans_qty'),
        //         DB::raw('COALESCE((
        //         SELECT COALESCE(SUM(ui.qty), 0)
        //         FROM "Luv2_item_unit" ui
        //         JOIN "Luv2_unit" u ON ui.id_unit = u.id
        //         WHERE a.code = ui.item_code
        //         AND ui.company_code = \'' . $user->company_code . '\'
        //         AND ui.whs_code = \'' . $user->whs_code . '\'
        //         GROUP BY u.name
        //     ), 0) AS item_unit_qty'),
        //         DB::raw('COALESCE((
        //         SELECT ui.pricebuy
        //         FROM "Luv2_item_unit" ui
        //         WHERE a.code = ui.item_code
        //         AND ui.company_code = \'' . $user->company_code . '\'
        //         AND ui.whs_code = \'' . $user->whs_code . '\'
        //         LIMIT 1
        //     ), 0) AS pricebuy'),
        //         DB::raw('COALESCE((
        //         SELECT ui.pricesell
        //         FROM "Luv2_item_unit" ui
        //         WHERE a.code = ui.item_code
        //         AND ui.company_code = \'' . $user->company_code . '\'
        //         AND ui.whs_code = \'' . $user->whs_code . '\'
        //         LIMIT 1
        //     ), 0) AS pricesell')
        //     ])
        //     ->leftJoin('Luv2_item_unit as iu', function ($join) use ($user, $wh) {
        //         $join->on('a.code', '=', 'iu.item_code')
        //             ->where('iu.company_code', $user->company_code)
        //             ->where('iu.whs_code', $user->whs_code);
        //     })
        //     ->leftJoin('Luv2_unit as u', 'iu.id_unit', '=', 'u.id')
        //     ->where('a.company_code', $user->company_code);
        // // ->where('a.whs_code', $user->whs_code);

        // if (!empty($this->inputfilter)) {
        //     $query->where($columnToFilter, 'ILIKE', '%' . $this->inputfilter . '%');
        // }

        // $this->item = $query
        //     ->groupBy('a.code', 'a.barcode', 'a.name', 'a.avgprice', 'u.name')
        //     ->get()
        //     ->map(function ($item) {
        //         $item->trans_qty = $item->trans_qty ?? 0;
        //         $item->item_unit_qty = $item->item_unit_qty ?? 0;
        //         $unit_qty = $item->item_unit_qty;

        //         // Initialize full_units and remainder_pieces to 0
        //         $full_units = 0;
        //         $remainder_pieces = 0;

        //         // Only calculate if unit_qty is greater than 0
        //         if ($unit_qty > 0) {
        //             // Calculate the difference and modulus
        //             $remaining_qty = $item->trans_qty;
        //             $full_units = intdiv($remaining_qty, $unit_qty);
        //             $remainder_pieces = $remaining_qty % $unit_qty;
        //         }

        //         // Format the message
        //         $unit_part = $full_units > 0 ? "{$full_units} {$item->unit_name}" : "";
        //         $piece_part = $remainder_pieces > 0 ? "{$remainder_pieces} pcs" : "";

        //         $item->message = trim("{$unit_part} {$piece_part}");

        //         // Add pricebuy and pricesell to item
        //         $item->pricebuy = $item->pricebuy ?? 0;
        //         $item->pricesell = $item->pricesell ?? 0;

        //         return $item;
        //     });
        // $this->dispatch('showItem', $this->item);

        $query = DB::table('Luv2_item as a')
            ->select([
                'a.code',
                'a.barcode',
                'a.name',
                'a.avgprice',
                'a.size_code',
                DB::raw('COALESCE((
            SELECT COALESCE(b.price, 0)
            FROM "Luv2_item_pricelist" b
            WHERE a.code = b.item_code
            AND b.pricelist_code = \'' . $pricelist_code . '\'
            AND b.company_code = \'' . $user->company_code . '\'
            LIMIT 1
        ), 0) AS price'),
                DB::raw('COALESCE((
            SELECT SUM(qty)
            FROM "Luv2_item_trans"
            WHERE item_code = a.code
            AND company_code = \'' . $user->company_code . '\'
            AND whs_code = \'' . $user->whs_code . '\'
        ), 0) AS trans_qty')
            ])
            ->where('a.company_code', $user->company_code);

        // Apply input filter if provided
        if (!empty($this->inputfilter)) {
            $query->where($columnToFilter, 'ILIKE', '%' . $this->inputfilter . '%');
        }

        // Fetch the items without additional processing
        $this->item = $query
            ->groupBy('a.code', 'a.barcode', 'a.name', 'a.avgprice', 'a.size_code')
            ->get();
        $this->dispatch('showItem', $this->item);
    }


    #[On('openModalDetail')]
    public function openModalDetail()
    {

        $this->dispatch('openModal');
    }

    #[On('showItem')]
    public function toFilter()
    {
        $this->isFilter = true;
        $this->isloadingsearch = false;
        $this->dispatch('refreshjs');
    }

    public function clickGetItem()
    {
        $this->isloadingitem = true;
        $this->dispatch('getItem');
    }

    public function clickGetTrans()
    {
        $this->isloadingtrans = true;
        $this->dispatch('getTrans');
    }

    #[On('getItem')]
    public function items()
    {
        $this->getItemwithUDF();
    }

    #[On('finish')]
    public function afterSuccess()
    {
        $this->isloadingitem = false;
        $this->isloadingtrans = false;
        return redirect()->route('item');
    }
    public function clickPromo()
    {
        $this->isloadingpromo = true;
        $this->dispatch('toSyncPromo');
    }


    #[On('toSyncPromo')]
    public function syncPromo()
    {
        try {
            $user = Auth::user();
            $whscode = $user->whs_code;
            $company_code = $user->company_code;
            $appurl = env('APP_URL');
            $appurlWithoutProtocol = preg_replace("~^(?:f|ht)tps?://~i", "", $appurl);

            $urladmin = env('ADMIN_URL') . $appurlWithoutProtocol . '/';
            $responsepromo = Http::get($urladmin . 'promo/' . $company_code . '/' . $whscode);
            $responsepromoitem = Http::get($urladmin . 'promoitem/' . $company_code . '/' . $whscode);
            $responseitemqty = Http::get($urladmin . 'promoitemqty/' . $company_code . '/' . $whscode);
            $responseitemgwp = Http::get($urladmin . 'promoitemgwp/' . $company_code . '/' . $whscode);
            $responsebundlingqty = Http::get($urladmin . 'promobundlingqty/' . $company_code . '/' . $whscode);
            $responsevoucher = Http::get($urladmin . 'promovoucher/' . $company_code . '/' . $whscode);
            $responsecashback = Http::get($urladmin . 'promocashback/' . $company_code);
            $failedResponses = [];

            if ($responsepromo->failed()) {
                $failedResponses[] = 'promo';
            }
            if ($responsepromoitem->failed()) {
                $failedResponses[] = 'promoitem';
            }
            if ($responseitemqty->failed()) {
                $failedResponses[] = 'promoitemqty';
            }
            if ($responseitemgwp->failed()) {
                $failedResponses[] = 'promoitemgwp';
            }
            if ($responsebundlingqty->failed()) {
                $failedResponses[] = 'promobundlingqty';
            }
            if ($responsevoucher->failed()) {
                $failedResponses[] = 'promovoucher';
            }
            if ($responsecashback->failed()) {
                $failedResponses[] = 'promocashback';
            }

            if (empty($failedResponses)) {
                // Do something when all responses are successful
                $datapromo = $responsepromo->json();
                $datapromoitem = $responsepromoitem->json();
                $dataitemqty = $responseitemqty->json();
                $dataitemgwp = $responseitemgwp->json();
                $databundlingqty = $responsebundlingqty->json();
                $datavoucher = $responsevoucher->json();
                $datacashback = $responsecashback->json();
                DB::table('Luv2_promo_temp')->where('id_user', $user->id)->delete();
                DB::table('Luv2_promo_item_temp')->where('id_user', $user->id)->delete();
                DB::table('Luv2_promo_item_qty_temp')->where('id_user', $user->id)->delete();
                DB::table('Luv2_promo_item_gwp_temp')->where('id_user', $user->id)->delete();
                DB::table('Luv2_promo_voucher_temp')->where('id_user', $user->id)->delete();
                DB::table('Luv2_promo_bundling_qty_temp')->where('id_user', $user->id)->delete();


                if (!empty($datapromo)) {
                    $chunks = array_chunk($datapromo, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];

                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'id_pricelist' => $item['id_pricelist'],
                                'name' => $item['name'],
                                'from_date' => $item['from_date'],
                                'to_date' => $item['to_date'],
                                'deleted' => $item['deleted'],
                                'company_code' => $item['id_company'],
                                'tipe' => $item['tipe'],
                                'benefit' => $item['benefit'],
                                'date' => $item['date'],
                                'qty_pack' => $item['qty_pack'],
                                'value_pack' => $item['value_pack'],
                                'disc' => $item['disc'],
                                'disc_price' => $item['disc_price'],
                                'voucher_from_date' => $item['voucher_from_date'],
                                'voucher_to_date' => $item['voucher_to_date'],
                                'voucher' => $item['voucher'],
                                'id_user' => $user->id,
                            ];
                        }
                        DB::table('Luv2_promo_temp')->insert($insertData);
                    }
                }

                if (!empty($datapromoitem)) {
                    $chunks = array_chunk($datapromoitem, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];

                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'item_code' => $item['item_code'],
                                'disc' => $item['disc'],
                                'disc_price' => $item['disc_price'],
                                'pack' => $item['pack'],
                                // 'item_barcode' => $item['item_barcode'],
                                // 'item_name' => $item['item_name'],
                                // 'item_price' => $item['item_price'],
                                // 'qty' => $item['qty'],
                                'id_user' => $user->id,

                            ];
                        }
                        DB::table('Luv2_promo_item_temp')->insert($insertData);
                    }
                }
                if (!empty($dataitemqty)) {
                    $chunks = array_chunk($dataitemqty, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'item_code' => $item['item_code'],
                                'qty' => $item['qty'],
                                'disc' => $item['disc'],
                                'disc_price' => $item['disc_price'],
                                'id_user' => $user->id,
                            ];
                        }
                        DB::table('Luv2_promo_item_qty_temp')->insert($insertData);
                    }
                }
                if (!empty($dataitemgwp)) {
                    $chunks = array_chunk($dataitemgwp, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'item_code' => $item['item_code'],
                                'item_barcode' => $item['item_barcode'],
                                'item_name' => $item['item_name'],
                                'id_user' => $user->id,

                            ];
                        }
                        DB::table('Luv2_promo_item_gwp_temp')->insert($insertData);
                    }
                }

                if (!empty($databundlingqty)) {
                    $chunks = array_chunk($databundlingqty, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'qty' => $item['qty'],
                                'disc' => $item['disc'],
                                'disc_price' => $item['disc_price'],
                                'id_user' => $user->id,
                            ];
                        }
                        DB::table('Luv2_promo_bundling_qty_temp')->insert($insertData);
                    }
                }

                if (!empty($datavoucher)) {
                    $chunks = array_chunk($datavoucher, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'voucher' => $item['voucher'],
                                'value' => $item['value'],
                                'used' => $item['used'],
                                'id_user' => $user->id,
                            ];
                        }
                        DB::table('Luv2_promo_voucher_temp')->insert($insertData);
                    }
                }
                if (!empty($datacashback)) {
                    $chunks = array_chunk($$datacashback, 1000);
                    foreach ($chunks as $chunk) {
                        $insertData = [];
                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'no' => $item['no'],
                                'company_code' => $item['id_company'],
                                'voucher' => $item['voucher'],
                                'value' => $item['value'],
                                'used' => $item['used'],
                                'id_user' => $user->id,
                            ];
                        }
                        DB::table('Luv2_promo_voucher_temp')->insert($insertData);
                    }
                }

                #insert promo
                DB::statement("
                INSERT INTO \"Luv2_promo\" (\"no\", \"id_pricelist\", \"name\", \"from_date\", \"to_date\", \"deleted\", \"company_code\", \"tipe\", \"benefit\", \"date\", \"disc\", \"disc_price\", \"qty_pack\", \"value_pack\", \"voucher_from_date\", \"voucher_to_date\", \"voucher\")
                SELECT DISTINCT \"no\", \"id_pricelist\", \"name\", \"from_date\", \"to_date\", \"deleted\", \"company_code\", \"tipe\", \"benefit\", \"date\", \"disc\", \"disc_price\", \"qty_pack\", \"value_pack\", \"voucher_from_date\", \"voucher_to_date\", \"voucher\"
                FROM \"Luv2_promo_temp\"
                WHERE NOT EXISTS (
                    SELECT 1 FROM \"Luv2_promo\" WHERE \"Luv2_promo\".\"no\" = \"Luv2_promo_temp\".\"no\") and \"Luv2_promo_temp\".\"id_user\"='" . $user->id . "' 
            ");

                #update promo
                DB::statement("
                UPDATE \"Luv2_promo\"
                SET 
                    \"no\" = \"Luv2_promo_temp\".\"no\",
                    \"id_pricelist\" = \"Luv2_promo_temp\".\"id_pricelist\",
                    \"name\" = \"Luv2_promo_temp\".\"name\",
                    \"from_date\" = \"Luv2_promo_temp\".\"from_date\",
                    \"to_date\" = \"Luv2_promo_temp\".\"to_date\",
                    \"deleted\" = \"Luv2_promo_temp\".\"deleted\",
                    \"company_code\" = \"Luv2_promo_temp\".\"company_code\",
                    \"tipe\" = \"Luv2_promo_temp\".\"tipe\",
                    \"benefit\" = \"Luv2_promo_temp\".\"benefit\",
                    \"date\" = \"Luv2_promo_temp\".\"date\",
                    \"disc\" = \"Luv2_promo_temp\".\"disc\",
                    \"disc_price\" = \"Luv2_promo_temp\".\"disc_price\",
                    \"qty_pack\" = \"Luv2_promo_temp\".\"qty_pack\",
                    \"value_pack\" = \"Luv2_promo_temp\".\"value_pack\",
                    \"voucher_from_date\" = \"Luv2_promo_temp\".\"voucher_from_date\",
                    \"voucher_to_date\" = \"Luv2_promo_temp\".\"voucher_to_date\",
                    \"voucher\" = \"Luv2_promo_temp\".\"voucher\"
                FROM \"Luv2_promo_temp\"
                WHERE \"Luv2_promo\".\"no\" = \"Luv2_promo_temp\".\"no\" AND 
                    \"Luv2_promo_temp\".\"id_user\" = '" . $user->id . "' AND 
                    (
                    \"Luv2_promo_temp\".\"no\" <> \"Luv2_promo\".\"no\" OR
                    \"Luv2_promo_temp\".\"id_pricelist\" <> \"Luv2_promo\".\"id_pricelist\" OR
                    \"Luv2_promo_temp\".\"name\" <> \"Luv2_promo\".\"name\" OR
                    \"Luv2_promo_temp\".\"from_date\" <> \"Luv2_promo\".\"from_date\" OR
                    \"Luv2_promo_temp\".\"to_date\" <> \"Luv2_promo\".\"to_date\" OR
                    \"Luv2_promo_temp\".\"deleted\" <> \"Luv2_promo\".\"deleted\" OR
                    \"Luv2_promo_temp\".\"company_code\" <> \"Luv2_promo\".\"company_code\" OR
                    \"Luv2_promo_temp\".\"tipe\" <> \"Luv2_promo\".\"tipe\" OR
                    \"Luv2_promo_temp\".\"benefit\" <> \"Luv2_promo\".\"benefit\" OR
                    \"Luv2_promo_temp\".\"date\" <> \"Luv2_promo\".\"date\" OR
                    \"Luv2_promo_temp\".\"disc\" <> \"Luv2_promo\".\"disc\" OR
                    \"Luv2_promo_temp\".\"disc_price\" <> \"Luv2_promo\".\"disc_price\" OR
                    \"Luv2_promo_temp\".\"qty_pack\" <> \"Luv2_promo\".\"qty_pack\" OR
                    \"Luv2_promo_temp\".\"value_pack\" <> \"Luv2_promo\".\"value_pack\" OR
                    \"Luv2_promo_temp\".\"voucher_from_date\" <> \"Luv2_promo\".\"voucher_from_date\" OR
                    \"Luv2_promo_temp\".\"voucher_to_date\" <> \"Luv2_promo\".\"voucher_to_date\" OR
                    \"Luv2_promo_temp\".\"voucher\" <> \"Luv2_promo\".\"voucher\"
                    );
            ");

                #insert promo item
                DB::statement("
            INSERT INTO \"Luv2_promo_item\" (\"no\", \"company_code\", \"item_code\", \"disc\", \"disc_price\", \"pack\")
            SELECT DISTINCT \"no\", \"company_code\", \"item_code\", \"disc\", \"disc_price\", \"pack\"
            FROM \"Luv2_promo_item_temp\"
            WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_promo_item\" WHERE \"Luv2_promo_item\".\"no\" = \"Luv2_promo_item_temp\".\"no\") and \"Luv2_promo_item_temp\".\"id_user\"='" . $user->id . "' 
        ");

                #update promo item
                DB::statement("
            UPDATE \"Luv2_promo_item\"
            SET 
                \"disc\" = \"Luv2_promo_item_temp\".\"disc\",
                \"disc_price\" = \"Luv2_promo_item_temp\".\"disc_price\"
            FROM \"Luv2_promo_item_temp\"
            WHERE \"Luv2_promo_item\".\"no\" = \"Luv2_promo_item_temp\".\"no\" AND 
                \"Luv2_promo_item_temp\".\"id_user\" = '" . $user->id . "' AND 
                \"Luv2_promo_item_temp\".\"item_code\" = \"Luv2_promo_item\".\"item_code\" AND 
                \"Luv2_promo_item_temp\".\"pack\" = \"Luv2_promo_item\".\"pack\" AND 
                (
                \"Luv2_promo_item_temp\".\"disc\" <> \"Luv2_promo_item\".\"disc\" OR
                \"Luv2_promo_item_temp\".\"disc_price\" <> \"Luv2_promo_item\".\"disc_price\"
                );
        ");

                #insert promo item qty
                DB::statement("
            INSERT INTO \"Luv2_promo_item_qty\" (\"no\", \"company_code\", \"item_code\", \"disc\", \"disc_price\", \"qty\")
            SELECT DISTINCT \"no\", \"company_code\", \"item_code\", \"disc\", \"disc_price\", \"qty\"
            FROM \"Luv2_promo_item_qty_temp\"
            WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_promo_item_qty\" WHERE \"Luv2_promo_item_qty\".\"no\" = \"Luv2_promo_item_qty_temp\".\"no\" and \"Luv2_promo_item_qty\".\"item_code\" = \"Luv2_promo_item_qty_temp\".\"item_code\" and \"Luv2_promo_item_qty\".\"qty\" = \"Luv2_promo_item_qty_temp\".\"qty\") and \"Luv2_promo_item_qty_temp\".\"id_user\"='" . $user->id . "' 
        ");

                #update promo item qty
                DB::statement("
            UPDATE \"Luv2_promo_item_qty\"
            SET 
                \"disc\" = \"Luv2_promo_item_qty_temp\".\"disc\",
                \"disc_price\" = \"Luv2_promo_item_qty_temp\".\"disc_price\"
            FROM \"Luv2_promo_item_qty_temp\"
            WHERE \"Luv2_promo_item_qty\".\"no\" = \"Luv2_promo_item_qty_temp\".\"no\" AND 
                \"Luv2_promo_item_qty_temp\".\"id_user\" = '" . $user->id . "' AND 
                \"Luv2_promo_item_qty_temp\".\"item_code\" = \"Luv2_promo_item_qty\".\"item_code\" AND 
                \"Luv2_promo_item_qty_temp\".\"qty\" = \"Luv2_promo_item_qty\".\"qty\" AND 
                (
                \"Luv2_promo_item_qty\".\"disc\" <> \"Luv2_promo_item_qty_temp\".\"disc\" OR
                \"Luv2_promo_item_qty\".\"disc_price\" <> \"Luv2_promo_item_qty_temp\".\"disc_price\"
                );
        ");

                #insert promo item gwp
                DB::statement("
            INSERT INTO \"Luv2_promo_item_gwp\" (\"no\", \"company_code\", \"item_code\", \"item_barcode\", \"item_name\")
            SELECT DISTINCT \"no\", \"company_code\", \"item_code\", \"item_barcode\", \"item_name\"
            FROM \"Luv2_promo_item_gwp_temp\"
            WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_promo_item_gwp\" WHERE \"Luv2_promo_item_gwp\".\"no\" = \"Luv2_promo_item_gwp_temp\".\"no\" and \"Luv2_promo_item_gwp\".\"item_code\" = \"Luv2_promo_item_gwp_temp\".\"item_code\") and \"Luv2_promo_item_gwp_temp\".\"id_user\"='" . $user->id . "' 
            ");

                #update promo item gwp
                DB::statement("
            UPDATE \"Luv2_promo_item_gwp\"
            SET 
                \"item_barcode\" = \"Luv2_promo_item_gwp_temp\".\"item_barcode\",
                \"item_name\" = \"Luv2_promo_item_gwp_temp\".\"item_name\"
            FROM \"Luv2_promo_item_gwp_temp\"
            WHERE \"Luv2_promo_item_gwp\".\"no\" = \"Luv2_promo_item_gwp_temp\".\"no\" AND 
                \"Luv2_promo_item_gwp_temp\".\"id_user\" = '" . $user->id . "' AND 
                \"Luv2_promo_item_gwp_temp\".\"item_code\" = \"Luv2_promo_item_gwp\".\"item_code\" AND 
                (
                \"Luv2_promo_item_gwp_temp\".\"item_barcode\" <> \"Luv2_promo_item_gwp\".\"item_barcode\" OR
                \"Luv2_promo_item_gwp_temp\".\"item_name\" <> \"Luv2_promo_item_gwp\".\"item_name\"
                );
            ");

                #insert promo bundling qty
                DB::statement("
            INSERT INTO \"Luv2_promo_bundling_qty\" (\"no\", \"company_code\", \"disc\", \"disc_price\", \"qty\")
            SELECT DISTINCT \"no\", \"company_code\", \"disc\", \"disc_price\", \"qty\"
            FROM \"Luv2_promo_bundling_qty_temp\"
            WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_promo_bundling_qty\" WHERE \"Luv2_promo_bundling_qty\".\"no\" = \"Luv2_promo_bundling_qty_temp\".\"no\") and \"Luv2_promo_bundling_qty_temp\".\"id_user\"='" . $user->id . "' 
            ");

                #update promo bundling qty
                DB::statement("
            UPDATE \"Luv2_promo_bundling_qty\"
            SET 
                \"disc\" = \"Luv2_promo_bundling_qty_temp\".\"disc\",
                \"disc_price\" = \"Luv2_promo_bundling_qty_temp\".\"disc_price\"
            FROM \"Luv2_promo_bundling_qty_temp\"
            WHERE \"Luv2_promo_bundling_qty\".\"no\" = \"Luv2_promo_bundling_qty_temp\".\"no\" AND 
                \"Luv2_promo_bundling_qty_temp\".\"id_user\" = '" . $user->id . "' AND 
                \"Luv2_promo_bundling_qty_temp\".\"qty\" = \"Luv2_promo_bundling_qty\".\"qty\" AND
                (
                \"Luv2_promo_bundling_qty_temp\".\"disc\" <> \"Luv2_promo_bundling_qty\".\"disc\" OR
                \"Luv2_promo_bundling_qty_temp\".\"disc_price\" <> \"Luv2_promo_bundling_qty\".\"disc_price\"
                );
            ");


                #insert promo voucher
                DB::statement("
            INSERT INTO \"Luv2_promo_voucher\" (\"no\", \"company_code\", \"voucher\", \"value\", \"used\")
            SELECT DISTINCT \"no\", \"company_code\", \"voucher\", \"value\", \"used\"
            FROM \"Luv2_promo_voucher_temp\"
            WHERE NOT EXISTS (
                SELECT 1 FROM \"Luv2_promo_voucher\" WHERE \"Luv2_promo_voucher\".\"no\" = \"Luv2_promo_voucher_temp\".\"no\") and \"Luv2_promo_voucher_temp\".\"id_user\"='" . $user->id . "' 
            ");

                #update promo voucher
                DB::statement("
            UPDATE \"Luv2_promo_voucher\"
            SET 
                \"value\" = \"Luv2_promo_voucher_temp\".\"value\",
                \"used\" = \"Luv2_promo_voucher_temp\".\"used\"
            FROM \"Luv2_promo_voucher_temp\"
            WHERE \"Luv2_promo_voucher\".\"no\" = \"Luv2_promo_voucher_temp\".\"no\" AND 
                \"Luv2_promo_voucher_temp\".\"id_user\" = '" . $user->id . "' AND 
                \"Luv2_promo_voucher_temp\".\"voucher\" = \"Luv2_promo_voucher\".\"voucher\" AND 
                (
                \"Luv2_promo_voucher_temp\".\"value\" <> \"Luv2_promo_voucher\".\"value\" OR
                \"Luv2_promo_voucher_temp\".\"used\" <> \"Luv2_promo_voucher\".\"used\"
                );
            ");

                $this->alert('success', 'Promo Synchrone succesfully', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                // dd($datapromo, $datapromoitem, $dataitemqty, $dataitemgwp, $databundlingqty, $datavoucher, $datacashback);
            } else {
                // Handle the case when any of the responses fails
                dd('One or more responses failed: ' . implode(', ', $failedResponses));
            }
        } catch (\Exception $e) {
            if ($this->isConnectionResetError($e)) {
                $this->alert('info', 'Please Wait Re-trying Sync Items', [
                    'position' => 'top-right',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->reDoFunction('syncPromo');
            } else {
                throw $e;
            }
        }
        $this->isloadingpromo = false;
    }

    public function toBatch()
    {
        session(['insertType' => 'Item']);
        return redirect()->route('item.input');
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        DB::table('Luv2_user')
            ->where('id', $user->id)
            ->update(['whs_code' => $this->whs_code]);
        $this->isFilter = false;
    }

    #[On('successNotification')]
    public function successNotification()
    {
        $this->alert('success', 'Data lost sale berhasil disimpan', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }
}
