<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;

class InsertSupplier extends Component
{
    use WithFileUploads;
    use LivewireAlert;

    // #[Rule('required', message: 'Code field is required.')]
    // #[Rule('min:3', message: 'Code field must be at least 3 characters.')]
    // #[Rule('unique:Luv2_supplier,code', message: 'Code has been taken and must be unique.')]
    public string $code;

    #[Rule('required', message: 'Supplier Name field is required.')]
    #[Rule('min:4', message: 'Supplier Name field must be at least 4 characters.')]
    public string $name = '';
    public $istutorials;
    public $file;
    public $chunks;
    public $address;

    #[Rule('numeric', message: 'Phone field must be a numeric value.')]
    public $phone;

    #[Rule('required_if:consignment,true|required_if:activate_dashboard,true', message: 'Email is required for consignment suppliers or when dashboard is activated')]
    #[Rule('email', message: 'Email field must be a valid email.')]
    public $email;

    public $consignment = false;

    #[Rule('required_if:consignment,true', message: 'Shared margin is required when consignment is enabled')]
    #[Rule('numeric', message: 'Shared margin must be a number of percentage')]
    public $shared_margin;

    public $activate_dashboard = false;
    public $editChunks = false;
    public $errMsg = '';
    public $isTable = true;
    public $itemSupplier;
    public $warehouses;
    public $isEdit = false;
    public $whs_code;
    public function render()
    {
        $this->itemSupplier = DB::table('Luv2_supplier')->where('company_code', Auth::user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->get();
        $this->warehouses = Warehouse::where('company_code', auth()->user()->company_code)
            // ->where('code', auth()->user()->whs_code)
            ->get();

        if (Auth::user()->role != 'Admin') {
            $this->whs_code = Auth::user()->whs_code;
        }
        return view('livewire.pos.item.insert-supplier');
    }

    public function mount()
    {
        $tutorials = DB::table('Luv2_tutorial')
            ->where('id_user', auth()->user()->id)
            ->where('menu', 'Supplier')
            ->first();
        if ($tutorials && $tutorials->active === 'Y') {
            $this->istutorials = true;
        } else {
            $this->istutorials = false;
        }
    }


    // public function importItem()
    // {
    //     $data = $this->validate([
    //         'file' => 'required',
    //     ]);
    //     try {
    //         $file = fopen($this->file->getRealPath(), 'r');

    //         $skipFirstRow = true;

    //         $chunkSize = 100;
    //         $chunks = [];

    //         while (($data = fgetcsv($file)) !== false) {
    //             if ($skipFirstRow) {
    //                 $skipFirstRow = false;
    //                 continue;
    //             }

    //             $chunks[] = [
    //                 'company_code' => Auth::user()->company_code,
    //                 'code' => $data[0],
    //                 'name' => $data[1],
    //                 'address' => $data[2],
    //                 'phone' => trim($data[3], " \t\n\r\0\x0B`"),
    //                 'email' => $data[4],
    //                 'id_user' => Auth::user()->id,
    //                 'created_at' => Carbon::now(),
    //                 'updated_at' => Carbon::now(),
    //             ];
    //         }
    //         fclose($file);
    //         $this->chunks = $chunks;

    //         $this->dispatch('refreshjs');
    //     } catch (\Throwable $th) {
    //         $this->alert('warning', 'Error, check the template!', [
    //             'position' => 'top-end',
    //             'timer' => 3000,
    //             'toast' => true,
    //             'timerProgressBar' => true,
    //         ]);
    //     }
    // }

    public function importItem()
    {
        $data = $this->validate([
            'file' => 'required|file|mimes:csv,xlsx,txt',
        ]);
        try {
            $fileExtension = $this->file->getClientOriginalExtension();

            if ($fileExtension === 'csv' || $fileExtension === 'txt') {
                $this->importCSV();
            } elseif ($fileExtension === 'xlsx') {
                $this->importXLSX();
            } else {
                $this->alert('warning', 'Format file tidak didukung', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (\Throwable $th) {
            $this->alert('warning', 'Error, Format template salah!', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function importCSV()
    {
        $file = fopen($this->file->getRealPath(), 'r');
        $skipFirstRow = true;
        $chunks = [];

        while (($data = fgetcsv($file)) !== false) {
            if ($skipFirstRow) {
                $skipFirstRow = false;
                continue;
            }
            $chunks[] = [
                'company_code' => Auth::user()->company_code,
                'code' => $data[0],
                'name' => $data[1],
                'address' => $data[2],
                'phone' => ltrim($data[3], '`'),
                'email' => $data[4],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'id_user' => Auth::user()->id,
            ];
        }
        fclose($file);
        $this->chunks = $chunks;
    }

    public function importXLSX()
    {
        $rows = Excel::toArray([], $this->file->getRealPath())[0];
        $chunks = [];
        $skipFirstRow = true;

        foreach ($rows as $row) {
            if ($skipFirstRow) {
                $skipFirstRow = false;
                continue;
            }

            $chunks[] = [
                'company_code' => Auth::user()->company_code,
                'code' => $row[0],
                'name' => $row[1],
                'address' => $row[2],
                'phone' => ltrim($row[3], '`'),
                'email' => $row[4],
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'id_user' => Auth::user()->id,
            ];
        }
        $this->chunks = $chunks;
    }

    #[On('refreshjs')]
    public function refreshjs()
    {
        $this->dispatch('refreshDatatable');
    }

    public function cancelImport()
    {
        $this->chunks = [];
    }

    public function saveChunks()
    {
        // dd($this->chunks);
        $userId = Auth::user()->id;
        DB::table('Luv2_supplier_temp')->where('id_user', $userId)->delete();
        $chunksItem = array_chunk($this->chunks, 1000);
        foreach ($chunksItem as $chunk) {
            $insertData = [];

            foreach ($chunk as $data) {
                $insertData[] = [
                    'company_code' => Auth::user()->company_code,
                    'code' => $data['code'],
                    'name' => $data['name'],
                    'address' => $data['address'],
                    'phone' => $data['phone'],
                    'email' => $data['email'],
                    'id_user' => Auth::user()->id,
                    'created_at' => $data['created_at'],
                    'updated_at' => $data['updated_at'],
                ];
            }

            DB::table('Luv2_supplier_temp')->insert($insertData);
        }
        $this->chunks = [];
        $this->file = '';

        DB::statement("
        INSERT INTO \"Luv2_supplier\" (\"company_code\", \"code\", \"name\", \"address\", \"phone\", \"email\", \"created_at\", \"updated_at\") 
        SELECT DISTINCT \"company_code\", \"code\", \"name\", \"address\", \"phone\", \"email\",  \"created_at\", \"updated_at\"
        FROM \"Luv2_supplier_temp\"
        WHERE NOT EXISTS (
            SELECT 1 FROM \"Luv2_supplier\" WHERE \"Luv2_supplier\".\"code\" = \"Luv2_supplier_temp\".\"code\" and \"Luv2_supplier\".\"company_code\"=\"Luv2_supplier_temp\".\"company_code\") and \"Luv2_supplier_temp\".\"id_user\"='" . $userId . "' 
    ");

        #update item
        DB::statement("
        UPDATE \"Luv2_supplier\"
        SET \"code\"=\"Luv2_supplier_temp\".\"code\",\"name\"=\"Luv2_supplier_temp\".\"name\",\"address\"=\"Luv2_supplier_temp\".\"address\",\"phone\"=\"Luv2_supplier_temp\".\"phone\",\"email\"=\"Luv2_supplier_temp\".\"email\",\"updated_at\"=\"Luv2_supplier_temp\".\"updated_at\"
        FROM \"Luv2_supplier_temp\"
        WHERE \"Luv2_supplier_temp\".\"code\"=\"Luv2_supplier\".\"code\" AND \"Luv2_supplier_temp\".\"company_code\"=\"Luv2_supplier\".\"company_code\" AND \"Luv2_supplier_temp\".\"id_user\"='" . $userId . "'
        AND (
            \"Luv2_supplier_temp\".\"code\"<>\"Luv2_supplier\".\"code\" OR
            \"Luv2_supplier_temp\".\"name\"<>\"Luv2_supplier\".\"name\" OR
            \"Luv2_supplier_temp\".\"address\"<>\"Luv2_supplier\".\"address\" OR
            \"Luv2_supplier_temp\".\"name\"<>\"Luv2_supplier\".\"phone\" OR
            \"Luv2_supplier_temp\".\"name\"<>\"Luv2_supplier\".\"email\" OR
            \"Luv2_supplier_temp\".\"updated_at\"<>\"Luv2_supplier\".\"updated_at\"
            
        );
    ");

        $this->alert('success', 'Data supplier successfully saved', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->dispatch('afterSave');
    }

    public function updateChunk($index, $field, $value)
    {
        $this->chunks[$index][$field] = $value;
    }

    public function modeEdit()
    {
        $this->editChunks = !$this->editChunks;

        if (!$this->editChunks) {
            $this->dispatch('refreshjs');
        }
    }

    public function save()
    {
        try {
            if ($this->consignment || $this->activate_dashboard) {
                $this->validate([
                    'email' => 'required|email',
                    'shared_margin' => 'required|numeric',
                ]);
            }

            $this->code = '';
            $words = explode(' ', $this->name);
            $firstLetters = '';
            foreach ($words as $word) {
                $firstLetters .= substr($word, 0, 1);
            }

            $lastFourDigits = substr(Auth::user()->company_code, -4);
            $seconds = Carbon::now()->format('s');
            $this->code = $lastFourDigits . $firstLetters . $seconds;

            $checkitem = DB::table('Luv2_supplier')
                ->where('company_code', Auth::user()->company_code)
                ->where('code', $this->code)
                ->first();

            if ($checkitem) {
                $this->errMsg = 'Kode Supplier ' . $this->code . ' sudah ada!';
                return;
            }

            DB::beginTransaction();
            try {
                DB::table('Luv2_supplier')->insert([
                    'company_code' => Auth::user()->company_code,
                    'code' => $this->code,
                    'name' => $this->name,
                    'address' => $this->address,
                    'phone' => $this->phone,
                    'email' => $this->email,
                    'consignment' => $this->consignment ? 'Y' : 'N',
                    'dashboard' => $this->consignment ? ($this->activate_dashboard ? 'Y' : 'N') : 'N',
                    'shared_margin' => $this->consignment ? ($this->shared_margin ?? 0) : 0,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ]);

                if ($this->activate_dashboard && $this->email) {
                    $existingDashUser = DB::table('Luv2_supplier_dash')
                        ->where('email', $this->email)
                        ->first();

                    if (!$existingDashUser) {
                        DB::table('Luv2_supplier_dash')->insert([
                            'email' => $this->email,
                        ]);
                        
                        $token = Str::random(60);
                        $this->dispatch('sendSupplierSetupEmail', ['email' => $this->email, 'token' => $token]);
                    } elseif ($existingDashUser && !$existingDashUser->password) {
                        $token = Str::random(60);
                        $this->dispatch('sendSupplierSetupEmail', ['email' => $this->email, 'token' => $token]);
                    }
                }

                DB::commit();
                $this->dispatch('closeModal');
                $this->dispatch('afterSave');
                
                $this->alert('success', 'Supplier berhasil dibuat!', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            } catch (\Exception $e) {
                DB::rollBack();
                $this->alert('error', 'Gagal membuat supplier: ' . $e->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (\Exception $e) {
            $this->alert('error', 'Validasi gagal: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }


    #[On('sendSupplierSetupEmail')]
    public function handleSendSetupEmail($data)
    {
        try {
            DB::table('password_resets')->insert([
                'email' => $data['email'],
                'token' => $data['token'],
                'created_at' => Carbon::now()
            ]);

            Mail::send('emails.setup-password', ['token' => $data['token']], function($message) use ($data) {
                $message->to($data['email'])
                        ->subject('Set Up Your Supplier Dashboard Password');
            });

            $this->alert('success', 'Setup email sent successfully!', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (\Exception $e) {
            $this->alert('error', 'Failed to send setup email: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function updated()
    {
        $this->errMsg = '';
    }

    #[On('closeModal')]
    public function closeModal()
    {
        $this->code = '';
        $this->name = '';
        $this->address = '';
        $this->phone = '';
        $this->email = '';
        $this->consignment = false;
        $this->activate_dashboard = false;
        $this->shared_margin = '';

        $this->dispatch('closemodalCreate');
        $this->dispatch('closeModalBrowser');
        $this->alert('success', 'Data Supplier successfully saved', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function changeTable()
    {
        $this->isTable = !$this->isTable;

        $this->chunks = [];
        $this->file = '';

        if (!$this->editChunks) {
            $this->dispatch('refreshjs');
        }
    }

    #[On('afterSave')]
    public function dataSupplierafterSave()
    {
        $this->itemSupplier = DB::table('Luv2_supplier')
            // ->where('whs_code', auth()->user()->whs_code)
            ->where('company_code', Auth::user()->company_code)->get();
    }

    #[On('isEdit')]
    public function isEdit($code)
    {
        $supplier = DB::table('Luv2_supplier')->where('company_code', Auth::user()->company_code)->where('code', $code)->first();
        if ($supplier) {
            $this->isEdit = true;
            $this->code = $supplier->code;
            $this->name = $supplier->name;
            $this->address = $supplier->address;
            $this->phone = $supplier->phone;
            $this->email = $supplier->email;
            $this->consignment = $supplier->consignment === 'Y' ? true : false;
            if ($supplier->consignment === 'Y') {
                $this->activate_dashboard = $supplier->dashboard === 'Y' ? true : false;
                $this->shared_margin = $supplier->shared_margin;
            }
            $this->dispatch('openModalEdit');
        } else {
            $this->isEdit = false;
        }
    }

    #[On('openModalEdit')]
    public function openModal()
    {
        $this->dispatch('openModalforEdit', [
            'code' => $this->code,
            'name' => $this->name,
            'address' => $this->address,
            'phone' => $this->phone,
            'email' => $this->email,
            'consignment' => $this->consignment,
            'dashboard' => $this->activate_dashboard,
            'shared_margin' => $this->shared_margin,
        ]);
        $this->dispatch('refreshjs');
    }

    public function saveUpdate()
    {
        try {
            if ($this->consignment && $this->activate_dashboard) {
                $this->validate([
                    'email' => 'required|email',
                    'shared_margin' => 'required|numeric',
                ]);
            }

            DB::beginTransaction();
            try {
                DB::table('Luv2_supplier')->where('code', $this->code)
                    ->where('company_code', Auth::user()->company_code)
                    ->update([
                        'name' => $this->name,
                        'address' => $this->address,
                        'phone' => $this->phone,
                        'email' => $this->email,
                        'consignment' => $this->consignment ? 'Y' : 'N',
                        'dashboard' => $this->consignment ? ($this->activate_dashboard ? 'Y' : 'N') : 'N',
                        'shared_margin' => $this->consignment ? ($this->shared_margin ?? 0) : 0,
                        'updated_at' => Carbon::now(),
                    ]);

                if ($this->activate_dashboard && $this->email) {
                    $existingDashUser = DB::table('Luv2_supplier_dash')
                        ->where('email', $this->email)
                        ->first();

                    if (!$existingDashUser) {
                        DB::table('Luv2_supplier_dash')->insert([
                            'email' => $this->email,
                        ]);
                        
                        $token = Str::random(60);
                        $this->dispatch('sendSupplierSetupEmail', ['email' => $this->email, 'token' => $token]);
                    } elseif ($existingDashUser && !$existingDashUser->password) {
                        $token = Str::random(60);
                        $this->dispatch('sendSupplierSetupEmail', ['email' => $this->email, 'token' => $token]);
                    }
                }

                DB::commit();
                $this->dispatch('refreshjs');
                $this->alert('success', 'Supplier berhasil diperbarui!', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isEdit = false;
                $this->dispatch('closeModal');
                $this->reset(['code', 'name', 'address', 'phone', 'email', 'consignment', 'shared_margin']);
            } catch (\Exception $e) {
                DB::rollBack();
                $this->alert('error', 'Gagal memperbarui supplier: ' . $e->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (\Exception $e) {
            $this->alert('error', 'Validasi gagal: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
}