<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class InsertIndex extends Component
{
    public $insertType = '';
    public $warehouse;
    public $whs_code;
    
    public function render()
    {
        $userId = Auth::id();
        $tutorials = DB::table('Luv2_tutorial')
            ->where('id_user', $userId)
            ->where('menu', 'Master')
            ->first();
        if ($tutorials && $tutorials->active === 'Y') {
            $istutorials = true;
        } else {
            $istutorials = false;
        }

        if (!session()->has('insertType')) {
            $this->insertType = session('insertType');
        } else {
            $this->insertType = session('insertType', 'Item');
        }
        return view('livewire.pos.item.insert-index', compact('istutorials'));
    }

    public function mount()
    {
        if (auth()->user()->role == 'Admin') {
            $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
            $this->whs_code = Auth::user()->whs_code;
        }
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;
        $user->save();
        $this->dispatch('updatedWhs')->to(InsertItemPricelist::class);

    }
    public function changeInsert($type)
    {
        session(['insertType' => $type]);

        $this->dispatch('refreshDatatable');
    }
}
