<?php

namespace App\Livewire\Pos\Item;

use App\Livewire\Pos\Employee\EmpIndex;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;

class InsertEmployee extends Component
{
    use WithFileUploads;
    use LivewireAlert;

    #[Rule('required', message: 'Code field is required.')]
    #[Rule('min:3', message: 'Code field must be at least 3 characters.')]
    #[Rule('unique:Luv2_salesemp,code', message: 'Code has been taken and must be unique.')]
    public string $code;

    #[Rule('required', message: 'Item Name field is required.')]
    #[Rule('min:4', message: 'Item Name field must be at least 4 characters.')]
    public string $name = '';

    #[Rule('required', message: 'Position field is required.')]
    public string $position = '';

    public string $remark = '';

    public $file;
    public $chunks;

    public $editChunks = false;
    public $errMsg = '';
    public $isTable = true;
    public $itemSales;
    public $warehouses;
    public $whs_code;
    public function render()
    {
        $this->itemSales = DB::table('Luv2_salesemp')->where('company_code', Auth::user()->company_code)
        // ->where('whs_code', auth()->user()->whs_code)
        ->get();
        $this->warehouses = Warehouse::where('company_code', auth()->user()->company_code)
        // ->where('code', auth()->user()->whs_code)
        ->get();

        if (Auth::user()->role != 'Admin') {
            $this->whs_code = Auth::user()->whs_code;
        }
        return view('livewire.pos.item.insert-employee');
    }

    public function importItem()
    {
        $data = $this->validate([
            'file' => 'required',
        ]);
        try {
            $file = fopen($this->file->getRealPath(), 'r');

            $skipFirstRow = true;

            $chunkSize = 100;
            $chunks = [];

            while (($data = fgetcsv($file)) !== false) {
                if ($skipFirstRow) {
                    $skipFirstRow = false;
                    continue;
                }

                $chunks[] = [
                    'company_code' => Auth::user()->company_code,
                    // 'whs_code' => Auth::user()->whs_code,
                    'code' => $data[0],
                    'name' => $data[1],
                    'position' => $data[2],
                    'remark' => $data[3],
                    'active' => 'Y',
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            }
            fclose($file);
            $this->chunks = $chunks;

            $this->dispatch('refreshjs');
        } catch (\Throwable $th) {
            $this->alert('warning', 'Error, check the template!', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('refreshjs')]
    public function refreshjs()
    {
        $this->dispatch('refreshDatatable');
    }

    public function cancelImport()
    {
        $this->chunks = [];
    }


    #[On('closeModal')]
    public function closeModal()
    {
        $this->code = '';
        $this->name = '';
        $this->position = '';
        $this->remark = '';

        $this->dispatch('closemodalCreate');
        $this->alert('success', 'Data Sales successfully saved', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function save()
    {
        $this->validate();

        $checkitem = DB::table('Luv2_salesemp')->where('company_code', Auth::user()->company_code)->where('code', $this->code)
        // ->where('whs_code', auth()->user()->whs_code)
        ->first();
        if ($checkitem) {
            $this->errMsg = 'Sales with Code ' . $this->code . ' already exists !';
        } else {
            DB::table('Luv2_salesemp')->insert([
                'company_code' => Auth::user()->company_code,
                // 'whs_code' => $this->whs_code,
                'code' => $this->code,
                'name' => $this->name,
                'position' => $this->position,
                'remark' => $this->remark,
                'active' => 'Y',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            $this->dispatch('closeModal');
            $this->dispatch('afterSave');

        }
    }

    #[On('afterSave')]
    public function dataSalesafterSave()
    {
        $this->itemSales = DB::table('Luv2_salesemp')->where('company_code', Auth::user()->company_code)
        // ->where('whs_code', auth()->user()->whs_code)
        ->get();

        $this->dispatch('closemodalCreate')->to(EmpIndex::class);
        $this->dispatch('refreshjs');
    }

}
