<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class IndexInsertUnitItem extends Component
{
    public $warehouse;
    public $whs_code;
    public $param;
    public $nameUnit = '-';

    public function render()
    {
        return view('livewire.pos.item.index-insert-unit-item');
    }

    public function mount($param)
    {
        $this->param = $param;
        $unit = DB::table('Luv2_unit')->where('id', $param)->where('company_code', auth()->user()->company_code)->first();
        if($unit){
            $this->nameUnit = $unit->name;
        }
        if (auth()->user()->role == 'Admin') {
            $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
            $this->whs_code = Auth::user()->whs_code;
        }
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;
        $user->save();
        $this->dispatch('updatedWhsUnit', $this->param)->to(InsertUnitItem::class);

    }

    public function changeInsert($type)
    {
        session(['insertType' => $type]);

        $this->dispatch('refreshDatatable');
    }
}
