<?php

namespace App\Livewire\Pos\It;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class ItOutDetail extends Component
{
    public $details;
    public $no;

    public function mount($it)
    {
        $this->details = DB::table('Luv2_it_out_detail')
            ->Join('Luv2_it_out', 'Luv2_it_out_detail.no', '=', 'Luv2_it_out.no')
            ->Join('Luv2_item', 'Luv2_it_out_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_out_detail"."qty") as "qty"'))
            ->where('Luv2_it_out.no', $it)
            ->groupBy('Luv2_item.code')
            ->get();

        $this->no = DB::table('Luv2_it_out')
            ->where('no', $it)->first();
    }

    public function render()
    {
        return view('livewire.pos.it.it-out-detail');
    }

    public function close()
    {
        return redirect()->route('it.itout');
    }
}
