<?php

namespace App\Livewire\Pos\Employee;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class ModalCreateEmployee extends Component
{
    public $showModal = false;

    public $code;
    public $name;
    public $position;
    public $remark;

    use LivewireAlert;

    protected function rules()
    {
        $user = Auth::user();

        return [
            'code' => 'required|string|max:50|unique:Luv2_salesemp,code,NULL,id,company_code,' . $user->company_code,
            'name' => 'required|string|max:255',
            'position' => 'required|string|max:255',
            'remark' => 'nullable|string|max:500',
        ];
    }

    public function save()
    {
        $this->validate();

        DB::table('Luv2_salesemp')->insert([
            'company_code' => Auth::user()->company_code,
            'code' => $this->code,
            'name' => $this->name,
            'position' => $this->position,
            'remark' => $this->remark,
            'created_at' => now(),
            'updated_at' => now(),
        ]);


        $this->alert('success', 'Sales employee berhasil dibuat', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->reset(['code', 'name', 'position', 'remark']);
    }

    public function render()
    {
        return view('livewire.pos.employee.modal-create-employee');
    }
}
