<?php

namespace App\Livewire\Payment;

use App\Mail\PaymentStatusUpdated;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Livewire\Attributes\On;
use Livewire\Component;

class RenewSubscription extends Component
{

    public $snapToken;

    public function render()
    {
        $transaction = DB::table('Luv2_renewal')
            ->join('Luv2_company', 'Luv2_renewal.company_code', '=', 'Luv2_company.code')
            ->where('Luv2_renewal.company_code', auth()->user()->company_code)
            ->select(
                'Luv2_renewal.*',
                'Luv2_company.*',
                'Luv2_renewal.created_at as created_atrenew', 
                'Luv2_renewal.updated_at as updated_atrenew', 
                'Luv2_company.updated_at as updated_atcompany'
            )
            ->latest()
            ->get();
        return view('livewire.payment.renew-subscription', [
            'transaction' => $transaction,
        ]);
    }

    #[On('getSnap')]
    public function getSnap($no)
    {
        $this->snapToken = $no;
        $this->dispatch('openTheSnap');
    }

    public function hydrate()
    {
        $this->dispatch('refreshjs');
    }
}
