<?php

namespace App\Livewire\Payment;

use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class PageUpgrade extends Component
{
    public $company;
    public $paketBasic;
    public $paketPro;
    public $isVisible = false;
    public function render()
    {
        return view('livewire.payment.page-upgrade');
    }

    public function mount()
    {
        $this->company = DB::table('Luv2_company')->where('code', auth()->user()->company_code)->first();
        $this->paketBasic = DB::table('Luv2_paket')
            ->where('name', 'Basic')
            ->select('Luv2_paket.*')
            ->first();
        $this->paketPro = DB::table('Luv2_paket')
            ->where('name', 'Pro')
            ->select('Luv2_paket.*')
            ->first();
        if ($this->paketBasic) {
            $paketPrices = DB::table('Luv2_paket_price')
                ->where('id_paket', $this->paketBasic->id)
                ->whereIn('month', [1, 12])
                ->get(['month', 'price']);
            $this->paketBasic->features = json_decode($this->paketBasic->description);
            $this->paketBasic->priceMonth = $paketPrices->where('month', 1)->first()->price ?? null;
            $this->paketBasic->priceYear = $paketPrices->where('month', 12)->first()->price ?? null;
        }
        if ($this->paketPro) {
            $paketPricesPro = DB::table('Luv2_paket_price')
                ->where('id_paket', $this->paketPro->id)
                ->whereIn('month', [1, 12])
                ->get(['month', 'price']);
            $this->paketPro->features = json_decode($this->paketPro->description);
            $this->paketPro->priceMonth = $paketPricesPro->where('month', 1)->first()->price ?? null;
            $this->paketPro->priceYear = $paketPricesPro->where('month', 12)->first()->price ?? null;
        }
    }

    public function setPaketId($paketId, $isDowngrade)
    {
        $this->isVisible = true;
        $this->dispatch('sendData', ['paketId' => $paketId, 'isDowngrade' => $isDowngrade]);
    }

    #[On('sendData')]
    public function sendData($data)
    {
        $this->dispatch('openUpgradeModal', ['data' => $data]);
    }


}
