<?php

namespace App\Livewire\Modals;

use App\Livewire\Cashier\Table;
use Livewire\Component;
use App\Models\Cart;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;

class EditDiscountModal extends Component
{
    public $selectedCart;
    public $discountType = 'percent';
    public $discountValue = 0;
    public $finalPrice = 0;

    use LivewireAlert;

    #[On('setDiscount')]
    public function setDiscount($id)
    {
        $this->selectedCart = Cart::find($id);
        $this->calculateDiscount();
    }

    public function updatedDiscountValue()
    {
        $this->discountValue = $this->discountValue ?: 0;
        $this->calculateDiscount();
    }

    public function updatedDiscountType()
    {
        $this->discountValue = 0;
        $this->calculateDiscount();
    }

    public function calculateDiscount()
    {
        if (!$this->selectedCart) return;

        $originalPrice = $this->selectedCart->nprice;
        $cleanDiscountValue = (int) preg_replace('/\D/', '', $this->discountValue);

        $discountAmount = $this->discountType === 'percent' 
            ? ($cleanDiscountValue / 100) * $originalPrice 
            : $cleanDiscountValue;

        $this->finalPrice = max($originalPrice - $discountAmount, 0);
    }

    public function confirmUpdateDiscount()
    {
        if ($this->selectedCart) {
            $discount = $this->selectedCart->nprice - $this->finalPrice;
            $this->selectedCart->update([
                'price' => $this->finalPrice,
                'discount' => $discount,
                'total_price' => $this->finalPrice * $this->selectedCart->qty,
            ]);

            $this->alertSuccess('Discount berhasil diperbarui.');
        }

        $this->dispatch('cart-created')->to(Table::class);
    }

    private function alertSuccess($message)
    {
        $this->alert('success', $message, [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function render()
    {
        return view('livewire.modals.edit-discount-modal');
    }
}
