<?php

namespace App\Livewire\Cashier;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class WelcomeModal extends Component
{
    public $showModal = true;

    public $nama_perusahaan;
    public $alamat;
    public $no_hp;

    use LivewireAlert;


    #[On('saveEnter')]
    public function save()
    {
        $this->validate([
            'nama_perusahaan' => 'required|string|max:255',
            'alamat' => 'required|string',
            'no_hp' => 'required|numeric',
        ]);

        try {
            DB::table('Luv2_company')->where('code', Auth::user()->company_code)->update([
                'name' => $this->nama_perusahaan,
                'address' => $this->alamat,
                'phone' => $this->no_hp,
            ]);

            Auth::user()->update([
                'greeting_status' => 'Y',
                'onboarding_step' => 'Done',
            ]);

            $this->alert('success', 'Data berhasil disimpan', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('closeModalGreetingAwal')->to(Index::class);
        } catch (\Exception $e) {
            $this->alert('error', 'Terjadi kesalahan: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }


    public function mount()
    {
        $company = DB::table('Luv2_company')->where('code', Auth::user()->company_code)->first();
        $this->nama_perusahaan = $company->name;
        $this->alamat = $company->address;
        $this->no_hp = $company->phone;
    }


    public function render()
    {
        return view('livewire.cashier.welcome-modal');
    }
}
