<?php

namespace App\Livewire\Cashier;

use App\Livewire\Forms\CartForm;
use App\Models\Cart;
use App\Models\ItemPrice;
use App\Models\Sales;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;
use Livewire\Attributes\On;

class Table extends Component
{
    use LivewireAlert;

    public $selectedSales = null;
    public $isSalesModalVisible = false;
    public $isDropdownVisible = false;
    public $isDropdownsalesVisible = false;
    public $searchsales = "";
    public $modalOpen = false;
    public $isSuggestion = false;
    public $suggestionName;
    public $suggestion = [];
    public $sales = [];
    public $isCarts = [];
    public $selectedCode;
    public $selectedIndex;
    public $refreshKey = 0;
    public $unit = [];
    public $selectedNegara = [];
    public $usia;
    public $gender = 'Man';
    public $description = '';
    public $keterangan = [];
    public $lihat = true;
    public $coba = false;
    public $isDisabledSales = false;
    public $isEnabledEditDiscount = false;
    public $isEnabledEditPrice = false;
    public $isEnabledMinusTransaction = false;
    public $isEnabledService = false;
    public $harga = 0;
    public $selectedCart = null;
    public $discountType = 'percent';
    public $discountValue = 0;
    public $finalPrice = 0;

    public CartForm $form;


    #[On('cart-created')]
    public function updateCart() {}
    #[On('selectedSalesChangedAfterModal')]
    public function updatedSearchsalesafterModal($selectedSales)
    {
        $this->searchsales = $selectedSales['name'];
    }
    #[On('selectedSalesChanged')]
    public function updateSelectedSales($selectedSales)
    {
        $this->selectedSales = $selectedSales;
    }

    #[On('selectedSalesafterInvoice')]
    public function updatedSelectedSales()
    {
        $this->selectedSales = null;
        $this->searchsales = "";
    }

    public function deleteLatestCart()
    {
        $latestCart = Cart::latest()->first();

        if ($latestCart) {
            $latestCart->delete();
        }
        $this->dispatch('updatePrice');
    }

    #[On('reRender')]
    public function refreshKey()
    {
        $this->refreshKey++;
    }

    public function render()
    {
        $sales = [];
        $carts = [];
        $user = Auth::user();
        if (strlen($this->searchsales) >= 1) {
            $sales = DB::table('Luv2_salesemp')->where('company_code', auth()->user()->company_code)->where('name', 'ILIKE', '%' . $this->searchsales . '%')->limit(10)->get();
            $this->sales = $sales;
        }
        $cartData = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')
            ->orderBy('linenum', 'desc')
            ->orderBy('grouping', 'desc')
            ->orderBy('promo', 'desc')
            ->orderBy('pack', 'asc')
            ->get();
        $lostSale = Cart::where('user_code', $user->code)
            ->where('lostsale', 'Y')
            ->select('Luv2_carts.*')
            ->addSelect([
                'total_qty' => DB::table('Luv2_item_trans')
                    ->where('company_code', auth()->user()->company_code)
                    ->where('whs_code', auth()->user()->whs_code)
                    ->selectRaw('SUM(qty)')
                    ->whereColumn('Luv2_item_trans.item_code', 'Luv2_carts.code')
                    ->groupBy('Luv2_item_trans.item_code')
            ])
            ->orderBy('grouping', 'desc')
            ->orderBy('promo', 'desc')
            ->orderBy('pack', 'asc')
            ->get();

        foreach ($cartData as $cart) {
            $promptPacks = DB::table('Luv2_promo_item')
                ->where('no', $cart->promo)
                ->where('item_code', $cart->code)
                ->pluck('pack')
                ->toArray();

            if ($promptPacks) {
                $maxPack = max($promptPacks);
                if ($cart->pack < $maxPack) {
                    $maxpack = 'N';
                } else {
                    $maxpack = 'Y';
                }
            } else {
                $maxpack = 'Y';
            }
            $data = DB::table('Luv2_item_unit as iuu')
                ->where('iuu.whs_code', auth()->user()->whs_code)
                ->where('iuu.company_code', auth()->user()->company_code)
                ->join('Luv2_unit as uu', 'iuu.id_unit', '=', 'uu.id')
                ->where('uu.company_code', auth()->user()->company_code)
                ->select('uu.*', 'iuu.qty', 'iuu.pricebuy', 'iuu.pricesell')
                ->where('iuu.item_code', $cart->code)
                ->get();

            // dd($data);
            $carts[] = [
                'id' => $cart->id,
                'code' => $cart->code,
                'name' => $cart->name,
                'price' => $cart->price,
                'qty' => $cart->qty,
                'created_at' => $cart->created_at,
                'updated_at' => $cart->updated_at,
                'total_price' => $cart->total_price,
                'id_member' => $cart->id_member,
                'id_sales' => $cart->id_sales,
                'user_code' => $cart->user_code,
                'id_item' => $cart->id_item,
                'nprice' => $cart->nprice,
                'discount' => $cart->discount,
                'barcode' => $cart->barcode,
                'sandbox' => $cart->sandbox,
                'promo' => $cart->promo,
                'promo_tipe' => $cart->promo_tipe,
                'pack' => $cart->pack,
                'benefit' => $cart->benefit,
                'maxpack' => $maxpack,
                'unitforselect' => $data->first()->id ?? null,
                'unitnameforselect' => $data->first()->name ?? null,
                'unit' => $cart->unit,
                'unit_name' => $cart->unit_name,
                'qty_unit' => $cart->qty_unit,
                'units' => $data
            ];
        }

        $this->isCarts = $carts;
        $negara = DB::table('Luv2_country')
            ->leftJoin('Luv2_customerorigin', function ($join) {
                $join->on('Luv2_country.id', '=', 'Luv2_customerorigin.id_negara')
                    ->where('Luv2_customerorigin.company_code', auth()->user()->company_code)
                    ->where('Luv2_customerorigin.whs_code', auth()->user()->whs_code);
            })
            ->select(
                'Luv2_country.*',
                DB::raw('COUNT("Luv2_customerorigin".id) as total_customers')
            )
            ->groupBy('Luv2_country.id', 'Luv2_country.name', 'Luv2_country.code')
            ->orderBy('total_customers', 'desc')
            ->get();

        return view('livewire.cashier.table', [
            'carts' => $carts,
            'sales' => $sales,
            'carttotal' => Cart::where('user_code', $user->code)
                ->where('lostsale', 'N')
                ->get(),
            'lostSale' => $lostSale,
            'negara' => $negara,
        ]);
    }

    // public function updatedUnit($value, $key)
    // {
    //     dd('Unit changed'); // Debug to ensure the method is called
    //     $cartItem = $this->isCarts[$key];
    //     $cart = Cart::where('id', $cartItem['id'])->first();
    //     $unit = DB::table('Luv2_unit')->where('id', $value)->first();

    //     if ($cart) {
    //         $cart->unit = $unit->id ?? 0;
    //         $cart->qty_unit = $cart->qty ?? 0;
    //         $cart->save();

    //         // Optionally, update the local state if needed
    //         $this->isCarts[$key]['unit'] = $unit->id ?? 0;
    //         $this->isCarts[$key]['qty_unit'] = $cart->qty ?? 0;
    //     }
    // }
    public function handleUnitChange($key, $value)
    {
        // dd($key, $value);
        $cartItem = $this->isCarts[$key];
        $cart = Cart::where('id', $cartItem['id'])->first();
        if ($cart) {
            $cart->unit = $value;
            $cart->qty_unit = 1;
            $unititem = DB::table('Luv2_item_unit')->where('item_code', $cart->code)->where('company_code', auth()->user()->company_code)->where('id_unit', $value)
                ->where('whs_code', auth()->user()->whs_code)
                ->first();

            // if($unititem){
            if ($cart->unit != 0) {
                $cart->qty = 1 * $unititem->qty;
                $item = DB::table('Luv2_item')->where('code', $cart->code)->where('company_code', auth()->user()->company_code)->first();
                $isConsignment = $item->consignment === 'Y';
                if ($isConsignment) {
                    $supplier = DB::table('Luv2_supplier')->where('code', $item->supp_code)->first();
                    $sharedMargin = $supplier->shared_margin ?? 0;
                    $cost = ($unititem->pricesell * ((100 - $sharedMargin) / 100)) * $cart->qty_unit;
                    $cart->shared_margin = $sharedMargin;
                    $cart->consignment = $item->consignment;
                    $cart->cost = $cost;
                } else {
                    $sharedMargin = 0;
                    $cart->cost = $item->avgprice * $cart->qty;
                }
                $cart->total_price = $unititem->pricesell;
            } else {
                if ($unititem) {
                    $cart->qty = 1 * $unititem->qty;
                } else {
                    $cart->qty = 1 * 1;
                }

                $item = DB::table('Luv2_item')->where('code', $cart->code)->where('company_code', auth()->user()->company_code)->first();
                $isConsignment = $item->consignment === 'Y';
                if ($isConsignment) {
                    $supplier = DB::table('Luv2_supplier')->where('code', $item->supp_code)->first();
                    $sharedMargin = $supplier->shared_margin ?? 0;
                    $cost = ($cart->price * ((100 - $sharedMargin) / 100)) * $cart->qty;
                    $cart->shared_margin = $sharedMargin;
                    $cart->consignment = $item->consignment;
                    $cart->cost = $cost;
                } else {
                    $sharedMargin = 0;
                    $cart->cost = $item->avgprice * $cart->qty;
                }
                $cart->total_price = $cart->price * $cart->qty;
            }

            $cart->save();

            $this->isCarts[$key]['unit'] = $value;
            $this->isCarts[$key]['qty_unit'] = $cart->qty ?? 0;
            // }else{
            //     $this->isCarts[$key]['unit'] = 0;
            //     $this->alert('info', 'That unit not set on this item yet', [
            //         'position' => 'top',
            //         'timer' => 3000,
            //         'toast' => true,
            //         'timerProgressBar' => true,
            //     ]);
            // }


        }

        $this->dispatch('updatePrice');
    }

    public function sameCart($cartId, $qty)
    {
        $cart = Cart::find($cartId);
        $sessionmember = session('discountmemb');
        $memberId = $cart->member_id;
        $now = now();
        $user = Auth::user();
        $wh = DB::table('Luv2_warehouse')->where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();

        $pricelist = $wh->pricelist_code;

        if ($cart) {
            if ($cart->unit != 0 || $cart->unit != '0') {
                $unit = DB::table('Luv2_item_unit')->where('item_code', $cart->code)->where('company_code', auth()->user()->company_code)->where('id_unit', $cart->unit)
                    ->where('whs_code', auth()->user()->whs_code)
                    ->first();

                $qtypcs = $unit->qty * $qty;
                $item = DB::table('Luv2_item')->where('code', $cart->code)->where('company_code', auth()->user()->company_code)->first();
                $isConsignment = $item->consignment === 'Y';
                if ($isConsignment) {
                    $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                    $sharedMargin = $supplier->shared_margin ?? 0;
                    $cost = ($cart->price * ((100 - $sharedMargin) / 100)) * $qtypcs;
                } else {
                    $sharedMargin = 0;
                    $cost = $item->avgprice * $qtypcs;
                }
                $cart->update([
                    'qty' => $qtypcs,
                    'qty_unit' => $qty,
                    'total_price' => $unit->pricesell * $qty,
                    'cost' => $cost,
                    'consignment' => $item->consignment,
                    'shared_margin' => $sharedMargin,
                ]);
            } else {
                $item = DB::table('Luv2_item')->where('code', $cart->code)->where('company_code', auth()->user()->company_code)->first();
                $isConsignment = $item->consignment === 'Y';
                if ($isConsignment) {
                    $supplier = DB::table('Luv2_supplier')->where('code', $item->supp_code)->first();
                    $sharedMargin = $supplier->shared_margin ?? 0;
                    $cost = $cart->price * ((100 - $sharedMargin) / 100) * $qty;
                } else {
                    $sharedMargin = 0;
                    $cost = $item->avgprice * $qty;
                }
                $cart->update([
                    'qty' => $qty,
                    'total_price' => $cart->price * $qty,
                    'cost' => $cost,
                    'consignment' => $item->consignment,
                    'shared_margin' => $sharedMargin,
                ]);
                $itemPriceDiscounts = DB::table('Luv2_promo_item_qty')
                    ->where('company_code', $user->company_code)
                    ->where('no', $cart->promo)
                    ->where('item_code', $cart->code)
                    ->orderBy('qty', 'asc')
                    ->get();

                $pricedisc = DB::table('Luv2_promo_item')
                    ->where('company_code', $user->company_code)
                    ->where('no', $cart->promo)
                    ->where('item_code', $cart->code)
                    ->first();
                if ($qty == 1) {
                    $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $cart->code)->where('pricelist_code', $pricelist)->first();
                    $price = $prices->price;
                    if ($pricedisc) {
                        if ($cart->promo_tipe == 1) {
                            $disc = $pricedisc->disc / 100;
                            $valuedisc = $cart->nprice * $disc;
                            $price = $cart->nprice - $valuedisc;
                        } else {
                            $price = $cart->nprice;
                        }
                    }
                    if ($isConsignment) {
                        $cost = $price * ((100 - $sharedMargin) / 100) * $qty;
                    } else {
                        $cost = $price * $qty;
                    }
                    $cart->update([
                        'price' => $price,
                        'qty' => $qty,
                        'total_price' => $price * $qty,
                        'discount' => 0,
                        'cost' => $cost
                    ]);
                } else {
                    $price = $cart->price;
                    $valuedisc = $cart->discount;
                    foreach ($itemPriceDiscounts as $itemPriceDiscount) {
                        if ($itemPriceDiscount->qty <= $qty) {

                            if ($cart->promo_tipe == 1) {
                                $disc = $itemPriceDiscount->disc / 100;
                                $valuedisc = $cart->nprice * $disc;
                                $price = $cart->nprice - $valuedisc;
                            } else {
                                $valuedisc = $cart->nprice - $itemPriceDiscount->disc_price;
                                $price = $itemPriceDiscount->disc_price;
                            }
                        }
                        if ($isConsignment) {
                            $cost = $price * ((100 - $sharedMargin) / 100) * $qty;
                        } else {
                            $cost = $price * $qty;
                        }
                        $cart->update([
                            'price' => $price,
                            'qty' => $qty,
                            'total_price' => $price * $qty,
                            'discount' => $valuedisc,
                            'cost' => $cost
                        ]);
                    }
                }
            }
        }

        $this->dispatch('updatePrice');
    }

    public function deleteCart($cartId)
    {
        $cart = Cart::findOrFail($cartId);

        if ($cart) {
            $cart->delete();
            if (session()->has('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id) || session()->has('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id) || session()->has('Promo-Voucher-ValueFulfil' . auth()->user()->id)) {
                $this->dispatch('checkCartValueafterDelete')->to(Transaction::class);
            }
            if (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
                $this->dispatch('checkCartValueafterDeleteBundling')->to(Transaction::class);
            }
            if ($cart->promo != 0) {
                $this->dispatch('checkPriceBundle', $cart)->to(Transaction::class);
                $countcarts = Cart::count();
                $cartforsuggestion = Cart::orderBy('created_at', 'asc')->first();
                if ($countcarts >= 1) {
                    $this->dispatch('suggestion', $cartforsuggestion->promo, $cartforsuggestion->promo_tipe)->to(Transaction::class);
                }
            }

            $countcarts = Cart::where('user_code', auth()->user()->code)->count();
            if ($countcarts == 0) {
                $this->dispatch(event: 'redirectToRefresh');
            }
        }
        $this->dispatch('updatePrice');
    }

    public function createInvoice()
    {
        $this->modalOpen = true;
        $this->dispatch('modalInvoiceOpenorClose', $this->modalOpen)->to(Transaction::class);
        $this->dispatch('createInvoice');
    }

    #[On('toCloseModalInvoice')]
    public function closeModalInvoice()
    {
        $this->modalOpen = false;
    }

    #[On('modalOpen')]
    public function modalOpenStatus($value)
    {
        $this->modalOpen = $value;
    }

    public function salesModal()
    {
        $this->isSalesModalVisible = true;
        $this->dispatch('salesModal', $this->isSalesModalVisible);
    }

    public function selectSalesByClick($salesCode)
    {

        $sales = Sales::where('code', $salesCode)
            ->where('active', 'Y')
            ->first();

        if ($sales) {

            $this->searchsales = $sales->name;
            $this->selectedSales = $sales;
            $this->form->sales = $sales->code;

            $this->dispatch('selectedSalesChanged', $this->selectedSales);
            $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(Invoice::class);
            $this->isDropdownsalesVisible = false; // Close the dropdown
            $this->alert('info', 'Sales: ' . $sales->name, [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
    public function updatedSearchsales()
    {
        $this->selectedSales = null; // Clear the selected product when the search field changes
        $this->dispatch('selectedSalesChanged', $this->selectedSales);
        $this->isDropdownsalesVisible = (strlen($this->searchsales) >= 1);
    }

    public function refresh() {}

    #[On('suggestionToTable')]
    public function suggestion($isSuggestion, $suggestionName, $suggestion)
    {
        $this->refresh();

        // dd($isSuggestion, $suggestionName, $suggestion);
        $this->isSuggestion = $isSuggestion;
        $this->suggestionName = $suggestionName;
        $this->suggestion = $suggestion;
    }

    public function addSuggestion($itemCode)
    {
        $this->dispatch('addSuggestion', $itemCode)->to(Transaction::class);
    }

    public function addSuggestionFirst($itemCode)
    {
        $this->dispatch('addSuggestionFirst', $itemCode)->to(Transaction::class);
    }

    public function selectSales($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->sales[$index]->code;

        $sales = Sales::where('code', $this->selectedCode)
            ->where('active', 'Y')
            ->first();

        if ($sales) {

            $this->searchsales = $sales->name;
            $this->selectedSales = $sales;
            $this->form->sales = $sales->code;

            $this->dispatch('selectedSalesChanged', $this->selectedSales);
            $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(Invoice::class);
            $this->isDropdownsalesVisible = false; // Close the dropdown
            // Clear selectedCode and selectedIndex
            $this->selectedCode = null;
            $this->selectedIndex = null;
            $this->alert('info', 'Sales: ' . $sales->name, [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('closeSalesModal')]
    public function closeSalesModalDispatch($isSalesModalVisible)
    {
        $this->isSalesModalVisible = $isSalesModalVisible;
    }

    #[On('closeSalesModalIndex')]
    public function closeSalesModalIndexDispatch($isSalesModalVisible)
    {
        $this->isSalesModalVisible = $isSalesModalVisible;
    }

    public function cartEmpty()
    {
        $this->alert('info', 'Cart is empty, please add at least 1 item !', [
            'position' => 'top',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function moveToLoseSale($id)
    {
        $user = Auth::user();
        $data = Cart::where('id', $id)
            ->where('user_code', $user->code)
            ->first();
        if ($data) {
            $data->lostsale = 'Y';
            $data->save();
            $this->searchsales = '';
            $this->selectedSales = null;
        }

        $this->dispatch('showCanvas');
    }

    public function moveToCart($id)
    {
        $user = Auth::user();
        $data = Cart::where('id', $id)
            ->where('user_code', $user->code)
            ->first();
        if ($data) {
            $data->lostsale = 'N';
            $data->save();
            $this->searchsales = '';
            $this->selectedSales = null;
        }

        $this->dispatch('showCanvas');
    }

    public function saveLostSale()
    {
        DB::beginTransaction();

        try {
            $data = Cart::where('user_code', Auth::user()->code)
                ->where('company_code', auth()->user()->company_code)
                ->where('whs_code', auth()->user()->whs_code)
                ->where('lostsale', 'Y')
                ->select('Luv2_carts.*')
                ->addSelect([
                    'total_qty' => DB::table('Luv2_item_trans')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('whs_code', auth()->user()->whs_code)
                        ->selectRaw('SUM(qty)')
                        ->whereColumn('Luv2_item_trans.item_code', 'Luv2_carts.code')
                        ->groupBy('Luv2_item_trans.item_code')
                ])
                ->orderBy('grouping', 'desc')
                ->orderBy('promo', 'desc')
                ->orderBy('pack', 'asc')
                ->get();

            if ($data) {
                foreach ($data as $item) {
                    if (isset($this->keterangan[$item->id])) {
                        $item->update(['keterangan' => $this->keterangan[$item->id]]);
                    } else {
                        if ($item->total_qty > 0) {
                            $item->update(['keterangan' => 'Missing stock']);
                        } else {
                            $item->update(['keterangan' => 'Lost sale']);
                        }
                    }

                    DB::table('Luv2_lostsale')->insert([
                        'whs_code' => auth()->user()->whs_code,
                        'company_code' => auth()->user()->company_code,
                        'barcode' => $item->barcode,
                        'code' => $item->code,
                        'name' => $item->name,
                        'keterangan' => $item->keterangan,
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                        'date' => Carbon::now()->format('Y-m-d')
                    ]);
                }
            }

            if ($this->selectedNegara != null && $this->usia != null) {
                DB::table('Luv2_customerorigin')->insert([
                    'invoice' => null,
                    'id_negara' => $this->selectedNegara[0]['id'],
                    'usia' => '-+' . $this->usia,
                    'gender' => $this->gender,
                    'belanja' => 'N',
                    'lihat' => ($this->lihat) ? 'Y' : 'N',
                    'coba' => ($this->coba) ? 'Y' : 'N',
                    'keterangan' => ucfirst($this->description),
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'company_code' => auth()->user()->company_code,
                    'whs_code' => auth()->user()->whs_code,
                ]);
                $this->dispatch('successOrigin');
            }

            Cart::where('user_code', Auth::user()->code)
                ->where('company_code', auth()->user()->company_code)
                ->where('whs_code', auth()->user()->whs_code)
                ->where('lostsale', 'Y')
                ->delete();
            DB::commit();
            $this->dispatch('hideCanvas');
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
    }

    #[On('successNotification')]
    public function successNotification()
    {
        $this->alert('success', 'Data berhasil disimpan', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    #[On('successOrigin')]
    public function aftersaveOrigin()
    {
        $this->selectedNegara = [];
        $this->usia = null;
        $this->gender = null;
        $this->lihat = true;
        $this->coba = false;
        $this->description = null;
    }

    public function setHarga($id)
    {
        $cart = Cart::where('id', $id)
            ->where('user_code', auth()->user()->code)
            ->first();
        $harga = $cart->nprice;
        $this->selectedCart = $cart;
        $this->harga = $harga;
    }

    public function confirmUpdatePrice($value)
    {
        if ($value === 'N') {
            if ($this->selectedCart) {
                $this->selectedCart->update([
                    'nprice' => $this->harga,
                    'price' => $this->harga,
                    'total_price' => $this->harga * $this->selectedCart->qty,
                ]);
            }

            $this->alert('success', 'Harga berhasil dirubah', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } elseif ($value === 'Y') {
            $user = Auth::user();
            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $getpricelist = DB::table('Luv2_pricelist')->where('code', $whs->pricelist_code)->first();
            $pricelist = $getpricelist->code;
            if ($this->selectedCart) {
                $this->selectedCart->update([
                    'nprice' => $this->harga,
                    'price' => $this->harga,
                    'total_price' => $this->harga * $this->selectedCart->qty,
                ]);
            }

            $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $this->selectedCart->code)->where('pricelist_code', $pricelist)->first();
            if ($prices) {
                $prices->update([
                    'price' => $this->harga,
                ]);
            }

            $this->alert('success', 'Harga berhasil dirubah di database', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch('updatePrice');
    }

    public function setDiscount($cartId)
    {
        $this->selectedCart = \App\Models\Cart::find($cartId);
        $this->calculateDiscount();
    }

    public function updatedDiscountValue()
    {
        if ($this->discountValue == null) {
            $this->discountValue = 0;
        }
        $this->calculateDiscount();
    }

    public function updatedDiscountType()
    {
        $this->discountValue = 0;
        $this->calculateDiscount();
    }

    public function calculateDiscount()
    {
        if (!$this->selectedCart) return;

        $originalPrice = $this->selectedCart->nprice;

        $cleanDiscountValue = preg_replace('/\D/', '', $this->discountValue);
        $cleanDiscountValue = $cleanDiscountValue !== '' ? (int) $cleanDiscountValue : 0;

        if ($this->discountType === 'percent') {
            $discountAmount = ($cleanDiscountValue / 100) * $originalPrice;
        } else {
            $discountAmount = $cleanDiscountValue;
        }

        $this->finalPrice = max($originalPrice - $discountAmount, 0);
    }

    public function confirmUpdateDiscount()
    {
        if ($this->selectedCart) {
            $discount = $this->harga - $this->finalPrice;
            $this->selectedCart->update([
                'price' => $this->finalPrice,
                'discount' => $discount,
                'total_price' => $this->finalPrice * $this->selectedCart->qty,
            ]);
        }

        $this->alert('success', 'Discount berhasil dirubah', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);


        $this->dispatch('updatePrice');
    }

    public function modalCreateSales()
    {
        $this->dispatch('openModalCreateSales');
        $this->selectedSales = null;
        $this->searchsales = "";
        $this->isDropdownsalesVisible = false;
    }

    public function closeModalTutorial()
    {
        DB::table('Luv2_tutorial')
            ->where('id_user', Auth::user()->id)
            ->where('menu', 'Tutorial')
            ->where('active', 'Y')
            ->update(['active' => 'N']);
       
    }

    public function mount()
    {

        $user = Auth::user();
        $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
        $sales = $company->salesemployee;
        $discount = $company->editdiscount;
        $price = $company->editprice;
        $minustransaction = $company->minus_transaction;
        $service = $company->service;

        $tutorial = DB::table('Luv2_tutorial')->where('id_user', $user->id)->where('menu', 'Tutorial')->where('active', 'Y')->first();
        if ($tutorial) {
            $this->dispatch('openModalTutorial');
        }

        if ($sales === 'N') {
            $this->isDisabledSales = true;
        }
        if ($discount === 'Y') {
            $this->isEnabledEditDiscount = true;
        }
        if ($price === 'Y') {
            $this->isEnabledEditPrice = true;
        }
        if ($minustransaction === 'Y') {
            $this->isEnabledMinusTransaction = true;
        }
        if ($service === 'Y') {
            $this->isEnabledService = true;
        }
    }
}
