<?php

namespace App\Livewire\Cashier;

use App\Mail\SandboxMail;
use App\Models\Cart;
use App\Models\DetailInvoice;
use App\Models\Invoice as ModelsInvoice;
use App\Models\Item;
use App\Models\ItemTrans;
use App\Models\Member;
use App\Models\SandboxItem;
use App\Models\Settings;
use App\Models\User;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\Attributes\Rule;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;
use Illuminate\Support\Str;

class Invoice extends Component
{

    use LivewireAlert;

    public $payment = null;
    public $totalAmount = 0;
    public $change = 0;
    public $transfer = 0;
    public $type;
    public $cash;
    public $namaBank;
    public $namaPemegangKartu;
    public $selectedSales = null;
    public $cashier;
    public $invoice;
    public $storeitem = [];
    public $modalOpen = false;
    public $cashfulfil = false;
    public $paymentfulfil = false;
    public $random;
    public $searchvoucher = '';
    public $isCashback = false;
    public $voucherCashback;
    public $message;
    public $refreshKey = 0;
    public $voucherApplied = false;
    public $selectedNegara = [];
    public $usia;
    public $gender = 'Man';
    public $serviceAmount = 0;
    public $totalWithService = 0;
    public $company;
    public $customServicePercent = null;
    public $isEnableService = false;

    #[Rule('required', message: 'The payment option is required.')]
    public $paymentOption = 'cash';

    #[Rule('min:4', message: 'Nomor Kartu must be 4 digits.')]
    #[Rule('max:4', message: 'Nomor Kartu must be 4 digits.')]
    public $nomorKartu;

    #[On('updatePrice')]
    public function updatePrice()
    {
        $carts = Cart::where('user_code', auth()->user()->code)->get();
        if ($carts->count() < 1) {
            $this->clearSession();
        }
    }

    #[On('afterProduct')]
    public function updateAfterProduct()
    {
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)->get();
        $this->totalAmount = $carts->sum('total_price');
    }

    #[On('outofstock')]
    public function outOfStock()
    {
        $this->alert('error', 'Tidak ada stock untuk barang ini', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function updatedpaymentOption()
    {
        $this->dispatch('updatedPaymentOption');
    }

    public function clearses()
    {
        session()->forget('Promo-GWP-ValueCheapest' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id);
        session()->forget('Promo-Voucher-ValueFulfil' . auth()->user()->id);
        session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
        session()->forget('Promo-Voucher-Value' . auth()->user()->id);
    }

    #[On('selectedSalesChanged')]
    public function updateSelectedSales($selectedSales)
    {
        $this->selectedSales = $selectedSales;
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $this->totalAmount = $carts->sum('total_price');
    }

    #[On('skipSales')]
    public function skipSales()
    {
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $this->totalAmount = $carts->sum('total_price');
    }

    public function mount()
    {
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $this->totalAmount = $carts->sum('total_price');

        // Get company settings and calculate service amount if enabled
        $this->company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
        $this->isEnableService = ($this->company && $this->company->service === 'Y');
        if ($this->isEnableService) {
            $servicePercent = floatval($this->company->nservice);
            if ($servicePercent < 0 || $servicePercent === '') {
                $servicePercent = 0;
            }
            $this->customServicePercent = $servicePercent;
            $this->calculateServiceAmount();
        } else {
            $this->totalWithService = $this->totalAmount;
        }
    }

    public function calculateServiceAmount()
    {
        if ($this->customServicePercent !== null) {
            $servicePercent = floatval($this->customServicePercent);
            if ($servicePercent < 0 || $servicePercent === '') {
                $servicePercent = 0;
            }
            $this->serviceAmount = $this->totalAmount * ($servicePercent / 100);
            $this->totalWithService = $this->totalAmount + $this->serviceAmount;
        }
    }

    public function updatedCustomServicePercent()
    {
        if ($this->customServicePercent === '' || floatval($this->customServicePercent) < 0) {
            $this->customServicePercent = 0;
        }
        $this->calculateServiceAmount();
    }

    public function save()
    {
        try {
            // Check stock for each item first
            $user = Auth::user();
            $carts = Cart::where('user_code', $user->code)
                ->where('lostsale', 'N')
                ->latest()
                ->get();
            $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
            $minusTransaction = $company->minus_transaction;
            if ($minusTransaction == 'N') {
                foreach ($carts as $cart) {
                    $itemTrans = DB::table('Luv2_item_trans')
                        ->where('company_code', $user->company_code)
                        ->where('whs_code', $user->whs_code)
                        ->where('item_code', $cart->code)
                        ->sum('qty');

                    if ($itemTrans <= 0) {
                        $this->alert('error', "Barang {$cart->name} stock sudah habis", [
                            'position' => 'top-end',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                        return;
                    }
                }
            }

            // Validate payment amount
            $paymentWithoutDots = str_replace('.', '', $this->payment);
            $paymentFloat = (float) $paymentWithoutDots;

            $requiredAmount = $this->isEnableService ? $this->totalWithService : $this->totalAmount;
            if ($this->paymentOption == 'cash') {
                if ($paymentFloat < $requiredAmount) {
                    $this->alert('error', 'Pembayaran harus lebih besar atau sama dengan total pembayaran', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    return;
                }
            }

            DB::beginTransaction();
            $this->change = $paymentFloat - $requiredAmount;

            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
            $pricelist = $getpricelist->code;

            $carts = Cart::where('user_code', $user->code)
                ->where('lostsale', 'N')
                ->latest()
                ->get();
            $change = $this->change;
            $payment = $paymentFloat;
            $pembayaran = $this->paymentOption;
            $idMember = session('member');

            $huruf = 'BJ';
            // Date
            $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

            // Count invoices created today
            $countinvoice = DB::table('Luv2_invoice')
                ->where('user_code', $user->code)
                ->whereDate('created_at', Carbon::today())
                ->count();
            $countinvoice += 1;

            // set max 999 to count inv
            $countinvoice = min($countinvoice, 999);
            // set default 3 digit count inv
            $countinvoice = str_pad($countinvoice, 3, '0', STR_PAD_LEFT);
            $code = $user->id;

            if ($this->paymentOption == 'card' && $this->paymentOption == 'multi') {
                $this->validate();
            }
            // No Invoice Baru
            $invoice = $huruf . $code . $tanggal . $countinvoice;
            if ($this->isEnableService) {
                $totalAmount = $this->totalWithService;
            } else {
                $totalAmount = $this->totalAmount;
            }
            $maxId = ModelsInvoice::max('id');
            $invoiceData = [
                'company_code' => $user->company_code,
                'whs_code' => $user->whs_code,
                'id' => $maxId + 1,
                'user_code' => $user->code,
                'sales_code' => $this->selectedSales ? $this->selectedSales['code'] : null,
                'member_code' => $idMember,
                'no' => $invoice,
                'payment' => ucwords($pembayaran),
                'paid' => ($pembayaran === 'card' || $pembayaran === 'multi') ? $totalAmount : ($pembayaran === 'qris' ? $totalAmount : $payment),
                'must_paid' => $totalAmount,
                'change' => ($pembayaran === 'card' || $pembayaran === 'multi') ? null : ($pembayaran === 'qris' ? null : $change),
                'date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
                'service' => $this->serviceAmount,
                'service_percent' => $this->customServicePercent,
            ];

            // dd($this->selectedSales, $invoiceData);

            if ($pembayaran === 'multi' || $pembayaran === 'card') {
                $cashWithoutDots = str_replace('.', '', $this->cash);
                $cashFloat = (float) $cashWithoutDots;
                $note = [
                    'type' => $this->type ?? 'Credit',
                    'nama_bank' => $this->namaBank,
                    'nama_pemegang_kartu' => $this->namaPemegangKartu,
                    'cash' => ($pembayaran === 'multi') ? $cashWithoutDots : null,
                    'transfer' => ($pembayaran === 'multi') ? ($totalAmount - $cashFloat) : ($pembayaran === 'card' ? $totalAmount : null),
                    'nomor_kartu' => $this->nomorKartu,
                ];

                $invoiceData['note'] = json_encode($note);
            }
            if (session()->has('Promo-Voucher-QTY' . auth()->user()->id) || session()->has('Promo-Voucher-ValueFulfil' . auth()->user()->id)) {
                $this->randomVoc();
                $now = Carbon::now();
                $formattedDateTime = $now->format('ymdHis');
                $promo = DB::table('Luv2_promo')
                    ->where('deleted', 'N')
                    ->where(function ($query) {
                        $query->where('no', session('Promo-Voucher-QTY' . auth()->user()->id))
                            ->orWhere('no', session('Promo-Voucher-Value' . auth()->user()->id));
                    })
                    ->first();
                // Insert the record into the 'Luv2_promo' table
                DB::table('Luv2_promo')->insert([
                    'no' => $formattedDateTime,
                    'pricelist_code' => $pricelist,
                    'name' => 'Voucher Cashback ( ' . $promo->no . ' )',
                    'from_date' => $promo->voucher_from_date,
                    'to_date' => $promo->voucher_to_date,
                    'company_code' => $user->company_code,
                    'date' => $now,
                    'voucher_from_date' => $promo->voucher_from_date,
                    'voucher_to_date' => $promo->voucher_to_date,
                    'voucher' => $promo->voucher,
                    'invoice' => $invoiceData['no'],
                    'tipe' => 6,
                ]);
                DB::table('Luv2_promo_voucher')->insert([
                    'no' => $formattedDateTime,
                    'company_code' => $user->company_code,
                    'voucher' => $this->random,
                    'value' => $promo->voucher,
                ]);
            }

            ModelsInvoice::create($invoiceData);
            $invoice = ModelsInvoice::where('no', $invoiceData['no'])->first();
            $cashier = User::where('code', $invoice->user_code)->first();
            $this->invoice = $invoice;
            $this->cashier = $cashier;
            $selectedSales = $this->selectedSales;
            $totalSubtotal = 0;
            $totalDiscount = 0;
            $totalQty = 0;

            foreach ($carts as $cart) {
                $item = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $cart->code)->first();
                if ($item->consignment === 'Y') {
                    $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                    $sharedMargin = $supplier->shared_margin ?? 0;
                    $cost = ($cart->price * ((100 - $sharedMargin) / 100)) * $cart->qty;
                } else {
                    $sharedMargin = 0;
                    $item = DB::table('Luv2_item')->where('company_code', $cart->company_code)->where('code', $cart->code)->first();
                    $cost = $item->avgprice * $cart->qty;
                }
                $saveData = [
                    'company_code' => $user->company_code,
                    'no' => $invoice->no,
                    'whs_code' => $user->whs_code,
                    'code' => $cart->code,
                    'barcode' => $cart->barcode,
                    'name' => $cart->name,
                    'price' => $cart->price,
                    'nprice' => $cart->nprice,
                    'qty' => $cart->qty,
                    'disc' => $cart->discount,
                    'total_price' => $cart->total_price,
                    'sandbox' => $cart->sandbox,
                    'linenum' => $cart->linenum,
                    'promo' => $cart->promo,
                    'promo_tipe' => $cart->promo_tipe,
                    'pack' => $cart->pack,
                    'sales_code' => $selectedSales ? $selectedSales['code'] : null,
                    'user_code' => $user->code,
                    'member_code' => $idMember,
                    'benefit' => $cart->benefit,
                    'status' => 0,
                    'unit' => $cart->unit,
                    'qty_unit' => $cart->qty_unit,
                    'consignment' => $cart->consignment,
                    'cost' => $cost,
                    'shared_margin' => $sharedMargin,
                    'created_at' => $cart->created_at,
                    'updated_at' => $cart->updated_at
                ];
                // Calculate and add subtotal for each item
                if ($cart->unit != 0) {
                    $unititem = DB::table('Luv2_item_unit')->where('item_code', $cart->code)->where('company_code', auth()->user()->company_code)->where('id_unit', $cart->unit)
                        ->where('whs_code', auth()->user()->whs_code)->first();
                    $subtotal = $unititem->pricesell * $cart->qty_unit;
                } else {
                    $subtotal = $cart->nprice * $cart->qty;
                }
                $totalSubtotal += $subtotal;

                // Calculate and add discount for each item
                $discount = ($cart->nprice - $cart->price) * $cart->qty;
                $totalDiscount += $discount;

                // Calculate and add qty for each item
                $qty = $cart->qty > 0 ? $cart->qty : 0;
                $totalQty += $qty;

                DetailInvoice::insert($saveData);
            }
            $description = 'Beli ';
            foreach ($carts as $key => $cart) {
                $user = Auth::user();
                $item = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $cart->code)->first();
                if ($key == $carts->count() - 1 && $key > 0) {
                    $description .= "dan {$cart->qty} {$cart->name}";
                } else {
                    $description .= "{$cart->qty} {$cart->name}";
                }
                if ($key < $carts->count() - 1) {
                    $description .= ', ';
                }
                if ($item) {
                    $transData = [
                        'no_trans' => $invoice->no,
                        'whs_code' => $user->whs_code,
                        'company_code' => $user->company_code,
                        'linenum' => $cart->linenum + 1,
                        'item_code' => $cart->code,
                        'tipe' => '4',
                        'date' => Carbon::now(),
                        'qty' => -$cart->qty,
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                        'linenum' => $key, // Assuming linenum starts from 1
                    ];
                    // ItemTrans::insert($transData);
                }
            }


            if ($this->selectedNegara != null && $this->usia != null && $this->gender != null) {
                DB::table('Luv2_customerorigin')->insert([
                    'invoice' => $invoice->no,
                    'id_negara' => $this->selectedNegara[0]['id'],
                    'usia' => '-+' . $this->usia,
                    'gender' => $this->gender,
                    'belanja' => 'Y',
                    'lihat' => 'N',
                    'coba' => 'N',
                    'keterangan' => $description,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                    'company_code' => auth()->user()->company_code,
                    'whs_code' => auth()->user()->whs_code,
                ]);
            }

            if ($this->isCashback) {
                $invoice->update([
                    'cashback' => $this->voucherCashback->voucher_code,
                    'subtotal' => $totalSubtotal,
                    'disc_total' => $totalDiscount,
                    'sales_code' => $saveData['sales_code'],
                    'total_qty' => $totalQty,
                    'sandbox' => $invoice->detailInvoices()->where('sandbox', 'Y')->exists() ? 'Y' : 'N',
                ]);

                //update voucher terpakai
                DB::table('Luv2_promo_voucher')
                    ->where('voucher', $this->voucherCashback->voucher_code)
                    ->update([
                        'used' => 'Y',
                    ]);
            } else {
                $invoice->update([
                    'subtotal' => $totalSubtotal,
                    'disc_total' => $totalDiscount,
                    'sales_code' => $saveData['sales_code'],
                    'total_qty' => $totalQty,
                    'sandbox' => $invoice->detailInvoices()->where('sandbox', 'Y')->exists() ? 'Y' : 'N',
                ]);
            }

            $datainvoice = DetailInvoice::where('no', $invoiceData['no'])
                ->orderBy('promo', 'desc')
                ->orderBy('created_at', 'asc')
                ->orderBy('pack', 'asc')
                ->get();

            $this->storeitem = $datainvoice;
            if ($invoice->sandbox == 'Y') {
                $sandboxInvoices = $invoice->detailInvoices()->where('sandbox', 'Y')->get();
                $this->storeitem = $datainvoice;
                try {
                    $user = Auth::user();
                    $warehouse = Warehouse::where('code', $user->whs_code)->first();
                    $emails = $warehouse->email;

                    Mail::to($emails)->send(new SandboxMail($sandboxInvoices));
                    foreach ($sandboxInvoices as $sbx) {
                        $sandboxitem = SandboxItem::where('code', $sbx->code)
                            ->where('company_code', auth()->user()->company_code)->first();
                        if ($sandboxitem) {
                            $sandboxitem->delete();
                        }
                    }
                    $this->alert('success', 'Mail Sandbox Sent Succesfully', [
                        'position' => 'top',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } catch (\Throwable $th) {
                    $this->alert('warning', 'Email Sandbox Failed to Send', [
                        'position' => 'top',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            }


            Cart::truncate();

            $this->dispatch('cart-created');
            $this->dispatch('closePayment');
            $this->dispatch('selectedSalesafterInvoice')->to(Transaction::class);
            $this->dispatch('selectedSalesafterInvoice')->to(Table::class);
            $this->dispatch('toPrintComponent', $invoice->no)->to(Transaction::class);
            $this->dispatch('updateTotalAmount');
            $this->reset();
            if ($this->isCashback) {
                $this->dispatch('syncVoucherUsed', $this->voucherCashback->voucher);
            }
            $this->modalOpen = false;
            $this->isCashback = false;
            $this->voucherCashback = [];
            $this->dispatch('modalOpen', $this->modalOpen)->to(Table::class);
            $this->dispatch('focusInput')->to(Transaction::class);
            if (session()->has('Promo-Voucher-QTY'  . auth()->user()->id)) {
                $this->dispatch('syncVoucher', $this->random);
            }
            $this->clearSession();
            DB::commit();
            $this->dispatch('refreshInvoice');
        } catch (\Exception $e) {
            // dd($e);
            $this->alert('error', 'Error: ' . $e->getMessage(), [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            Log::debug($e);
            DB::rollback();
        }
    }

    // #[On('prinTo')]
    // public function printDialog($no)
    // {
    //     return redirect()->route('welcome.print', ['no' => $no]);
    // }

    #[On('reRender')]
    public function refreshKey()
    {
        $this->refreshKey++;
    }

    public function clearSession()
    {
        session()->forget('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueCheapest' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id);
        session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
        session()->forget('Promo-Voucher-Value' . auth()->user()->id);
        session()->forget('Promo-Voucher-ValueFulfil' . auth()->user()->id);
        session()->forget('Promo-GWP-FreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-CheapestItem' . auth()->user()->id);
        session()->forget('PromoBundlingFulfill' . auth()->user()->id);
        session()->forget('PromoExclude' . auth()->user()->id);
        session()->forget('member');
    }


    public function randomVoc()
    {
        $randomString = Str::random(5);
        $randomInt = mt_rand(10000, 99999);

        $randomStringAndInt = $randomString . $randomInt;

        if (strlen($randomStringAndInt) < 13) {
            $randomStringAndInt .= str_pad(mt_rand(1, 999), 13 - strlen($randomStringAndInt), '0', STR_PAD_LEFT);
        }

        $this->random = $randomStringAndInt;
    }

    #[On('tosync')]
    public function tosync($invoiceData, $syncItems, $checkItems)
    {
        $this->dispatch('sync', $invoiceData, $syncItems, $checkItems);
        $this->dispatch('reRender');
    }

    #[On('sync')]
    public function sync($invoiceData, $syncItems, $checkItems)
    {
        $getsales = DetailInvoice::where('invoice', $invoiceData['no'])->first();
        $idsales = $getsales->id_sales;
        $date = date_create($invoiceData['date']);
        $formattedDate = date_format($date, 'Y-m-d');
        $currentDate = Carbon::now()->format('Y-m-d');
        $invoice = ModelsInvoice::where('no', $invoiceData['no'])->first();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $url = $setting->url;

        if ($invoice->payment === "Multi") {
            $note = json_decode($invoice['note'], true);
            $cash = $note['cash'];
            $card = $note['transfer'];
            $cashAccount = $setting->cashacc;
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Card") {
            $note = json_decode($invoice['note'], true);
            $cash = 0;
            $card = $note['transfer'];
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        } elseif ($invoice->payment === "Cash") {
            $cash = $invoice->must_paid;
            $card = 0;
            $cashAccount =  $setting->cashacc;
            $transferAccount = '';
        } elseif ($invoice->payment === "Qris") {
            $cash = 0;
            $card = $invoice->must_paid;
            $cashAccount = '';
            $transferAccount = $setting->cardacc;
        }

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        if ($invoice->sandbox == 'Y') {
            foreach ($checkItems as $item) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "\"ItemCode\" ",
                    "From" => "OITM",
                    "Where" => "\"ItemCode\"='" . $item['ItemCode'] . "';",
                ]);
                $jsonData1 = $response->json();
                $itemcode = $item['ItemCode'];
                if ($jsonData1[0]['ItemCode'] == '') {
                    $response2 = Http::post($url . '/api/search', [
                        "Select" => "\"CodeBars\" , \"ItemCode\", \"ItemName\"",
                        "From" => "OITM",
                        "Where" => "\"CodeBars\"='" . $item['CodeBars'] . "';",
                    ]);
                    $jsonData2 = $response2->json();
                    if ($jsonData2[0]['CodeBars'] != '') {
                        $item = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('barcode', $jsonData2[0]['CodeBars'])->get();
                        if ($item->count() > 1) {
                            $existitem = DB::table('Luv2_item')
                                ->where('barcode', $jsonData2[0]['CodeBars'])
                                ->whereNot('code', $itemcode)
                                ->first();

                            DB::table('Luv2_item')
                                ->where('code', $itemcode)
                                ->where('barcode', $jsonData2[0]['CodeBars'])
                                ->delete();

                            DB::table('Luv2_item_pricelist')
                                ->where('item_code', $itemcode)
                                ->delete();

                            DB::table('Luv2_detailinvoice')
                                ->where('invoice', $invoiceData['no'])
                                ->where('code', $itemcode)
                                ->update([
                                    'code' => $existitem->code,
                                    'name' => $existitem->name
                                ]);
                        } else {
                            $item = DB::table('Luv2_item')->where('barcode', $jsonData2[0]['CodeBars'])->first();
                            $itemprice = DB::table('Luv2_item_pricelist')->where('item_code', $item->code)->first();
                            $detailinvoice = DB::table('Luv2_detailinvoice')->where('invoice', $invoiceData['no'])->where('code', $itemcode)->first();
                            if ($item) {
                                DB::table('Luv2_item')
                                    ->where('barcode', $jsonData2[0]['CodeBars'])
                                    ->update([
                                        'code' => $jsonData2[0]['ItemCode'],
                                        'name' => $jsonData2[0]['ItemName']
                                    ]);
                            }

                            if ($itemprice) {
                                DB::table('Luv2_item_pricelist')
                                    ->where('item_code', $item->code)
                                    ->update(['item_code' => $jsonData2[0]['ItemCode']]);
                            }

                            if ($detailinvoice) {
                                DB::table('Luv2_detailinvoice')
                                    ->where('invoice', $invoiceData['no'])
                                    ->where('code', $itemcode)
                                    ->update([
                                        'code' => $jsonData2[0]['ItemCode'],
                                        'name' => $jsonData2[0]['ItemName']
                                    ]);
                            }
                        }
                    }
                }
            }

            $cartData = DetailInvoice::where('invoice', $invoiceData['no'])->get();
            foreach ($cartData as $cart) {
                $syncItemsAfterchange[] = [
                    'ItemCode' => $cart->code,
                    'Quantity' => $cart->qty,
                    'UnitPrice' => $cart->nprice,
                    'LineTotal' => $cart->total_price,
                    'WhsCode' => $setting->wh_code,
                    'SBU' => $setting->sbu,
                ];
            }

            $lines = [];
            foreach ($syncItemsAfterchange as $item) {
                $lines[] = $item;
            }

            $commentcode = $user->whs_code . '/' . $invoiceData['no'] . '/' . $user->name;

            $data = [
                "CardCode" => $setting->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $lines,
            ];
            try {
                $client = new Client();
                $response = $client->post($setting->url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($data, $responseData);
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = ModelsInvoice::where('no', $invoiceData['no'])->first();
                    $invoice->sync = 'Y';
                    $invoice->sandbox = 'N';
                    DetailInvoice::where('invoice', $invoiceData['no'])->update(['sandbox' => 'N']);
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } catch (\Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $lines = [];
            foreach ($syncItems as $item) {
                $lines[] = $item;
            }
            $commentcode = $user->whs_code . '/' . $invoiceData['no'] . '/' . $user->name;

            $data = [
                "CardCode" => $setting->cardcode,
                "CntctCode" => "0",
                "NumAtCard" => "0",
                "DocDate" => $formattedDate,
                "DocDueDate" => $formattedDate,
                "TaxDate" => $formattedDate,
                "SlpCode" => $idsales,
                "Comments" => $commentcode,
                "BPLId" => $setting->bpl_id,
                "CashAccount" => $cashAccount,
                "CashSum" => $cash,
                "TransferAccount" => $transferAccount,
                "TransferSum" => $card,
                "TransferDate" => $currentDate,
                "DocType" => "C",
                "Lines" => $lines,
            ];
            try {
                $client = new Client();
                $response = $client->post($setting->url . '/api/addarinvoice', [
                    'headers' => [
                        'Content-Type' => 'application/json',
                    ],
                    'json' => $data,
                ]);

                $responseBody = $response->getBody()->getContents();
                $responseData = json_decode($responseBody, true);
                $errorCode = $responseData['ErrorCode'];
                // dd($data, $responseData);
                if ($errorCode !== 0) {
                    $this->alert('warning', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                } else {
                    $invoice = ModelsInvoice::where('no', $invoiceData['no'])->first();
                    $invoice->sync = 'Y';
                    $invoice->save();
                    $this->alert('success', $responseData['Message'], [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } catch (\Exception $e) {
                $this->alert('error', 'No Internet Connection to Sync', [
                    'position' => 'top-end',
                    'timer' => 5000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
        $this->dispatch('reloadTheInv');
    }

    public function updatedCash()
    {
        $cashWithoutDots = str_replace('.', '', $this->cash);
        $cashFloat = (float) $cashWithoutDots;
        $this->transfer = $this->totalAmount - $cashFloat;
        if ($this->cash == '' || $this->cash == 0) {
            $this->cashfulfil = false;
        } else {
            $this->cashfulfil = true;
        }
    }

    public function updatedPayment()
    {
        $paymentWithoutDots = str_replace('.', '', $this->payment);
        $paymentFloat = (float) $paymentWithoutDots;

        // Use totalWithService if service is enabled, otherwise use totalAmount
        $totalToUse = $this->isEnableService ? $this->totalWithService : $this->totalAmount;
        $this->change = $paymentFloat - $totalToUse;

        if ($this->payment == '' || $this->payment == 0) {
            $this->paymentfulfil = false;
        } else {
            $this->paymentfulfil = true;
        }
    }


    #[On('updateTotalAmount')]
    public function updateTotalAmount()
    {
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $this->totalAmount = $carts->sum('total_price');

        // Get company settings and calculate service amount if enabled
        $this->company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
        $this->isEnableService = ($this->company && $this->company->service === 'Y');
        if ($this->isEnableService) {
            if ($this->customServicePercent === null) {
                $servicePercent = floatval($this->company->nservice);
                if ($servicePercent < 0 || $servicePercent === '') {
                    $servicePercent = 0;
                }
                $this->customServicePercent = $servicePercent;
            }
            $this->calculateServiceAmount();
        } else {
            $this->totalWithService = $this->totalAmount;
        }

        $this->dispatch('updateTotalAmountBrowser');
    }

    public function render()
    {
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $negara = DB::table('Luv2_country')
            ->leftJoin('Luv2_customerorigin', function ($join) {
                $join->on('Luv2_country.id', '=', 'Luv2_customerorigin.id_negara')
                    ->where('Luv2_customerorigin.company_code', auth()->user()->company_code)
                    ->where('Luv2_customerorigin.whs_code', auth()->user()->whs_code);
            })
            ->select(
                'Luv2_country.*',
                DB::raw('COUNT("Luv2_customerorigin".id) as total_customers')
            )
            ->groupBy('Luv2_country.id', 'Luv2_country.name', 'Luv2_country.code')
            ->orderBy('total_customers', 'desc')
            ->get();
        return view('livewire.cashier.invoice', [
            'carts' => $carts,
            'negara' => $negara,
        ]);
    }

    public function resetPayment()
    {
        $this->payment = 0;
        $this->change = 0;
        $this->resetValidation();
        $this->modalOpen = false;
        $this->dispatch('modalInvoiceOpenorClose', $this->modalOpen)->to(Transaction::class);
    }

    #[On('closeModalInvoice')]
    public function closeModalInvoice()
    {
        $this->modalOpen = false;
        $this->dispatch('toCloseModalInvoice')->to(Table::class);
    }

    public function print()
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);
            $promo = DB::table('Luv2_promo')->where('invoice', $this->invoice->no)->first();
            $voucher = [];
            if ($promo) {
                $voucher = DB::table('Luv2_promo_voucher')->where('no', $promo->no)->first();
            }
            // Set the font size
            $printer->setTextSize(1, 1);

            $cashier = $this->cashier;
            $now = Carbon::now();

            // Format the current date and time
            $formattedDateTime = $now->format('d/m/Y H:i:s');

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier : " . $cashier->name;
            $billNo = "Bill No : " . $this->invoice->no;
            $date = "Date    : " . $formattedDateTime;
            if (!isset($this->selectedSales['position']) || $this->selectedSales['position'] === '') {
                $handledBy = "Handled by : " . $this->selectedSales['name'];
            } else {
                $handledBy = "Handled by : " . $this->selectedSales['position'];
            }
            $discount = 0;
            if ($this->invoice->payment === "Multi") {
                $note = json_decode($this->invoice['note'], true);
                // Check if the 'cash' key exists in the decoded note data
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            }
            if ($this->invoice->payment === "Card") {
                $note = json_decode($this->invoice['note'], true);
                // Check if the 'cash' key exists in the decoded note data
                $cash = 0;
                $card = $note['transfer'];
                $change = $this->invoice->change;
            }
            if ($this->invoice->payment === "Cash") {
                $cash = $this->invoice->paid;
                $card = 0;
                $change = $this->invoice->change;
            }
            if ($this->invoice->payment === "Qris") {
                $cash = 0;
                $card = $this->invoice->must_paid;
                $change = 0;
            }
            // Define your item list (replace this with your actual item data)
            $items = [];
            foreach ($this->storeitem as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $items[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                    'nprice' => $cartItem['nprice'],
                    'discount' => $cartItem['disc'],
                ];
            }
            $subTotal = array_reduce($items, function ($carry, $item) {
                if ($item['nprice'] >= 0) {
                    return $carry + $item['nprice'] * $item['qty'];
                }
                return $carry;
            }, 0);

            $grandTotal = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            if ($this->invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $this->invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
                $grandTotal -=  $vouchervalue;
            }

            // $discount = array_reduce($items, function ($carry, $item) {
            //     if ($item['price'] < 0) {
            //         return $carry + (-$item['price']) * $item['qty'];
            //     } else {
            //         return $carry + ($item['nprice'] - $item['price']) * $item['qty'];
            //     }
            // }, 0);

            $discount = array_reduce($items, function ($carry, $item) {
                return ($carry + $item['nprice'] - $item['price']);
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if ($this->invoice->id_member != null || $this->invoice->id_member != '') {
                $member = Member::where('code', $this->invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$date\n$membername\n");
            } else {
                $printer->text("$manager\n$billNo\n$date\n");
            }
            // if ($voucher) {
            //     $printer->text("Voucher : " . $voucher->voucher . "\n");
            // }
            $printer->text("---------------------------------------\n");

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            $totalSelisih = 0; // Initialize the total variable

            foreach ($items as $item) {
                if ($item['discount'] === null || $item['discount'] == 0) {
                    if ($item['price'] < 0) {
                        $formattedPrice = '(' . number_format($item['price'] * $item['qty'], 2) . ')'; // Ensure the negative number is properly formatted
                    } else {
                        $formattedPrice = number_format($item['price'] * $item['qty'], 2);
                    }
                    $printer->text(sprintf(
                        "%-15s %5d   %12s\n",
                        $item['name'],
                        $item['qty'],
                        $formattedPrice
                    ));
                } else {
                    $selisih = $item['nprice'] - $item['price'];
                    $printer->text(sprintf(
                        "%-15s %5d   %12s\n",
                        $item['name'],
                        $item['qty'],
                        number_format($item['nprice'] * $item['qty'], 2)
                    ));
                    $printer->setFont(Printer::FONT_B);
                    $printer->setTextSize(1, 1);
                    $printer->text(sprintf(
                        "%36s\n",
                        "(" . number_format($selisih * $item['qty'], 2) . ")"
                    ));

                    $totalSelisih += $selisih * $item['qty'];
                }
            }

            // Print Information card
            if ($this->invoice->payment === "Card" || $this->invoice->payment === "Multi") {
                $note = json_decode($this->invoice['note'], true);
                $printer->text("---------------------------------------\n");
                $name = "Name        : " . $note['nama_pemegang_kartu'];
                $nocard = "Card Number : " . $note['nomor_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }

            $printer->setJustification(0);

            $printer->text("---------------------------------------\n");
            $padding = 14; // Number of spaces before the text
            $subTotal = "SubTotal   : " . number_format($subTotal, 2);
            $discount = "Discount   : " . number_format($totalSelisih, 2);
            $grandTotal = "GrandTotal : " . number_format($grandTotal, 2);
            if ($this->invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $this->invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
                $voucherdisc = "Cashback   : " . number_format($vouchervalue, 2);
                $rightAlignedVoucher = str_repeat(' ', $padding) . $voucherdisc;
            }

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $rightAlignedDiscount = str_repeat(' ', $padding) . $discount;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;

            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedDiscount\n");
            if ($this->invoice->cashback !== 'N') {
                $printer->text("$rightAlignedVoucher\n");
            }
            $printer->text("$rightAlignedGrandTotal\n");

            // $printer->text("---------------------------------------\n");
            $cash = "Cash       : " . number_format($cash, 2);
            $card = "Card       : " . number_format($card, 2);
            $change = "Change     : " . number_format($this->invoice->change, 2);
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");

            // Reset text justification to default (centered)
            $printer->setJustification();

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            //Voucher
            if ($voucher) {
                $voucherFromDate = Carbon::parse($promo->voucher_from_date)->format('d - M - Y');
                $voucherToDate = Carbon::parse($promo->voucher_to_date)->format('d - M - Y');
                $printer->text("---------------------------------------\n");
                $printer->text("Voucher Cashback : " . $voucher->voucher . "\n");
                $printer->text("Valid From       : " . $voucherFromDate . "\n");
                $printer->text("Valid Until      : " . $voucherToDate . "\n");
            }

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n"); // Print each line with a newline character
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            $this->dispatch('printernotfound')->to(Transaction::class);
        }
    }

    public function applyVoucher()
    {
        $voucher = DB::table('Luv2_promo_voucher')->where('voucher', $this->searchvoucher)->first();
        if ($voucher) {
            $joinedVoucher = DB::table('Luv2_promo_voucher')
                ->join('Luv2_promo', 'Luv2_promo.no', '=', 'Luv2_promo_voucher.no')
                ->where('Luv2_promo_voucher.no', $voucher->no)
                ->where('Luv2_promo_voucher.voucher', $this->searchvoucher)
                ->select(
                    'Luv2_promo_voucher.voucher as voucher_code',
                    'Luv2_promo_voucher.value',
                    'Luv2_promo_voucher.used',
                    'Luv2_promo.*'
                )
                ->first();
            $this->voucherCashback = $joinedVoucher;
            if ($joinedVoucher) {
                $voucherToDate = Carbon::parse($joinedVoucher->voucher_to_date);
                if ($joinedVoucher->used == 'N') {
                    if ($voucherToDate->isPast()) {
                        $this->message = 'Voucher has expired!';
                    } else {
                        if (!$this->voucherApplied) {
                            $this->dispatch('updatetotalAmount', $joinedVoucher);
                        } else {
                            $this->message = 'You cant applied same voucher twice !';
                        }
                    }
                } else {
                    $this->message = 'Voucher is already used!';
                }
            } else {
                $this->message = 'Input a valid voucher !';
            }
        } else {
            $this->message = 'Input a valid voucher !';
        }
    }

    public function updatedsearchvoucher()
    {
        $this->voucherCashback = [];
        $this->message = '';
        $this->voucherApplied = false;
        $user = Auth::user();
        $carts = Cart::where('user_code', $user->code)
            ->where('lostsale', 'N')->get();
        $this->totalAmount = $carts->sum('total_price');
    }

    #[On('updatetotalAmount')]
    public function updatedtotalAmount($data)
    {
        $cashWithoutDots = str_replace('.', '', $this->cash);
        $cashFloat = (float) $cashWithoutDots;
        $vouchervalue = (float) $data['value'];
        $this->totalAmount = $this->totalAmount - $vouchervalue;
        $this->transfer = $this->totalAmount - $cashFloat;
        $this->isCashback = true;
        $this->voucherApplied = true;
    }

    #[On('modalInvoiceOpenorClose')]
    public function modalInvoiceOpenorClose($data)
    {

        $this->modalOpen = $data;

        $this->dispatch('modalOpen', $this->modalOpen)->to(Table::class);
    }

    #[On('F1ModalOpen')]
    public function f1ModalOpen()
    {
        $this->paymentOption = 'cash';
    }
    #[On('F2ModalOpen')]
    public function f2ModalOpen()
    {
        $this->paymentOption = 'qris';
    }
    #[On('F3ModalOpen')]
    public function f3ModalOpen()
    {
        $this->paymentOption = 'card';
    }
    #[On('F4ModalOpen')]
    public function f4ModalOpen()
    {
        $this->paymentOption = 'multi';
    }
}
