<?php

namespace App\Livewire\Cashier;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class Index extends Component
{

    public $istutorials = false;


    public function mount()
    {
        $user = Auth::user();
        $company = DB::table('Luv2_company')->where('code', $user->company_code)->first();
    
        if (
            $user->onboarding_step === 'Toko' &&
            $company &&
            $company->verified_at &&
            Carbon::parse($company->verified_at)->gt(now()->subDays(2)) &&
            !Carbon::parse($company->verified_at)->isToday()
        ) {
            $this->dispatch('welcomeModalGreeting');
        }
    }

    #[On('closeModalGreetingAwal')]
    public function testara()
    {
        $this->dispatch('closeModalGreetingAwalFrontend');
    }
    

    #[On('afterCloseGreeting')]
    public function afterCloseGreeting()
    {
        $userId = Auth::id();
        $greetings = DB::table('Luv2_tutorial')
            ->where('id_user', auth()->user()->id)
            ->where('menu', 'Greeting')
            ->update(['active' => 'N']);

        $this->istutorials = true;
        $tutorials = DB::table('Luv2_tutorial')
            ->where('id_user', $userId)
            ->where('menu', 'Cashier')
            ->first();
        if ($tutorials && $tutorials->active === 'Y') {
            $this->istutorials = true;
            $this->dispatch('afterChangeStatusGreeting');
        }
    }

    #[On('afterSaveGreeting')]
    public function afterSaveGreeting()
    {
        $this->dispatch('afterSaveGreetingFrontendCloseModal');
        $this->dispatch('afterCloseGreeting');
    }



    public function render()
    {
        $userId = Auth::id();

        $greetings = DB::table('Luv2_tutorial')
            ->where('id_user', $userId)
            ->where('menu', 'Greeting')
            ->first();

        if ($greetings && $greetings->active === 'Y') {
            $this->dispatch('openModalGreeting');
        } elseif ($greetings && $greetings->active === 'N') {
            $tutorials = DB::table('Luv2_tutorial')
                ->where('id_user', $userId)
                ->where('menu', 'Cashier')
                ->first();
            if ($tutorials && $tutorials->active === 'Y') {
                $this->istutorials = true;
            }
        }
        return view('livewire.cashier.index');
    }
}
