<?php

namespace App\Livewire\Cashier;

use App\Models\Cart;
use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\SandboxItem;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Livewire\Attributes\Rule;
use Livewire\Component;

class Additem extends Component
{
    public $codeNull = false;

    public $actionButton = "store";

    #[Rule('required', message: 'The Item Code field is required.')]
    #[Rule('min:3', message: 'The Item Code field must be at least 3 characters.')]
    #[Rule('unique:Luv2_item,code', message: 'The Item Code has been taken and must be unique.')]
    public string $itemcode;

    #[Rule('required', message: 'The Item Name field is required.')]
    #[Rule('min:4', message: 'The Item Name field must be at least 4 characters.')]
    public string $itemname = '';

    #[Rule('required', message: 'The Item Price field is required.')]
    #[Rule('numeric', message: 'The Item Price field must be a number.')]
    public string $itemprice = '';


    #[Rule('required', message: 'The Item Barcode field is required.')]
    #[Rule('min:4', message: 'The Item Barcode field must be at least 4 characters.')]
    #[Rule('unique:Luv2_item,barcode', message: 'The Item Barcode has been taken and must be unique.')]
    public string $itemcodebars = '';
    public $errMsg = '';

    public $isSandbox = false;

    public function updatedcodeNull($value)
    {
        if ($value) {
            $this->itemcode = $this->itemcodebars;
        } else {
            $this->itemcode = '';
            $this->itemcode = $this->itemcode;
        }
    }

    public function store()
    {
        DB::beginTransaction();

        try {
            $this->validate([
                'itemcode' => 'required|min:3|unique:Luv2_item,code',
                'itemcodebars' => 'unique:Luv2_item,barcode'
            ]);

            $user = Auth::user();
            $wh = DB::table('Luv2_warehouse')->where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
    
            $pricelist = $wh->pricelist_code;
            $cart = DB::table('Luv2_carts')
            ->where('user_code', $user->code)
            ->where('company_code', $user->company_code)->where('whs_code', $wh->code)->get();
            DB::table('Luv2_item')->insert([
                'company_code' => $user->company_code,
                'code' => $this->itemcode,
                'barcode' => $this->itemcodebars,
                'name' => $this->itemname . ' (Sandbox)',
                'status' => 'Sandbox', //Sandbox
                'brand_code' => '',
                'category_code' => '',
                'size_code' => '',
                'inventory' => 'Y',
                'sales' => 'Y',
                'purchase' => 'Y',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);

            DB::table('Luv2_item_pricelist')->insert([
                'company_code' => $user->company_code,
                'item_code' => $this->itemcode,
                'pricelist_code' => $pricelist,
                'price' => $this->itemprice,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            DB::table('Luv2_carts')->insert([
                'company_code' => $user->company_code,
                'whs_code' => $wh->code,
                'code' => $this->itemcode,
                'barcode' => $this->itemcodebars,
                'name' => $this->itemname,
                'price' => $this->itemprice,
                'nprice' => $this->itemprice,
                'sandbox' => 'Y',
                'linenum' => $cart->count() + 1,
                'discount' => 0,
                'user_code' => $user->code,
                'qty' => 1,
                'total_price' => $this->itemprice,
                'promo' => 0,
                'promo_tipe' => 0,
                'pack' => 0,
                'benefit' => 0,
                'grouping' => 0,
                'unit' => 0,
                'qty_unit' => 1,
                'cost' => $this->itemprice,
                'consignment' => 'N',
                'shared_margin' => 0,
            ]);

            // $sandbox = SandboxItem::create([
            //     'code' => $this->itemcode,
            //     'name' => $this->itemname,
            //     'barcode' => $this->itemcodebars,
            //     'price' => $this->itemprice,
            // ]);

            DB::commit();

            $this->dispatch('closeModal');
            $this->dispatch('cart-created')->to(Table::class);
            $this->dispatch('updatePrice')->to(Transaction::class);
            $this->dispatch('updateSearch')->to(Transaction::class);


            $this->reset();
        } catch (ValidationException $e) {
            // $this->errMsg = "Validation Failed : " . $e->getMessage();
            $this->errMsg = "Cant Create Sandbox Item Because there are Validation Failed";

        } catch (\Exception $e) {
            dd($e);
            DB::rollBack();
            // Handle other exceptions if needed
            // $this->errMsg = "An unexpected error occured : " . $e->getMessage();
            $this->errMsg = "Cant Create Sandbox Item Because An unexpected error occured";

        }
    }

    public function render()
    {
        return view('livewire.cashier.additem');
    }

    public function resetModal()
    {
        $this->itemcode = '';
        $this->itemname = '';
        $this->itemcodebars = '';
        $this->itemprice = '';
        $this->errMsg = '';
        $this->resetValidation();
    }

    public function mount()
    {
        $user = Auth::user();
        $setting = Warehouse::where('company_code', $user->company_code)->where('code', $user->whs_code)->first();
        $sandbox = $setting->sandbox;

        if($sandbox == 'Y'){
            $this->isSandbox = true;
        }
    }

    public function buatItem()
    {
        session(['insertType' => 'Item', 'fromCashier' => auth()->id(), 'toCashier' => auth()->id()]);
        return redirect()->route('item.input');
    }
}
